/**
 * ===========================================================
 * LibRepository : a free Java content repository access layer
 * ===========================================================
 *
 * Project Info:  http://reporting.pentaho.org/librepository/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * NameGenerator.java
 * ------------
 */

package org.pentaho.reporting.libraries.repository;

/**
 * A name generator is a general service to generate unique names within
 * an content location.
 *
 * @author Thomas Morgner
 */
public interface NameGenerator
{
  /**
   * Generates a new name for the location. The name-generator may use both the name-hint and mimetype to compute
   * the new name.
   *
   * @param nameHint the name hint, usually a identifier for the new filename.
   * @param mimeType the mime type of the new filename. Usually used to compute a suitable file-suffix.
   * @return the generated name, never null.
   * @throws ContentIOException if the name could not be generated for any reason.
   */
  public String generateName(String nameHint, String mimeType)
      throws ContentIOException;
}
