//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QREGION_C_H
#define QREGION_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT QRegionH QRegion_create();
C_EXPORT void QRegion_destroy(QRegionH handle);
C_EXPORT QRegionH QRegion_create2(int x, int y, int w, int h, QRegion::RegionType t);
C_EXPORT QRegionH QRegion_create3(PRect r, QRegion::RegionType t);
C_EXPORT QRegionH QRegion_create4(const QPolygonH pa, Qt::FillRule fillRule);
C_EXPORT QRegionH QRegion_create5(const QRegionH region);
C_EXPORT QRegionH QRegion_create6(const QBitmapH bitmap);
C_EXPORT bool QRegion_isEmpty(QRegionH handle);
C_EXPORT bool QRegion_contains(QRegionH handle, const QPointH p);
C_EXPORT bool QRegion_contains2(QRegionH handle, PRect r);
C_EXPORT void QRegion_translate(QRegionH handle, int dx, int dy);
C_EXPORT void QRegion_translate2(QRegionH handle, const QPointH p);
C_EXPORT void QRegion_translated(QRegionH handle, QRegionH retval, int dx, int dy);
C_EXPORT void QRegion_translated2(QRegionH handle, QRegionH retval, const QPointH p);
C_EXPORT void QRegion_unite(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_unite2(QRegionH handle, QRegionH retval, PRect r);
C_EXPORT void QRegion_intersect(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_intersect2(QRegionH handle, QRegionH retval, PRect r);
C_EXPORT void QRegion_subtract(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_eor(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_united(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_united2(QRegionH handle, QRegionH retval, PRect r);
C_EXPORT void QRegion_intersected(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_intersected2(QRegionH handle, QRegionH retval, PRect r);
C_EXPORT void QRegion_subtracted(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT void QRegion_xored(QRegionH handle, QRegionH retval, const QRegionH r);
C_EXPORT bool QRegion_intersects(QRegionH handle, const QRegionH r);
C_EXPORT bool QRegion_intersects2(QRegionH handle, PRect r);
C_EXPORT void QRegion_boundingRect(QRegionH handle, PRect retval);
C_EXPORT void QRegion_setRects(QRegionH handle, PRect rect, int num);
C_EXPORT int QRegion_numRects(QRegionH handle);
#if defined BINUX
C_EXPORT Region QRegion_handle(QRegionH handle);
#endif
#if defined MSWINDOWS
C_EXPORT HRGN QRegion_handle2(QRegionH handle);
#endif
#if defined DARWIN
C_EXPORT RgnHandle QRegion_handle3(QRegionH handle);
C_EXPORT RgnHandle QRegion_handle4(QRegionH handle, bool p1);
C_EXPORT void * QRegion_toHIMutableShape(QRegionH handle);
C_EXPORT void QRegion_fromHIShapeRef(QRegionH retval, const void * shape);
#endif
#if defined QTOPIA
C_EXPORT void* QRegion_handle5(QRegionH handle);
#endif

#endif
