//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QCOREAPPLICATION_C_H
#define QCOREAPPLICATION_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QCoreApplicationH QCoreApplication_create(int* argc, char** argv);
C_EXPORT void QCoreApplication_destroy(QCoreApplicationH handle);
C_EXPORT void QCoreApplication_arguments(QStringListH retval);
C_EXPORT void QCoreApplication_setAttribute(Qt::ApplicationAttribute attribute, bool on);
C_EXPORT bool QCoreApplication_testAttribute(Qt::ApplicationAttribute attribute);
C_EXPORT void QCoreApplication_setOrganizationDomain(PWideString orgDomain);
C_EXPORT void QCoreApplication_organizationDomain(PWideString retval);
C_EXPORT void QCoreApplication_setOrganizationName(PWideString orgName);
C_EXPORT void QCoreApplication_organizationName(PWideString retval);
C_EXPORT void QCoreApplication_setApplicationName(PWideString application);
C_EXPORT void QCoreApplication_applicationName(PWideString retval);
C_EXPORT void QCoreApplication_setApplicationVersion(PWideString version);
C_EXPORT void QCoreApplication_applicationVersion(PWideString retval);
C_EXPORT QCoreApplicationH QCoreApplication_instance();
C_EXPORT int QCoreApplication_exec();
C_EXPORT void QCoreApplication_processEvents(unsigned int flags);
C_EXPORT void QCoreApplication_processEvents2(unsigned int flags, int maxtime);
C_EXPORT void QCoreApplication_exit(int retcode);
C_EXPORT bool QCoreApplication_sendEvent(QObjectH receiver, QEventH event);
C_EXPORT void QCoreApplication_postEvent(QObjectH receiver, QEventH event);
C_EXPORT void QCoreApplication_postEvent2(QObjectH receiver, QEventH event, int priority);
C_EXPORT void QCoreApplication_sendPostedEvents(QObjectH receiver, int event_type);
C_EXPORT void QCoreApplication_sendPostedEvents2();
C_EXPORT void QCoreApplication_removePostedEvents(QObjectH receiver);
C_EXPORT void QCoreApplication_removePostedEvents2(QObjectH receiver, int eventType);
C_EXPORT bool QCoreApplication_hasPendingEvents();
C_EXPORT bool QCoreApplication_notify(QCoreApplicationH handle, QObjectH p1, QEventH p2);
C_EXPORT bool QCoreApplication_startingUp();
C_EXPORT bool QCoreApplication_closingDown();
C_EXPORT void QCoreApplication_applicationDirPath(PWideString retval);
C_EXPORT void QCoreApplication_applicationFilePath(PWideString retval);
C_EXPORT qint64 QCoreApplication_applicationPid();
C_EXPORT void QCoreApplication_setLibraryPaths(const QStringListH p1);
C_EXPORT void QCoreApplication_libraryPaths(QStringListH retval);
C_EXPORT void QCoreApplication_addLibraryPath(PWideString p1);
C_EXPORT void QCoreApplication_removeLibraryPath(PWideString p1);
C_EXPORT void QCoreApplication_installTranslator(QTranslatorH messageFile);
C_EXPORT void QCoreApplication_removeTranslator(QTranslatorH messageFile);
C_EXPORT void QCoreApplication_translate(PWideString retval, const char* context, const char* key, const char* disambiguation, QCoreApplication::Encoding encoding);
C_EXPORT void QCoreApplication_translate2(PWideString retval, const char* context, const char* key, const char* disambiguation, QCoreApplication::Encoding encoding, int n);
C_EXPORT void QCoreApplication_flush();
#if defined BINUX || DARWIN || QTOPIA
C_EXPORT void QCoreApplication_watchUnixSignal(int signal, bool watch);
#endif
C_EXPORT EventFilter QCoreApplication_setEventFilter(QCoreApplicationH handle, EventFilter filter);
C_EXPORT bool QCoreApplication_filterEvent(QCoreApplicationH handle, void* message, long* result);
C_EXPORT void QCoreApplication_quit();
#if defined MSWINDOWS
C_EXPORT bool QCoreApplication_winEventFilter(QCoreApplicationH handle, MSG* message, long* result);
#endif

#endif
