#ifndef __INCLUDED_PHIDGETS_SERVOMOTOR_H__
#define __INCLUDED_PHIDGETS_SERVOMOTOR_H__

#include <phidgets/phidgets.h>

typedef struct PhidgetServoMotor_t {
  unsigned short min_pulse;
  unsigned short max_pulse;
  float factor;
  unsigned int position;
} PhidgetServoMotor;

void phidget_reset_PhidgetServoMotor(PhidgetServoMotor* const servo);

phidget_return phidget_servomotor_set_parameters(PhidgetServoMotor* const servo,
    unsigned short const min, unsigned short const max, float const factor);

#endif // __INCLUDED_PHIDGETS_SERVOMOTOR_H__

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
