#ifndef _EFFECTUTIL_H
#define _EFFECTUTIL_H

#include "osl/state/numEffectState.h"
#include "osl/misc/carray.h"
#include "osl/container/pieceVector.h"

#include <iosfwd>
#include <cassert>

namespace osl
{
  namespace container
  {
    class PieceVector;
  }

  namespace effect_util
  {
  /**
   * EffectState を活用するためのメソッド
   * NumSimpleEffect などの公開インターフェースで
   * 使って書けるコード
   */
  struct EffectUtil
  {
    /**
     * PtypeO が Square にいると仮定した時にの利きを列挙.
     * 盤面が実際と違うと長い利きが不正確になる
     * @param InterestEmpty 空白のマスに興味があるか
     */
    template <class Function, bool InterestEmpty>
    static void forEachEffectOfPtypeO(const NumEffectState& state, Square, PtypeO,
				      Function& f);
    template <Player P, class Function, bool InterestEmpty>
    static void forEachEffectOfPtypeO(const NumEffectState& state, Square, Ptype,
				      Function& f);
    
    /**
     * 玉の素抜きなしに合法手でtargetに移動可能かを判定
     * @param king 玉 (玉で取る手は考えない)
     * @return 移動可能な駒があれば，安全な駒を一つ．なければ Piece::EMPTY()
     * @see osl::move_classifier::PawnDropCheckmate
     */
    template <Player P>
    static Piece safeCaptureNotByKing(const NumEffectState& state, Square target,
				    Piece king);
    static Piece safeCaptureNotByKing(Player P, const NumEffectState& state, 
				      Square target)
    {
      const Piece king = state.kingPiece(P);
      if (P == BLACK)
	return safeCaptureNotByKing<BLACK>(state, target, king);
      else
	return safeCaptureNotByKing<WHITE>(state, target, king);
    }
    /**
     * forEachEffect の Player のtemplate 引数を通常の引数にしたバージョン
     * @param P 探す対象の駒の所有者
     * @param pos に利きのある駒を探す
     */
    template <class Action>
    static void forEachEffect(Player P, const NumEffectState& state, Square pos, 
			      Action& a)
    {
      if (P == BLACK)
	state.template forEachEffect<BLACK>(pos,a);
      else
	state.template forEachEffect<WHITE>(pos,a);
    }
    /**
     * target に利きのあるPieceをoutに格納する
     */
    static void findEffect(Player P, const NumEffectState& state, Square target,
			   container::PieceVector& out);

    /**
     * state の position に ptypeo があった場合を仮定して，脅威をoutに集める
     */
    template <class EvalT>
    static void findThreat(const NumEffectState& state, Square position,
			   PtypeO ptypeo, PieceVector& out);

    template <class EvalT>
    struct FindThreat;
    struct SafeCapture;
  };

  } // namespace effect_util
  using effect_util::EffectUtil;
} // namespace osl

#endif /* _EFFECTUTIL_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
