/* ptypeOPositionVector.t.cc
 */
#include "osl/container/ptypeOPositionVector.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class PtypeOPositionVectorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PtypeOPositionVectorTest);
  CPPUNIT_TEST(testSort);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testSort();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PtypeOPositionVectorTest);

void PtypeOPositionVectorTest::testSort()
{
  Position dummy(1,1);
  {
    PtypeOPositionVector v;
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.sort();
    CPPUNIT_ASSERT_EQUAL(PPAWN, getPtype(v[2].first));
  }
  {
    PtypeOPositionVector v;
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, SILVER), dummy));
    v.sort();
    CPPUNIT_ASSERT_EQUAL(PAWN, getPtype(v[0].first));
    CPPUNIT_ASSERT_EQUAL(SILVER, getPtype(v[3].first));
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
