/* recordStack.cc
 */
#include "osl/search/recordStack.h"
#include <iostream>

osl::search::
RecordStack::RecordStack()
  : root_record(0)
{
  clear();
}

osl::search::
RecordStack::RecordStack(RecordStack const& r)
  : root_record(r.root_record)
{
  clear();
  assert(r.size()<=static_cast<size_t>(SEARCH_DEPTH_MAX));
  for(size_t i=1;i<r.size();i++){
    if(r.data[i]!=0){
      backup[i] = *(r.data[i]);
      // assert(backup.size()==i+1);
      data.push_back( &backup[i] );
    }
    else{
      data.push_back(0);
      backup[i] = 0;
    }
  }
}

void osl::search::
RecordStack::clear()
{
  data.clear();
  backup.fill(0);
  push(&root_record); 
}

#ifndef MINIMAL
void osl::search::
RecordStack::dump() const 
{
  for (size_t i=0; i<data.size(); ++i) {
    std::cerr << data[i];
    if (data[i])
      std::cerr << "\t" << *(data[i]);
    std::cerr << std::endl;
  }
}
#endif
/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
