/* legalMoves.cc
 */
#include "osl/move_generator/legalMoves.h"
#include "osl/move_classifier/moveAdaptor.h"
#include "osl/move_classifier/pawnDropCheckmate.h"
#include "osl/move_classifier/safeMove.h"
#include "osl/move_generator/allMoves.h"
#include "osl/move_generator/escape_.h"
#include "osl/container/moveVector.h"
#include "osl/effect_util/effectUtil.h"
#include <boost/foreach.hpp>

void osl::move_generator::
LegalMoves::generate(const NumEffectState& state, MoveVector& moves)
{
  if (state.inCheck())
  {
    // 王手がかかっている時は防ぐ手のみを生成
    GenerateEscapeKing::generate(state, moves);
  }
  else
  {
    // そうでなければ全ての手を生成
    MoveVector all_moves;
    GenerateAllMoves::generate(state.getTurn(), state, all_moves);
    // この指手は，玉の素抜きがあったり，打歩詰の可能性があるので
    // 確認が必要
    using namespace osl::move_classifier;
    BOOST_FOREACH(Move m, all_moves)
    {
      if (m.isDrop()
	  || PlayerMoveAdaptor<SafeMove>::isMember(state, m))
      {
	if (! PlayerMoveAdaptor<PawnDropCheckmate>::isMember(state, m))
	{
	  moves.push_back(m);
	}
      }
    }
  }
}

void osl::move_generator::
LegalMoves::generateWithFullUnpromotions(const NumEffectState& state, 
                                         MoveVector& moves)
{
  generate(state, moves);
  for (int i=0, iend=moves.size(); i<iend; ++i) {
    const osl::Move move = moves[i];
    if (move.hasIgnoredUnpromote(move.player()))
      moves.push_back(move.unpromote());
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
