
// Code partially copyright Edd Dawson 2007
//
// Boost Software License - Version 1.0 - August 17th, 2003
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


#include "libmesh_config.h"
#include "print_trace.h"

#if defined(HAVE_GCC_ABI_DEMANGLE) && defined(HAVE_GLIBC_BACKTRACE)

#include <iostream>
#include <string>
#include <execinfo.h> 
#include <cxxabi.h>

std::string abi_demangle(const char *name)
{
  int status = 0;
  char *d = 0;
  std::string fullname = name;
  size_t namestart = fullname.find('(');
  if (namestart == std::string::npos)
    return fullname;
  else
    namestart++;
  size_t nameend = fullname.find('+');
  if (nameend == std::string::npos ||
      nameend <= namestart)
    return fullname;
  std::string funcname = fullname.substr(namestart, nameend - namestart);
  std::string goodname = funcname;
  try { if ( (d = abi::__cxa_demangle(funcname.c_str(), 0, 0, &status)) ) goodname = d; }
  catch(...) {  }
  std::free(d);
/*
  std::string ret = fullname.substr(0, namestart);
  ret.append(goodname);
  ret.append(fullname.substr(nameend, fullname.length() - nameend));
  return ret;
*/
  return goodname;
}

void print_trace(void)
{
  void *addresses[10];
  char **strings;

  int size = backtrace(addresses, 10);
  strings = backtrace_symbols(addresses, size);
  std::cerr << "Stack frames: " << size << std::endl;
  for(int i = 0; i < size; i++)
    {
//      std::cerr << i << ": " << (int)addresses[i] << std::endl;
//      std::cerr << abi_demangle(strings[i]) << std::endl;
      std::cerr << i << ": "
                << abi_demangle(strings[i]) << std::endl;
    }
  free(strings);
}

#else

void print_trace(void) {}

#endif

#if 0 // MAC OS X code??

#include <dlfcn.h>
#include <cxxabi.h>
#include <iostream>
#include <string>
#include <cstdlib>
#include <cstring>

std::string abi_demangle(const char *name)
{
    int status = 0;
    char *d = 0;
    std::string ret = name;
    try { if ( (d = abi::__cxa_demangle(name, 0, 0, &status)) ) ret = d; }
    catch(...) {  }
    std::free(d);
    return ret;
}

void print_trace(void)
{
std::cerr << "Trying print_trace()" << std::endl;
    Dl_info info;
    void **frame = static_cast<void **>(__builtin_frame_address(0));
    void **bp = static_cast<void **>(*frame);
    void *ip = frame[1];

    while(bp && ip && dladdr(ip, &info))
    {
        std::cout << ip << ": " << abi_demangle(info.dli_sname) << " in " <<
info.dli_fname << '\n';

        if(info.dli_sname && !strcmp(info.dli_sname, "main")) break;

        ip = bp[1];
        bp = static_cast<void**>(bp[0]);
    }
    char *dlerr = dlerror();
    if (dlerr)
      std::cout << "dlerror() = " << dlerr << std::endl;
}

#endif
