package Locales::DB::Language::my;

# Auto generated from CLDR

$Locales::DB::Language::my::VERSION = '0.09';

$Locales::DB::Language::my::cldr_version = '2.0';

%Locales::DB::Language::my::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "ဘာသာစကား\ \-\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "နယ်ပယ်ဒေသ\ \-\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => 'မဟုတ်ဘူး',
        'yesstr' => 'ဟုတ်တယ်'
    },
);

%Locales::DB::Language::my::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'Aragonese',
    'ang'   => 'အင်္ဂလိပ်စာဟောင်း',
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'အာရေဗီ',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "အယောင်ဆောင်\ ဘာသာစကား",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'ဘာလီ',
    'bas'   => 'ဘာဆာ',
    'bat'   => "ဘော်လတစ်\ ဘာသာစကား",
    'be'    => 'ဘီလာရု',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'ဘူဂေးရီးယား',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'ဘင်္ဂါလီ',
    'bnt'   => 'Bantu',
    'bo'    => 'တိဘက်',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'ဘော့စ်နီးယား',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalan',
    'cad'   => 'Caddo',
    'cai'   => "အလယ်ပိုင်း\ အမေရိကန်\ အိန္ဒြိယ\ ဘာသာစကား",
    'car'   => 'Carib',
    'cau'   => "ကောက်ကေးရှပ်\ ဘာသာစကား",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'ချေချင်း',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'ချာရိုကီ',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "ပေါ်တူဂီ\ အခြေခံ\ အနောက်အိန္ဒြိယ\ ကျွန်းစုသား\ သို့မဟုတ်\ ဗန်းစကား",
    'cr'    => 'ခရီး',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "အနောက်အိန္ဒြိယ\ ကျွန်းစုသား\ သို့မဟုတ်\ ဗန်းစကား",
    'cs'    => 'ချက်',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ဝေလ',
    'da'    => 'ဒိန်းမတ်',
    'dak'   => 'ဒါကိုတာ',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'ဂျာမန်',
    'de_at' => "ဩစတြီးယ\ ဂျာမန်",
    'de_ch' => "ဆွစ်\ အမြင့်\ ဂျာမန်",
    'del'   => 'ဒီလာဝဲ',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "အလယ်ပိုင်း\ ဒတ်ချ်",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'ဒွန်ကာ',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "ရှေးဟောင်း\ အီဂျစ်",
    'eka'   => 'Ekajuk',
    'el'    => 'ဂရိ',
    'elx'   => 'Elamite',
    'en'    => 'အင်္ဂလိပ်',
    'en_au' => "ဩစတြေးလျှ\ အင်္ဂလိပ်",
    'en_ca' => "ကနေဒါ\ အင်္ဂလိပ်",
    'en_gb' => "ဗြိတိသျှ\ အင်္ဂလိပ်",
    'en_us' => "အမေရိကန်\ အင်္ဂလိပ်",
    'enm'   => "အလယ်ပိုင်း\ အင်္ဂလိပ်",
    'eo'    => 'Esperanto',
    'es'    => 'စပိန်',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'အက်စ်တိုးနီးရန်း',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'ပါရှန်',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ဖင်နစ်ရှ်',
    'fil'   => 'ဖိလစ်ပီနို',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ဖီဂျီ',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'ပြင်သစ်',
    'fr_ca' => "ကနေဒါ\ ပြင်သစ်",
    'fr_ch' => "ဆွစ်\ ပြင်သစ်",
    'frm'   => 'အလယ်ပိုင်းပြင်သစ်',
    'fro'   => 'ပြင်သစ်ဟောင်း',
    'frr'   => "မြောက်ပိုင်း\ ဖရီစီရန်",
    'frs'   => "အရှေ့ပိုင်း\ ဖရီစီရန်",
    'fur'   => 'Friulian',
    'fy'    => "အနောက်ပိုင်း\ ဖရီစီရန်",
    'ga'    => 'အိုင်းရစ်',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "ဂျာမန်\ အခြေခံဘာသာစကား",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galician',
    'gmh'   => 'အလယ်ပိုင်းအမြင့်ဂျာမန်',
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "ရှေးဟောင်း\ ဂရိ",
    'gsw'   => "ဆွစ်\ ဂျာမန်",
    'gu'    => 'ဂူဂျာရသီ',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'ဟာဝေယံ',
    'he'    => 'ဟီးဘရူး',
    'hi'    => 'ဟိန္ဒီ',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ခရိုအေရှန်',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ဟန်ဂေရီ',
    'hup'   => 'Hupa',
    'hy'    => 'Armenian',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'အင်ဒိုနီးရှား',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "စီချွမ်\ ရီ",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "အင်ဒို\ ဥရောပ\ ဘာသာစကား",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "အီရန်\ အခြေခံ\ ဘာသာစကား",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Icelandic',
    'it'    => 'အီတလီ',
    'iu'    => 'Inuktitut',
    'ja'    => 'ဂျပန်',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "ဂျူဒီယို\-ပါရှန်",
    'jrb'   => "ဂျူဒီယို\-အာရေဗျ",
    'jv'    => 'ဂျာဗားနီးစ်',
    'ka'    => 'ဂျော်ဂျီယန်',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'ကချင်',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'ကရင်',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'ကွန်ဂို',
    'kha'   => 'ခါစီ',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'ခမာ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ကန်နာဒါ',
    'ko'    => 'ကိုးရီးယား',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'ကဒ်',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'လက်တင်',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'လာအို',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuanian',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Latvian',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "အလယ်ပိုင်း\ အိုင်းရစ်",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "အမျိုးမျိုးသော\ ဘာသာစကား",
    'mk'    => 'Macedonian',
    'mkh'   => "မွန်\-ခမာ\ ဘာသာစကား",
    'ml'    => 'မလေးရာလမ်',
    'mn'    => 'မွန်ဂိုလီးယန်း',
    'mnc'   => 'မန်ချူး',
    'mni'   => 'မနိပူရီ',
    'mno'   => "မနိုဘို\ ဘာသာစကား",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'မာရသီ',
    'ms'    => 'မလေး',
    'mt'    => 'Maltese',
    'mua'   => 'Mundang',
    'mul'   => "အကြိမ်များစွာ\ ဘာသာစကားများ",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'ဗမာ',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "အနိမ့်\ ဂျာမန်",
    'ne'    => 'နီပေါလ်',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ဒတ်ချ်',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'နော်ဝေး',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ပန်ဂျာပီ',
    'paa'   => "ပါပူရန်\ ဘာသာစကား",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "ပါရှန်\ အဟောင်း",
    'phi'   => "ဖိလစ်ပိုင်\ ဘာသာစကား",
    'phn'   => 'Phoenician',
    'pi'    => 'ပါဠိ',
    'pl'    => 'ပိုလန်',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => 'ပေါ်တူဂီ',
    'pt_br' => "ဘရာဇီး\ ပေါ်တူဂီ",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'Rundi',
    'ro'    => 'ရိုမေနီယား',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ရုရှ',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'သင်္သကရိုက်',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "တောင်\ အမေရိကန်\ အိန္ဒြိယ\ ဘာသာစကား",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'စကော့',
    'sd'    => 'စင်ဒီ',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "အိုင်းရစ်\ ဟောင်း",
    'sgn'   => "အချက်ပြ\ ဘာသာစကား",
    'sh'    => "Serbo\-Croatian",
    'shi'   => 'Tachelhit',
    'shn'   => 'ရှမ်း',
    'si'    => 'ဆင်ဟာလ',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "တရုတ်\-တိဘက်\ ဘာသာစကား",
    'sk'    => 'စလိုဗက်',
    'sl'    => 'စလိုဗေးနီးယမ်း',
    'sla'   => "စလိုဗစ်\ ဘာသာစကား",
    'sm'    => 'Samoan',
    'sma'   => "တောင်ပိုင်း\ ဆာမိ",
    'smi'   => "ဆာမိ\ ဘာသာစကား",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'ဆိုမာလီ',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'အယ်လ်ဘေးနီးယန်း',
    'sr'    => 'ဆားဗီးယန်း',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Southern\ Sotho",
    'su'    => 'ဆူဒန်',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ဆွီဒင်',
    'sw'    => 'Swahili',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'တမီးလ်',
    'tai'   => "တိုင်\ ဘာသာစကား",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'ထိုင်း',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "တူပီ\ ဘာသာစကား",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ယူကရိန်း',
    'umb'   => 'Umbundu',
    'und'   => "မသိ\ သို့မဟုတ်\ မရှိ\ သော\ ဘာသာစကား",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ဗီယက်နမ်',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'တရုတ်',
    'znd'   => 'Zande',
    'zu'    => 'ဇူလူ',
    'zun'   => 'Zuni',
    'zxx'   => "ဘာသာစကား\ နှင့်\ ပတ်သက်\ သောအရာမရှိ",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::my::name_to_code = (
    'abkhazian'                                                                                                                                                                => 'ab',
    'achinese'                                                                                                                                                                 => 'ace',
    'acoli'                                                                                                                                                                    => 'ach',
    'adangme'                                                                                                                                                                  => 'ada',
    'adyghe'                                                                                                                                                                   => 'ady',
    'afar'                                                                                                                                                                     => 'aa',
    'afrihili'                                                                                                                                                                 => 'afh',
    'afrikaans'                                                                                                                                                                => 'af',
    'afroasiaticlanguage'                                                                                                                                                      => 'afa',
    'aghem'                                                                                                                                                                    => 'agq',
    'ainu'                                                                                                                                                                     => 'ain',
    'akan'                                                                                                                                                                     => 'ak',
    'akkadian'                                                                                                                                                                 => 'akk',
    'aleut'                                                                                                                                                                    => 'ale',
    'algonquianlanguage'                                                                                                                                                       => 'alg',
    'altaiclanguage'                                                                                                                                                           => 'tut',
    'amharic'                                                                                                                                                                  => 'am',
    'angika'                                                                                                                                                                   => 'anp',
    'apachelanguage'                                                                                                                                                           => 'apa',
    'aragonese'                                                                                                                                                                => 'an',
    'aramaic'                                                                                                                                                                  => 'arc',
    'arapaho'                                                                                                                                                                  => 'arp',
    'araucanian'                                                                                                                                                               => 'arn',
    'arawak'                                                                                                                                                                   => 'arw',
    'armenian'                                                                                                                                                                 => 'hy',
    'aromanian'                                                                                                                                                                => 'rup',
    'assamese'                                                                                                                                                                 => 'as',
    'asturian'                                                                                                                                                                 => 'ast',
    'asu'                                                                                                                                                                      => 'asa',
    'athapascanlanguage'                                                                                                                                                       => 'ath',
    'atsam'                                                                                                                                                                    => 'cch',
    'australianlanguage'                                                                                                                                                       => 'aus',
    'austronesianlanguage'                                                                                                                                                     => 'map',
    'avaric'                                                                                                                                                                   => 'av',
    'avestan'                                                                                                                                                                  => 'ae',
    'awadhi'                                                                                                                                                                   => 'awa',
    'aymara'                                                                                                                                                                   => 'ay',
    'azeri'                                                                                                                                                                    => 'az',
    'bafia'                                                                                                                                                                    => 'ksf',
    'baluchi'                                                                                                                                                                  => 'bal',
    'bambara'                                                                                                                                                                  => 'bm',
    'bamilekelanguage'                                                                                                                                                         => 'bai',
    'banda'                                                                                                                                                                    => 'bad',
    'bantu'                                                                                                                                                                    => 'bnt',
    'bashkir'                                                                                                                                                                  => 'ba',
    'basque'                                                                                                                                                                   => 'eu',
    'batak'                                                                                                                                                                    => 'btk',
    'beja'                                                                                                                                                                     => 'bej',
    'bemba'                                                                                                                                                                    => 'bem',
    'bena'                                                                                                                                                                     => 'bez',
    'berber'                                                                                                                                                                   => 'ber',
    'bhojpuri'                                                                                                                                                                 => 'bho',
    'bihari'                                                                                                                                                                   => 'bh',
    'bikol'                                                                                                                                                                    => 'bik',
    'bini'                                                                                                                                                                     => 'bin',
    'bislama'                                                                                                                                                                  => 'bi',
    'blin'                                                                                                                                                                     => 'byn',
    'blissymbols'                                                                                                                                                              => 'zbl',
    'bodo'                                                                                                                                                                     => 'brx',
    'braj'                                                                                                                                                                     => 'bra',
    'breton'                                                                                                                                                                   => 'br',
    'buginese'                                                                                                                                                                 => 'bug',
    'buriat'                                                                                                                                                                   => 'bua',
    'caddo'                                                                                                                                                                    => 'cad',
    'cantonese'                                                                                                                                                                => 'yue',
    'carib'                                                                                                                                                                    => 'car',
    'catalan'                                                                                                                                                                  => 'ca',
    'cayuga'                                                                                                                                                                   => 'cay',
    'cebuano'                                                                                                                                                                  => 'ceb',
    'celticlanguage'                                                                                                                                                           => 'cel',
    'centralmoroccotamazight'                                                                                                                                                  => 'tzm',
    'chagatai'                                                                                                                                                                 => 'chg',
    'chamiclanguage'                                                                                                                                                           => 'cmc',
    'chamorro'                                                                                                                                                                 => 'ch',
    'cheyenne'                                                                                                                                                                 => 'chy',
    'chibcha'                                                                                                                                                                  => 'chb',
    'chiga'                                                                                                                                                                    => 'cgg',
    'chinookjargon'                                                                                                                                                            => 'chn',
    'chipewyan'                                                                                                                                                                => 'chp',
    'choctaw'                                                                                                                                                                  => 'cho',
    'churchslavic'                                                                                                                                                             => 'cu',
    'chuukese'                                                                                                                                                                 => 'chk',
    'chuvash'                                                                                                                                                                  => 'cv',
    'classicalnewari'                                                                                                                                                          => 'nwc',
    'classicalsyriac'                                                                                                                                                          => 'syc',
    'colognian'                                                                                                                                                                => 'ksh',
    'comorian'                                                                                                                                                                 => 'swb',
    'congoswahili'                                                                                                                                                             => 'swc',
    'coptic'                                                                                                                                                                   => 'cop',
    'cornish'                                                                                                                                                                  => 'kw',
    'corsican'                                                                                                                                                                 => 'co',
    'creek'                                                                                                                                                                    => 'mus',
    'crimeanturkish'                                                                                                                                                           => 'crh',
    'cushiticlanguage'                                                                                                                                                         => 'cus',
    'dargwa'                                                                                                                                                                   => 'dar',
    'dayak'                                                                                                                                                                    => 'day',
    'dinka'                                                                                                                                                                    => 'din',
    'divehi'                                                                                                                                                                   => 'dv',
    'dogri'                                                                                                                                                                    => 'doi',
    'dogrib'                                                                                                                                                                   => 'dgr',
    'dravidianlanguage'                                                                                                                                                        => 'dra',
    'duala'                                                                                                                                                                    => 'dua',
    'dyula'                                                                                                                                                                    => 'dyu',
    'efik'                                                                                                                                                                     => 'efi',
    'ekajuk'                                                                                                                                                                   => 'eka',
    'elamite'                                                                                                                                                                  => 'elx',
    'embu'                                                                                                                                                                     => 'ebu',
    'englishbasedcreoleorpidgin'                                                                                                                                               => 'cpe',
    'erzya'                                                                                                                                                                    => 'myv',
    'esperanto'                                                                                                                                                                => 'eo',
    'ewe'                                                                                                                                                                      => 'ee',
    'ewondo'                                                                                                                                                                   => 'ewo',
    'fang'                                                                                                                                                                     => 'fan',
    'fanti'                                                                                                                                                                    => 'fat',
    'faroese'                                                                                                                                                                  => 'fo',
    'finnougrianlanguage'                                                                                                                                                      => 'fiu',
    'flemish'                                                                                                                                                                  => 'nl_be',
    'fon'                                                                                                                                                                      => 'fon',
    'frenchbasedcreoleorpidgin'                                                                                                                                                => 'cpf',
    'friulian'                                                                                                                                                                 => 'fur',
    'fulah'                                                                                                                                                                    => 'ff',
    'ga'                                                                                                                                                                       => 'gaa',
    'galician'                                                                                                                                                                 => 'gl',
    'ganda'                                                                                                                                                                    => 'lg',
    'gayo'                                                                                                                                                                     => 'gay',
    'gbaya'                                                                                                                                                                    => 'gba',
    'geez'                                                                                                                                                                     => 'gez',
    'gilbertese'                                                                                                                                                               => 'gil',
    'gondi'                                                                                                                                                                    => 'gon',
    'gorontalo'                                                                                                                                                                => 'gor',
    'gothic'                                                                                                                                                                   => 'got',
    'grebo'                                                                                                                                                                    => 'grb',
    'guarani'                                                                                                                                                                  => 'gn',
    'gusii'                                                                                                                                                                    => 'guz',
    "gwich\Ê\¼in"                                                                                                                                                            => 'gwi',
    'haida'                                                                                                                                                                    => 'hai',
    'haitian'                                                                                                                                                                  => 'ht',
    'hausa'                                                                                                                                                                    => 'ha',
    'herero'                                                                                                                                                                   => 'hz',
    'hiligaynon'                                                                                                                                                               => 'hil',
    'himachali'                                                                                                                                                                => 'him',
    'hirimotu'                                                                                                                                                                 => 'ho',
    'hittite'                                                                                                                                                                  => 'hit',
    'hmong'                                                                                                                                                                    => 'hmn',
    'hupa'                                                                                                                                                                     => 'hup',
    'iban'                                                                                                                                                                     => 'iba',
    'iberianportuguese'                                                                                                                                                        => 'pt_pt',
    'iberianspanish'                                                                                                                                                           => 'es_es',
    'icelandic'                                                                                                                                                                => 'is',
    'ido'                                                                                                                                                                      => 'io',
    'igbo'                                                                                                                                                                     => 'ig',
    'ijo'                                                                                                                                                                      => 'ijo',
    'iloko'                                                                                                                                                                    => 'ilo',
    'inarisami'                                                                                                                                                                => 'smn',
    'indiclanguage'                                                                                                                                                            => 'inc',
    'ingush'                                                                                                                                                                   => 'inh',
    'interlingua'                                                                                                                                                              => 'ia',
    'interlingue'                                                                                                                                                              => 'ie',
    'inuktitut'                                                                                                                                                                => 'iu',
    'inupiaq'                                                                                                                                                                  => 'ik',
    'iroquoianlanguage'                                                                                                                                                        => 'iro',
    'jju'                                                                                                                                                                      => 'kaj',
    'jolafonyi'                                                                                                                                                                => 'dyo',
    'kabardian'                                                                                                                                                                => 'kbd',
    'kabuverdianu'                                                                                                                                                             => 'kea',
    'kabyle'                                                                                                                                                                   => 'kab',
    'kalaallisut'                                                                                                                                                              => 'kl',
    'kalenjin'                                                                                                                                                                 => 'kln',
    'kalmyk'                                                                                                                                                                   => 'xal',
    'kamba'                                                                                                                                                                    => 'kam',
    'kanuri'                                                                                                                                                                   => 'kr',
    'karachaybalkar'                                                                                                                                                           => 'krc',
    'karakalpak'                                                                                                                                                               => 'kaa',
    'karelian'                                                                                                                                                                 => 'krl',
    'kashmiri'                                                                                                                                                                 => 'ks',
    'kashubian'                                                                                                                                                                => 'csb',
    'kawi'                                                                                                                                                                     => 'kaw',
    'kazakh'                                                                                                                                                                   => 'kk',
    'khoisanlanguage'                                                                                                                                                          => 'khi',
    'khotanese'                                                                                                                                                                => 'kho',
    'kikuyu'                                                                                                                                                                   => 'ki',
    'kimbundu'                                                                                                                                                                 => 'kmb',
    'kinyarwanda'                                                                                                                                                              => 'rw',
    'kirghiz'                                                                                                                                                                  => 'ky',
    'klingon'                                                                                                                                                                  => 'tlh',
    'komi'                                                                                                                                                                     => 'kv',
    'konkani'                                                                                                                                                                  => 'kok',
    'koro'                                                                                                                                                                     => 'kfo',
    'kosraean'                                                                                                                                                                 => 'kos',
    'koyraborosenni'                                                                                                                                                           => 'ses',
    'koyrachiini'                                                                                                                                                              => 'khq',
    'kpelle'                                                                                                                                                                   => 'kpe',
    'kru'                                                                                                                                                                      => 'kro',
    'kuanyama'                                                                                                                                                                 => 'kj',
    'kumyk'                                                                                                                                                                    => 'kum',
    'kurukh'                                                                                                                                                                   => 'kru',
    'kutenai'                                                                                                                                                                  => 'kut',
    'kwasio'                                                                                                                                                                   => 'nmg',
    'ladino'                                                                                                                                                                   => 'lad',
    'lahnda'                                                                                                                                                                   => 'lah',
    'lamba'                                                                                                                                                                    => 'lam',
    'langi'                                                                                                                                                                    => 'lag',
    'latvian'                                                                                                                                                                  => 'lv',
    'lezghian'                                                                                                                                                                 => 'lez',
    'limburgish'                                                                                                                                                               => 'li',
    'lingala'                                                                                                                                                                  => 'ln',
    'lithuanian'                                                                                                                                                               => 'lt',
    'lojban'                                                                                                                                                                   => 'jbo',
    'lowersorbian'                                                                                                                                                             => 'dsb',
    'lozi'                                                                                                                                                                     => 'loz',
    'lubakatanga'                                                                                                                                                              => 'lu',
    'lubalulua'                                                                                                                                                                => 'lua',
    'luiseno'                                                                                                                                                                  => 'lui',
    'lulesami'                                                                                                                                                                 => 'smj',
    'lunda'                                                                                                                                                                    => 'lun',
    'luo'                                                                                                                                                                      => 'luo',
    'lushai'                                                                                                                                                                   => 'lus',
    'luxembourgish'                                                                                                                                                            => 'lb',
    'luyia'                                                                                                                                                                    => 'luy',
    'macedonian'                                                                                                                                                               => 'mk',
    'machame'                                                                                                                                                                  => 'jmc',
    'madurese'                                                                                                                                                                 => 'mad',
    'magahi'                                                                                                                                                                   => 'mag',
    'maithili'                                                                                                                                                                 => 'mai',
    'makasar'                                                                                                                                                                  => 'mak',
    'makhuwameetto'                                                                                                                                                            => 'mgh',
    'makonde'                                                                                                                                                                  => 'kde',
    'malagasy'                                                                                                                                                                 => 'mg',
    'maltese'                                                                                                                                                                  => 'mt',
    'mandar'                                                                                                                                                                   => 'mdr',
    'mandingo'                                                                                                                                                                 => 'man',
    'manx'                                                                                                                                                                     => 'gv',
    'maori'                                                                                                                                                                    => 'mi',
    'mari'                                                                                                                                                                     => 'chm',
    'marshallese'                                                                                                                                                              => 'mh',
    'marwari'                                                                                                                                                                  => 'mwr',
    'masai'                                                                                                                                                                    => 'mas',
    'mayanlanguage'                                                                                                                                                            => 'myn',
    'mende'                                                                                                                                                                    => 'men',
    'meru'                                                                                                                                                                     => 'mer',
    'micmac'                                                                                                                                                                   => 'mic',
    'minangkabau'                                                                                                                                                              => 'min',
    'mirandese'                                                                                                                                                                => 'mwl',
    'mohawk'                                                                                                                                                                   => 'moh',
    'moksha'                                                                                                                                                                   => 'mdf',
    'moldavian'                                                                                                                                                                => 'mo',
    'mongo'                                                                                                                                                                    => 'lol',
    'morisyen'                                                                                                                                                                 => 'mfe',
    'mossi'                                                                                                                                                                    => 'mos',
    'mundalanguage'                                                                                                                                                            => 'mun',
    'mundang'                                                                                                                                                                  => 'mua',
    'nahuatl'                                                                                                                                                                  => 'nah',
    'nama'                                                                                                                                                                     => 'naq',
    'nauru'                                                                                                                                                                    => 'na',
    'navajo'                                                                                                                                                                   => 'nv',
    'ndonga'                                                                                                                                                                   => 'ng',
    'neapolitan'                                                                                                                                                               => 'nap',
    'newari'                                                                                                                                                                   => 'new',
    'nias'                                                                                                                                                                     => 'nia',
    'nigerkordofanianlanguage'                                                                                                                                                 => 'nic',
    'nilosaharanlanguage'                                                                                                                                                      => 'ssa',
    'niuean'                                                                                                                                                                   => 'niu',
    'nogai'                                                                                                                                                                    => 'nog',
    'northamericanindianlanguage'                                                                                                                                              => 'nai',
    'northernsami'                                                                                                                                                             => 'se',
    'northernsotho'                                                                                                                                                            => 'nso',
    'northndebele'                                                                                                                                                             => 'nd',
    "norwegianbokm\Ã\¥l"                                                                                                                                                     => 'nb',
    'norwegiannynorsk'                                                                                                                                                         => 'nn',
    'nubianlanguage'                                                                                                                                                           => 'nub',
    'nuer'                                                                                                                                                                     => 'nus',
    'nyamwezi'                                                                                                                                                                 => 'nym',
    'nyanja'                                                                                                                                                                   => 'ny',
    'nyankole'                                                                                                                                                                 => 'nyn',
    'nyasatonga'                                                                                                                                                               => 'tog',
    'nyoro'                                                                                                                                                                    => 'nyo',
    'nzima'                                                                                                                                                                    => 'nzi',
    "n\â\\ko"                                                                                                                                                             => 'nqo',
    'occitan'                                                                                                                                                                  => 'oc',
    'ojibwa'                                                                                                                                                                   => 'oj',
    'oldhighgerman'                                                                                                                                                            => 'goh',
    'oldnorse'                                                                                                                                                                 => 'non',
    "oldproven\Ã\§al"                                                                                                                                                        => 'pro',
    'oriya'                                                                                                                                                                    => 'or',
    'oromo'                                                                                                                                                                    => 'om',
    'osage'                                                                                                                                                                    => 'osa',
    'ossetic'                                                                                                                                                                  => 'os',
    'otomianlanguage'                                                                                                                                                          => 'oto',
    'ottomanturkish'                                                                                                                                                           => 'ota',
    'pahlavi'                                                                                                                                                                  => 'pal',
    'palauan'                                                                                                                                                                  => 'pau',
    'pampanga'                                                                                                                                                                 => 'pam',
    'pangasinan'                                                                                                                                                               => 'pag',
    'papiamento'                                                                                                                                                               => 'pap',
    'phoenician'                                                                                                                                                               => 'phn',
    'pohnpeian'                                                                                                                                                                => 'pon',
    'prakritlanguage'                                                                                                                                                          => 'pra',
    'pushto'                                                                                                                                                                   => 'ps',
    'quechua'                                                                                                                                                                  => 'qu',
    'rajasthani'                                                                                                                                                               => 'raj',
    'rapanui'                                                                                                                                                                  => 'rap',
    'rarotongan'                                                                                                                                                               => 'rar',
    'romancelanguage'                                                                                                                                                          => 'roa',
    'romansh'                                                                                                                                                                  => 'rm',
    'romany'                                                                                                                                                                   => 'rom',
    'rombo'                                                                                                                                                                    => 'rof',
    'rundi'                                                                                                                                                                    => 'rn',
    'rwa'                                                                                                                                                                      => 'rwk',
    'saho'                                                                                                                                                                     => 'ssy',
    'sakha'                                                                                                                                                                    => 'sah',
    'salishanlanguage'                                                                                                                                                         => 'sal',
    'samaritanaramaic'                                                                                                                                                         => 'sam',
    'samburu'                                                                                                                                                                  => 'saq',
    'samoan'                                                                                                                                                                   => 'sm',
    'sandawe'                                                                                                                                                                  => 'sad',
    'sango'                                                                                                                                                                    => 'sg',
    'sangu'                                                                                                                                                                    => 'sbp',
    'santali'                                                                                                                                                                  => 'sat',
    'sardinian'                                                                                                                                                                => 'sc',
    'sasak'                                                                                                                                                                    => 'sas',
    'scottishgaelic'                                                                                                                                                           => 'gd',
    'selkup'                                                                                                                                                                   => 'sel',
    'semiticlanguage'                                                                                                                                                          => 'sem',
    'sena'                                                                                                                                                                     => 'seh',
    'seneca'                                                                                                                                                                   => 'see',
    'serbocroatian'                                                                                                                                                            => 'sh',
    'serer'                                                                                                                                                                    => 'srr',
    'shambala'                                                                                                                                                                 => 'ksb',
    'shona'                                                                                                                                                                    => 'sn',
    'sicilian'                                                                                                                                                                 => 'scn',
    'sidamo'                                                                                                                                                                   => 'sid',
    'siksika'                                                                                                                                                                  => 'bla',
    'siouanlanguage'                                                                                                                                                           => 'sio',
    'skoltsami'                                                                                                                                                                => 'sms',
    'slave'                                                                                                                                                                    => 'den',
    'soga'                                                                                                                                                                     => 'xog',
    'sogdien'                                                                                                                                                                  => 'sog',
    'songhai'                                                                                                                                                                  => 'son',
    'soninke'                                                                                                                                                                  => 'snk',
    'sorbianlanguage'                                                                                                                                                          => 'wen',
    'southernaltai'                                                                                                                                                            => 'alt',
    'southernsotho'                                                                                                                                                            => 'st',
    'southndebele'                                                                                                                                                             => 'nr',
    'sranantongo'                                                                                                                                                              => 'srn',
    'sukuma'                                                                                                                                                                   => 'suk',
    'sumerian'                                                                                                                                                                 => 'sux',
    'susu'                                                                                                                                                                     => 'sus',
    'swahili'                                                                                                                                                                  => 'sw',
    'swati'                                                                                                                                                                    => 'ss',
    'syriac'                                                                                                                                                                   => 'syr',
    'tachelhit'                                                                                                                                                                => 'shi',
    'tagalog'                                                                                                                                                                  => 'tl',
    'tahitian'                                                                                                                                                                 => 'ty',
    'taita'                                                                                                                                                                    => 'dav',
    'tajik'                                                                                                                                                                    => 'tg',
    'tamashek'                                                                                                                                                                 => 'tmh',
    'taroko'                                                                                                                                                                   => 'trv',
    'tasawaq'                                                                                                                                                                  => 'twq',
    'tatar'                                                                                                                                                                    => 'tt',
    'telugu'                                                                                                                                                                   => 'te',
    'tereno'                                                                                                                                                                   => 'ter',
    'teso'                                                                                                                                                                     => 'teo',
    'tetum'                                                                                                                                                                    => 'tet',
    'tigre'                                                                                                                                                                    => 'tig',
    'tigrinya'                                                                                                                                                                 => 'ti',
    'timne'                                                                                                                                                                    => 'tem',
    'tiv'                                                                                                                                                                      => 'tiv',
    'tlingit'                                                                                                                                                                  => 'tli',
    'tokelau'                                                                                                                                                                  => 'tkl',
    'tokpisin'                                                                                                                                                                 => 'tpi',
    'tonga'                                                                                                                                                                    => 'to',
    'tsimshian'                                                                                                                                                                => 'tsi',
    'tsonga'                                                                                                                                                                   => 'ts',
    'tswana'                                                                                                                                                                   => 'tn',
    'tumbuka'                                                                                                                                                                  => 'tum',
    'turkish'                                                                                                                                                                  => 'tr',
    'turkmen'                                                                                                                                                                  => 'tk',
    'tuvalu'                                                                                                                                                                   => 'tvl',
    'tuvinian'                                                                                                                                                                 => 'tyv',
    'twi'                                                                                                                                                                      => 'tw',
    'tyap'                                                                                                                                                                     => 'kcg',
    'udmurt'                                                                                                                                                                   => 'udm',
    'ugaritic'                                                                                                                                                                 => 'uga',
    'umbundu'                                                                                                                                                                  => 'umb',
    'uppersorbian'                                                                                                                                                             => 'hsb',
    'urdu'                                                                                                                                                                     => 'ur',
    'uyghur'                                                                                                                                                                   => 'ug',
    'uzbek'                                                                                                                                                                    => 'uz',
    'vai'                                                                                                                                                                      => 'vai',
    'venda'                                                                                                                                                                    => 've',
    "volap\Ã\¼k"                                                                                                                                                             => 'vo',
    'votic'                                                                                                                                                                    => 'vot',
    'vunjo'                                                                                                                                                                    => 'vun',
    'wakashanlanguage'                                                                                                                                                         => 'wak',
    'walamo'                                                                                                                                                                   => 'wal',
    'walloon'                                                                                                                                                                  => 'wa',
    'walser'                                                                                                                                                                   => 'wae',
    'waray'                                                                                                                                                                    => 'war',
    'washo'                                                                                                                                                                    => 'was',
    'wolof'                                                                                                                                                                    => 'wo',
    'xhosa'                                                                                                                                                                    => 'xh',
    'yangben'                                                                                                                                                                  => 'yav',
    'yao'                                                                                                                                                                      => 'yao',
    'yapese'                                                                                                                                                                   => 'yap',
    'yiddish'                                                                                                                                                                  => 'yi',
    'yoruba'                                                                                                                                                                   => 'yo',
    'yupiklanguage'                                                                                                                                                            => 'ypk',
    'zande'                                                                                                                                                                    => 'znd',
    'zapotec'                                                                                                                                                                  => 'zap',
    'zarma'                                                                                                                                                                    => 'dje',
    'zaza'                                                                                                                                                                     => 'zza',
    'zenaga'                                                                                                                                                                   => 'zen',
    'zhuang'                                                                                                                                                                   => 'za',
    'zuni'                                                                                                                                                                     => 'zun',
    'ကချင်'                                                                                                                                                          => 'kac',
    'ကဒ်'                                                                                                                                                                => 'ku',
    'ကနေဒါပြင်သစ်'                                                                                                                                     => 'fr_ca',
    'ကနေဒါအင်္ဂလိပ်'                                                                                                                               => 'en_ca',
    'ကန်နာဒါ'                                                                                                                                                    => 'kn',
    'ကရင်'                                                                                                                                                             => 'kar',
    'ကိုးရီးယား'                                                                                                                                           => 'ko',
    'ကောက်ကေးရှပ်ဘာသာစကား'                                                                                                             => 'cau',
    'ကွန်ဂို'                                                                                                                                                    => 'kg',
    'ခမာ'                                                                                                                                                                => 'km',
    'ခရိုအေရှန်'                                                                                                                                           => 'hr',
    'ခရီး'                                                                                                                                                             => 'cr',
    'ခါစီ'                                                                                                                                                             => 'kha',
    'ချက်'                                                                                                                                                             => 'cs',
    'ချာရိုကီ'                                                                                                                                                 => 'chr',
    'ချေချင်း'                                                                                                                                                 => 'ce',
    'ဂရိ'                                                                                                                                                                => 'el',
    'ဂူဂျာရသီ'                                                                                                                                                 => 'gu',
    'ဂျပန်'                                                                                                                                                          => 'ja',
    'ဂျာဗားနီးစ်'                                                                                                                                        => 'jv',
    'ဂျာမန်'                                                                                                                                                       => 'de',
    'ဂျာမန်အခြေခံဘာသာစကား'                                                                                                             => 'gem',
    'ဂျူဒီယိုပါရှန်'                                                                                                                               => 'jpr',
    'ဂျူဒီယိုအာရေဗျ'                                                                                                                               => 'jrb',
    'ဂျော်ဂျီယန်'                                                                                                                                        => 'ka',
    'စကော့'                                                                                                                                                          => 'sco',
    'စင်ဒီ'                                                                                                                                                          => 'sd',
    'စပိန်'                                                                                                                                                          => 'es',
    'စလိုဗက်'                                                                                                                                                    => 'sk',
    'စလိုဗစ်ဘာသာစကား'                                                                                                                            => 'sla',
    'စလိုဗေးနီးယမ်း'                                                                                                                               => 'sl',
    'စီချွမ်ရီ'                                                                                                                                              => 'ii',
    'ဆင်ဟာလ'                                                                                                                                                       => 'si',
    'ဆာမိဘာသာစကား'                                                                                                                                     => 'smi',
    'ဆားဗီးယန်း'                                                                                                                                           => 'sr',
    'ဆိုမာလီ'                                                                                                                                                    => 'so',
    'ဆူဒန်'                                                                                                                                                          => 'su',
    'ဆွစ်ဂျာမန်'                                                                                                                                           => 'gsw',
    'ဆွစ်ပြင်သစ်'                                                                                                                                        => 'fr_ch',
    'ဆွစ်အမြင့်ဂျာမန်'                                                                                                                         => 'de_ch',
    'ဆွီဒင်'                                                                                                                                                       => 'sv',
    'ဇူလူ'                                                                                                                                                             => 'zu',
    'တမီးလ်'                                                                                                                                                       => 'ta',
    'တရုတ်'                                                                                                                                                          => 'zh',
    'တရုတ်တိဘက်ဘာသာစကား'                                                                                                                   => 'sit',
    'တိဘက်'                                                                                                                                                          => 'bo',
    'တိုင်ဘာသာစကား'                                                                                                                                  => 'tai',
    'တူပီဘာသာစကား'                                                                                                                                     => 'tup',
    'တောင်ပိုင်းဆာမိ'                                                                                                                            => 'sma',
    'တောင်အမေရိကန်အိန္ဒြိယဘာသာစကား'                                                                                  => 'sai',
    'ထိုင်း'                                                                                                                                                       => 'th',
    'ဒတ်ချ်'                                                                                                                                                       => 'nl',
    'ဒါကိုတာ'                                                                                                                                                    => 'dak',
    'ဒိန်းမတ်'                                                                                                                                                 => 'da',
    'ဒီလာဝဲ'                                                                                                                                                       => 'del',
    'ဒွန်ကာ'                                                                                                                                                       => 'dz',
    'နီပေါလ်'                                                                                                                                                    => 'ne',
    'နော်ဝေး'                                                                                                                                                    => 'no',
    'ပန်ဂျာပီ'                                                                                                                                                 => 'pa',
    'ပါပူရန်ဘာသာစကား'                                                                                                                            => 'paa',
    'ပါရှန်'                                                                                                                                                       => 'fa',
    'ပါရှန်အဟောင်း'                                                                                                                                  => 'peo',
    'ပါဠိ'                                                                                                                                                             => 'pi',
    'ပိုလန်'                                                                                                                                                       => 'pl',
    'ပေါ်တူဂီ'                                                                                                                                                 => 'pt',
    'ပေါ်တူဂီအခြေခံအနောက်အိန္ဒြိယကျွန်းစုသားသို့မဟုတ်ဗန်းစကား' => 'cpp',
    'ပြင်သစ်'                                                                                                                                                    => 'fr',
    'ပြင်သစ်ဟောင်း'                                                                                                                                  => 'fro',
    'ဖင်နစ်ရှ်'                                                                                                                                              => 'fi',
    'ဖိလစ်ပိုင်ဘာသာစကား'                                                                                                                   => 'phi',
    'ဖိလစ်ပီနို'                                                                                                                                           => 'fil',
    'ဖီဂျီ'                                                                                                                                                          => 'fj',
    'ဗမာ'                                                                                                                                                                => 'my',
    'ဗီယက်နမ်'                                                                                                                                                 => 'vi',
    'ဗြိတိသျှအင်္ဂလိပ်'                                                                                                                      => 'en_gb',
    'ဘင်္ဂါလီ'                                                                                                                                                 => 'bn',
    'ဘရာဇီးပေါ်တူဂီ'                                                                                                                               => 'pt_br',
    'ဘာဆာ'                                                                                                                                                             => 'bas',
    'ဘာလီ'                                                                                                                                                             => 'ban',
    'ဘာသာစကားနှင့်ပတ်သက်သောအရာမရှိ'                                                                                  => 'zxx',
    'ဘီလာရု'                                                                                                                                                       => 'be',
    'ဘူဂေးရီးယား'                                                                                                                                        => 'bg',
    'ဘော့စ်နီးယား'                                                                                                                                     => 'bs',
    'ဘော်လတစ်ဘာသာစကား'                                                                                                                         => 'bat',
    'မနိပူရီ'                                                                                                                                                    => 'mni',
    'မနိုဘိုဘာသာစကား'                                                                                                                            => 'mno',
    'မန်ချူး'                                                                                                                                                    => 'mnc',
    'မလေး'                                                                                                                                                             => 'ms',
    'မလေးရာလမ်'                                                                                                                                              => 'ml',
    'မသိသို့မဟုတ်မရှိသောဘာသာစကား'                                                                                        => 'und',
    'မာရသီ'                                                                                                                                                          => 'mr',
    'မြောက်ပိုင်းဖရီစီရန်'                                                                                                             => 'frr',
    'မွန်ခမာဘာသာစကား'                                                                                                                            => 'mkh',
    'မွန်ဂိုလီးယန်း'                                                                                                                               => 'mn',
    'ယူကရိန်း'                                                                                                                                                 => 'uk',
    'ရိုမေနီယား'                                                                                                                                           => 'ro',
    'ရုရှ'                                                                                                                                                             => 'ru',
    'ရှမ်း'                                                                                                                                                          => 'shn',
    'ရှေးဟောင်းဂရိ'                                                                                                                                  => 'grc',
    'ရှေးဟောင်းအီဂျစ်'                                                                                                                         => 'egy',
    'လက်တင်'                                                                                                                                                       => 'la',
    'လာအို'                                                                                                                                                          => 'lo',
    'ဝေလ'                                                                                                                                                                => 'cy',
    'သင်္သကရိုက်'                                                                                                                                        => 'sa',
    'ဟန်ဂေရီ'                                                                                                                                                    => 'hu',
    'ဟာဝေယံ'                                                                                                                                                       => 'haw',
    'ဟိန္ဒီ'                                                                                                                                                       => 'hi',
    'ဟီးဘရူး'                                                                                                                                                    => 'he',
    'အက်စ်တိုးနီးရန်း'                                                                                                                         => 'et',
    'အကြိမ်များစွာဘာသာစကားများ'                                                                                              => 'mul',
    'အချက်ပြဘာသာစကား'                                                                                                                            => 'sgn',
    'အင်ဒိုနီးရှား'                                                                                                                                  => 'id',
    'အင်ဒိုဥရောပဘာသာစကား'                                                                                                                => 'ine',
    'အင်္ဂလိပ်'                                                                                                                                              => 'en',
    'အင်္ဂလိပ်စာဟောင်း'                                                                                                                      => 'ang',
    'အနိမ့်ဂျာမန်'                                                                                                                                     => 'nds',
    'အနောက်ပိုင်းဖရီစီရန်'                                                                                                             => 'fy',
    'အနောက်အိန္ဒြိယကျွန်းစုသားသို့မဟုတ်ဗန်းစကား'                                           => 'crp',
    'အမေရိကန်အင်္ဂလိပ်'                                                                                                                      => 'en_us',
    'အမျိုးမျိုးသောဘာသာစကား'                                                                                                       => 'mis',
    'အယောင်ဆောင်ဘာသာစကား'                                                                                                                => 'art',
    'အယ်လ်ဘေးနီးယန်း'                                                                                                                            => 'sq',
    'အရှေ့ပိုင်းဖရီစီရန်'                                                                                                                => 'frs',
    'အလယ်ပိုင်းဒတ်ချ်'                                                                                                                         => 'dum',
    'အလယ်ပိုင်းပြင်သစ်'                                                                                                                      => 'frm',
    'အလယ်ပိုင်းအင်္ဂလိပ်'                                                                                                                => 'enm',
    'အလယ်ပိုင်းအမေရိကန်အိန္ဒြိယဘာသာစကား'                                                                   => 'cai',
    'အလယ်ပိုင်းအမြင့်ဂျာမန်'                                                                                                       => 'gmh',
    'အလယ်ပိုင်းအိုင်းရစ်'                                                                                                                => 'mga',
    'အာရေဗီ'                                                                                                                                                       => 'ar',
    'အိုင်းရစ်'                                                                                                                                              => 'ga',
    'အိုင်းရစ်ဟောင်း'                                                                                                                            => 'sga',
    'အီတလီ'                                                                                                                                                          => 'it',
    'အီရန်အခြေခံဘာသာစကား'                                                                                                                => 'ira',
    'ဩစတြီးယဂျာမန်'                                                                                                                                  => 'de_at',
    'ဩစတြေးလျှအင်္ဂလိပ်'                                                                                                                   => 'en_au',
);

1;
