/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.text.resources.LocaleData;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private transient char[] compiledPattern;
    private static final int TAG_QUOTE_ASCII_CHAR = 100;
    private static final int TAG_QUOTE_CHARS = 101;
    private transient char zeroDigit;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private static Hashtable cachedNumberFormatData = new Hashtable(3);
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17};
    private static final DateFormat.Field[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID = new DateFormat.Field[]{DateFormat.Field.ERA, DateFormat.Field.YEAR, DateFormat.Field.MONTH, DateFormat.Field.DAY_OF_MONTH, DateFormat.Field.HOUR_OF_DAY1, DateFormat.Field.HOUR_OF_DAY0, DateFormat.Field.MINUTE, DateFormat.Field.SECOND, DateFormat.Field.MILLISECOND, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.DAY_OF_YEAR, DateFormat.Field.DAY_OF_WEEK_IN_MONTH, DateFormat.Field.WEEK_OF_YEAR, DateFormat.Field.WEEK_OF_MONTH, DateFormat.Field.AM_PM, DateFormat.Field.HOUR1, DateFormat.Field.HOUR0, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE};

    public SimpleDateFormat() {
        this(3, 3, Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.pattern = string;
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
        this.initialize(Locale.getDefault());
    }

    SimpleDateFormat(int n, int n2, Locale locale) {
        Object[] objectArray;
        String[] stringArray = (String[])cachedLocaleData.get(locale);
        if (stringArray == null) {
            objectArray = LocaleData.getLocaleElements(locale);
            stringArray = objectArray.getStringArray("DateTimePatterns");
            cachedLocaleData.put(locale, stringArray);
        }
        this.formatData = new DateFormatSymbols(locale);
        if (n >= 0 && n2 >= 0) {
            objectArray = new Object[]{stringArray[n], stringArray[n2 + 4]};
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n >= 0) {
            this.pattern = stringArray[n];
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2 + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.compiledPattern = this.compile(this.pattern);
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.numberFormat = (NumberFormat)cachedNumberFormatData.get(locale);
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getIntegerInstance(locale);
            this.numberFormat.setGroupingUsed(false);
            cachedNumberFormatData.put(locale, this.numberFormat);
        }
        this.numberFormat = (NumberFormat)this.numberFormat.clone();
        this.initializeDefaultCentury();
    }

    private char[] compile(String string) {
        int n;
        int n2 = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        StringBuffer stringBuffer2 = null;
        int n3 = 0;
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            char c;
            int n5;
            char c2 = string.charAt(n);
            if (c2 == '\'') {
                if (n + 1 < n2 && (c2 = string.charAt(n + 1)) == '\'') {
                    ++n;
                    if (n3 != 0) {
                        SimpleDateFormat.encode(n4, n3, stringBuffer);
                        n4 = -1;
                        n3 = 0;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue;
                    }
                    stringBuffer.append((char)(0x6400 | c2));
                    continue;
                }
                if (!bl) {
                    if (n3 != 0) {
                        SimpleDateFormat.encode(n4, n3, stringBuffer);
                        n4 = -1;
                        n3 = 0;
                    }
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer(n2);
                    } else {
                        stringBuffer2.setLength(0);
                    }
                    bl = true;
                    continue;
                }
                n5 = stringBuffer2.length();
                if (n5 == 1) {
                    c = stringBuffer2.charAt(0);
                    if (c < '\u0080') {
                        stringBuffer.append((char)(0x6400 | c));
                    } else {
                        stringBuffer.append('\u6501');
                        stringBuffer.append(c);
                    }
                } else {
                    SimpleDateFormat.encode(101, n5, stringBuffer);
                    stringBuffer.append(stringBuffer2);
                }
                bl = false;
                continue;
            }
            if (bl) {
                stringBuffer2.append(c2);
                continue;
            }
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                if (n3 != 0) {
                    SimpleDateFormat.encode(n4, n3, stringBuffer);
                    n4 = -1;
                    n3 = 0;
                }
                if (c2 < '\u0080') {
                    stringBuffer.append((char)(0x6400 | c2));
                    continue;
                }
                for (n5 = n + 1; !(n5 >= n2 || (c = string.charAt(n5)) == '\'' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z'); ++n5) {
                }
                stringBuffer.append((char)(0x6500 | n5 - n));
                while (n < n5) {
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
                --n;
                continue;
            }
            n5 = "GyMdkHmsSEDFwWahKzZ".indexOf(c2);
            if (n5 == -1) {
                throw new IllegalArgumentException("Illegal pattern character '" + c2 + "'");
            }
            if (n4 == -1 || n4 == n5) {
                n4 = n5;
                ++n3;
                continue;
            }
            SimpleDateFormat.encode(n4, n3, stringBuffer);
            n4 = n5;
            n3 = 1;
        }
        if (bl) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        if (n3 != 0) {
            SimpleDateFormat.encode(n4, n3, stringBuffer);
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    private static final void encode(int n, int n2, StringBuffer stringBuffer) {
        if (n2 < 255) {
            stringBuffer.append((char)(n << 8 | n2));
        } else {
            stringBuffer.append((char)(n << 8 | 0xFF));
            stringBuffer.append((char)(n2 >>> 16));
            stringBuffer.append((char)(n2 & 0xFFFF));
        }
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        return this.format(date, stringBuffer, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(Date date, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        this.calendar.setTime(date);
        int n = 0;
        block4: while (n < this.compiledPattern.length) {
            int n2;
            int n3 = this.compiledPattern[n] >>> 8;
            if ((n2 = this.compiledPattern[n++] & 0xFF) == 255) {
                n2 = this.compiledPattern[n++] << 16;
                n2 |= this.compiledPattern[n++];
            }
            switch (n3) {
                case 100: {
                    stringBuffer.append((char)n2);
                    continue block4;
                }
                case 101: {
                    stringBuffer.append(this.compiledPattern, n, n2);
                    n += n2;
                    continue block4;
                }
            }
            this.subFormat(n3, n2, fieldDelegate, stringBuffer);
        }
        return stringBuffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        if (object instanceof Date) {
            this.format((Date)object, stringBuffer, characterIteratorFieldDelegate);
        } else if (object instanceof Number) {
            this.format(new Date(((Number)object).longValue()), stringBuffer, characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private void subFormat(int n, int n2, Format.FieldDelegate fieldDelegate, StringBuffer stringBuffer) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        String string = null;
        int n5 = stringBuffer.length();
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n];
        int n7 = this.calendar.get(n6);
        switch (n) {
            case 0: {
                string = this.formatData.eras[n7];
                break;
            }
            case 1: {
                if (n2 >= 4) {
                    this.zeroPaddingNumber(n7, n2, n4, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n7, 2, 2, stringBuffer);
                break;
            }
            case 2: {
                if (n2 >= 4) {
                    string = this.formatData.months[n7];
                    break;
                }
                if (n2 == 3) {
                    string = this.formatData.shortMonths[n7];
                    break;
                }
                this.zeroPaddingNumber(n7 + 1, n2, n4, stringBuffer);
                break;
            }
            case 4: {
                if (n7 == 0) {
                    this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n2, n4, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n7, n2, n4, stringBuffer);
                break;
            }
            case 9: {
                if (n2 >= 4) {
                    string = this.formatData.weekdays[n7];
                    break;
                }
                string = this.formatData.shortWeekdays[n7];
                break;
            }
            case 14: {
                string = this.formatData.ampms[n7];
                break;
            }
            case 15: {
                if (n7 == 0) {
                    this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n2, n4, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n7, n2, n4, stringBuffer);
                break;
            }
            case 17: {
                int n8;
                n3 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n3 == -1) {
                    n7 = this.calendar.get(15) + this.calendar.get(16);
                    if (n7 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n7 = -n7;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    n8 = n7 / 3600000;
                    if (n8 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n8);
                    stringBuffer.append(':');
                    n8 = n7 % 3600000 / 60000;
                    if (n8 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n8);
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n2 >= 4) {
                        string = this.formatData.zoneStrings[n3][3];
                        break;
                    }
                    string = this.formatData.zoneStrings[n3][4];
                    break;
                }
                if (n2 >= 4) {
                    string = this.formatData.zoneStrings[n3][1];
                    break;
                }
                string = this.formatData.zoneStrings[n3][2];
                break;
            }
            case 18: {
                n7 = this.calendar.get(15) + this.calendar.get(16);
                if (n7 < 0) {
                    stringBuffer.append('-');
                    n7 = -n7;
                } else {
                    stringBuffer.append('+');
                }
                int n8 = n7 / 3600000;
                if (n8 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n8);
                n8 = n7 % 3600000 / 60000;
                if (n8 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n8);
                break;
            }
            default: {
                this.zeroPaddingNumber(n7, n2, n4, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        n3 = PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n];
        DateFormat.Field field = PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID[n];
        fieldDelegate.formatted(n3, field, field, n5, stringBuffer.length(), stringBuffer);
    }

    private final void zeroPaddingNumber(int n, int n2, int n3, StringBuffer stringBuffer) {
        try {
            if (this.zeroDigit == '\u0000') {
                this.zeroDigit = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols().getZeroDigit();
            }
            if (n >= 0) {
                if (n < 100 && n2 >= 1 && n2 <= 2) {
                    if (n < 10) {
                        if (n2 == 2) {
                            stringBuffer.append(this.zeroDigit);
                        }
                        stringBuffer.append((char)(this.zeroDigit + n));
                    } else {
                        stringBuffer.append((char)(this.zeroDigit + n / 10));
                        stringBuffer.append((char)(this.zeroDigit + n % 10));
                    }
                    return;
                }
                if (n >= 1000 && n < 10000) {
                    if (n2 == 4) {
                        stringBuffer.append((char)(this.zeroDigit + n / 1000));
                        stringBuffer.append((char)(this.zeroDigit + (n %= 1000) / 100));
                        stringBuffer.append((char)(this.zeroDigit + (n %= 100) / 10));
                        stringBuffer.append((char)(this.zeroDigit + n % 10));
                        return;
                    }
                    if (n2 == 2 && n3 == 2) {
                        this.zeroPaddingNumber(n % 100, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numberFormat.setMinimumIntegerDigits(n2);
        this.numberFormat.setMaximumIntegerDigits(n3);
        this.numberFormat.format(n, stringBuffer, DontCareFieldPosition.INSTANCE);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n;
        int n2 = n = parsePosition.index;
        int n3 = string.length();
        boolean[] blArray = new boolean[]{false};
        this.calendar.clear();
        int n4 = 0;
        block6: while (n4 < this.compiledPattern.length) {
            int n5;
            int n6;
            int n7 = this.compiledPattern[n4] >>> 8;
            if ((n6 = this.compiledPattern[n4++] & 0xFF) == 255) {
                n6 = this.compiledPattern[n4++] << 16;
                n6 |= this.compiledPattern[n4++];
            }
            switch (n7) {
                case 100: {
                    if (n >= n3 || string.charAt(n) != (char)n6) {
                        parsePosition.index = n2;
                        parsePosition.errorIndex = n;
                        return null;
                    }
                    ++n;
                    continue block6;
                }
                case 101: {
                    while (n6-- > 0) {
                        if (n >= n3 || string.charAt(n) != this.compiledPattern[n4++]) {
                            parsePosition.index = n2;
                            parsePosition.errorIndex = n;
                            return null;
                        }
                        ++n;
                    }
                    continue block6;
                }
            }
            boolean bl = false;
            if (n4 < this.compiledPattern.length && (n5 = this.compiledPattern[n4] >>> 8) != 100 && n5 != 101) {
                bl = true;
            }
            if ((n = this.subParse(string, n, n7, n6, bl, blArray, parsePosition)) >= 0) continue;
            parsePosition.index = n2;
            return null;
        }
        if (this.calendar.isSet(9) && !this.calendar.isSet(10) && !this.calendar.isSet(11)) {
            this.calendar.set(10, 0);
        }
        parsePosition.index = n;
        try {
            if (blArray[0]) {
                Calendar calendar = (Calendar)this.calendar.clone();
                date = this.calendar.getTime();
                if (date.before(this.defaultCenturyStart)) {
                    calendar.set(1, this.defaultCenturyStartYear + 100);
                    date = calendar.getTime();
                }
            } else {
                date = this.calendar.getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.errorIndex = n;
            parsePosition.index = n2;
            return null;
        }
        return date;
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        int n5 = 0;
        int n6 = -1;
        while (n3 < n4) {
            int n7 = stringArray[n3].length();
            if (n7 > n5 && string.regionMatches(true, n, stringArray[n3], 0, n7)) {
                n6 = n3;
                n5 = n7;
            }
            ++n3;
        }
        if (n6 >= 0) {
            this.calendar.set(n2, n6);
            return n + n5;
        }
        return -n;
    }

    private int matchZoneString(String string, int n, int n2) {
        int n3;
        for (n3 = 1; n3 <= 4 && !string.regionMatches(true, n, this.formatData.zoneStrings[n2][n3], 0, this.formatData.zoneStrings[n2][n3].length()); ++n3) {
        }
        return n3 > 4 ? -1 : n3;
    }

    private int subParseZoneString(String string, int n) {
        int n2 = this.formatData.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null && (n2 = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n3 = this.matchZoneString(string, n, n2)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n2][0]);
            n4 = n2;
        }
        if (timeZone == null) {
            for (n4 = 0; n4 < this.formatData.zoneStrings.length; ++n4) {
                n3 = this.matchZoneString(string, n, n4);
                if (n3 <= 0) continue;
                timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n4][0]);
                break;
            }
        }
        if (timeZone != null) {
            this.calendar.set(15, timeZone.getRawOffset());
            this.calendar.set(16, n3 >= 3 ? timeZone.getDSTSavings() : 0);
            return n + this.formatData.zoneStrings[n4][n3].length();
        }
        return 0;
    }

    private int subParse(String string, int n, int n2, int n3, boolean bl, boolean[] blArray, ParsePosition parsePosition) {
        int n4;
        Number number = null;
        int n5 = 0;
        ParsePosition parsePosition2 = new ParsePosition(0);
        parsePosition2.index = n;
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
        while (true) {
            if (parsePosition2.index >= string.length()) {
                parsePosition.errorIndex = n;
                return -1;
            }
            n4 = string.charAt(parsePosition2.index);
            if (n4 != 32 && n4 != 9) break;
            ++parsePosition2.index;
        }
        if (n2 == 4 || n2 == 15 || n2 == 2 && n3 <= 2 || n2 == 1) {
            if (bl) {
                if (n + n3 > string.length()) {
                    parsePosition.errorIndex = n;
                    return -1;
                }
                number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition2);
            } else {
                number = this.numberFormat.parse(string, parsePosition2);
            }
            if (number == null) {
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            n5 = number.intValue();
        }
        switch (n2) {
            case 0: {
                n4 = this.matchString(string, n, 0, this.formatData.eras);
                if (n4 > 0) {
                    return n4;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 1: {
                if (n3 <= 2 && parsePosition2.index - n == 2 && Character.isDigit(string.charAt(n)) && Character.isDigit(string.charAt(n + 1))) {
                    int n7 = this.defaultCenturyStartYear % 100;
                    blArray[0] = n5 == n7;
                    n5 += this.defaultCenturyStartYear / 100 * 100 + (n5 < n7 ? 100 : 0);
                }
                this.calendar.set(1, n5);
                return parsePosition2.index;
            }
            case 2: {
                if (n3 <= 2) {
                    this.calendar.set(2, n5 - 1);
                    return parsePosition2.index;
                }
                int n8 = 0;
                n8 = this.matchString(string, n, 2, this.formatData.months);
                if (n8 > 0) {
                    return n8;
                }
                n4 = this.matchString(string, n, 2, this.formatData.shortMonths);
                if (n4 > 0) {
                    return n4;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 4: {
                if (n5 == this.calendar.getMaximum(11) + 1) {
                    n5 = 0;
                }
                this.calendar.set(11, n5);
                return parsePosition2.index;
            }
            case 9: {
                int n9 = 0;
                n9 = this.matchString(string, n, 7, this.formatData.weekdays);
                if (n9 > 0) {
                    return n9;
                }
                n4 = this.matchString(string, n, 7, this.formatData.shortWeekdays);
                if (n4 > 0) {
                    return n4;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 14: {
                n4 = this.matchString(string, n, 9, this.formatData.ampms);
                if (n4 > 0) {
                    return n4;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 15: {
                if (n5 == this.calendar.getLeastMaximum(10) + 1) {
                    n5 = 0;
                }
                this.calendar.set(10, n5);
                return parsePosition2.index;
            }
            case 17: 
            case 18: {
                int n10;
                int n11 = 0;
                if (string.length() - n >= GMT.length() && string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    int n12;
                    char c;
                    this.calendar.set(16, 0);
                    parsePosition2.index = n + GMT.length();
                    try {
                        if (string.charAt(parsePosition2.index) == '+') {
                            n11 = 1;
                        } else if (string.charAt(parsePosition2.index) == '-') {
                            n11 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n11 == 0) {
                        this.calendar.set(15, 0);
                        return parsePosition2.index;
                    }
                    try {
                        c = string.charAt(++parsePosition2.index);
                        if (c < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n12 = c - 48;
                        if (string.charAt(++parsePosition2.index) != ':') {
                            c = string.charAt(parsePosition2.index);
                            if (c < '0' || c > '9') {
                                parsePosition.errorIndex = parsePosition2.index;
                                return -1;
                            }
                            n12 *= 10;
                            n12 += c - 48;
                            ++parsePosition2.index;
                        }
                        if (n12 > 23) {
                            parsePosition.errorIndex = parsePosition2.index - 1;
                            return -1;
                        }
                        if (string.charAt(parsePosition2.index) != ':') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                    n10 = n12 * 60;
                    try {
                        c = string.charAt(++parsePosition2.index);
                        if (c < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n12 = c - 48;
                        if ((c = string.charAt(++parsePosition2.index)) < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n12 *= 10;
                        if ((n12 += c - 48) > 59) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                    n10 += n12;
                } else {
                    int n13 = this.subParseZoneString(string, parsePosition2.index);
                    if (n13 != 0) {
                        return n13;
                    }
                    try {
                        char c;
                        if (string.charAt(parsePosition2.index) == '+') {
                            n11 = 1;
                        } else if (string.charAt(parsePosition2.index) == '-') {
                            n11 = -1;
                        }
                        if (n11 == 0) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        int n14 = 0;
                        if ((c = string.charAt(++parsePosition2.index)) < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n14 = c - 48;
                        if ((c = string.charAt(++parsePosition2.index)) < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n14 *= 10;
                        if ((n14 += c - 48) > 23) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        int n15 = 0;
                        if ((c = string.charAt(++parsePosition2.index)) < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n15 = c - 48;
                        if ((c = string.charAt(++parsePosition2.index)) < '0' || c > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n15 *= 10;
                        if ((n15 += c - 48) > 59) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n10 = n14 * 60 + n15;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                }
                if (n11 != 0) {
                    this.calendar.set(15, n10 *= 60000 * n11);
                    this.calendar.set(16, 0);
                    return ++parsePosition2.index;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
        }
        if (bl) {
            if (n + n3 > string.length()) {
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition2);
        } else {
            number = this.numberFormat.parse(string, parsePosition2);
        }
        if (number != null) {
            this.calendar.set(n6, number.intValue());
            return parsePosition2.index;
        }
        parsePosition.errorIndex = parsePosition2.index;
        return -1;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                }
            } else if (c == '\'') {
                bl = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int n = string2.indexOf(c);
                if (n == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
                c = string3.charAt(n);
            }
            stringBuffer.append(c);
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzZ", this.formatData.localPatternChars);
    }

    public void applyPattern(String string) {
        this.compiledPattern = this.compile(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKzZ");
        this.compiledPattern = this.compile(string2);
        this.pattern = string2;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        TimeZone timeZone;
        objectInputStream.defaultReadObject();
        try {
            this.compiledPattern = this.compile(this.pattern);
        }
        catch (Exception exception) {
            throw new InvalidObjectException("invalid pattern");
        }
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        TimeZone timeZone2 = this.getTimeZone();
        if (timeZone2 instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone(string = timeZone2.getID())) != null && timeZone.hasSameRules(timeZone2) && timeZone.getID().equals(string)) {
            this.setTimeZone(timeZone);
        }
    }
}

