/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.looks.demo.Settings;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuBarView {
    private static final String HTML_TEXT = "<html><b>Bold</b>, <i>Italics</i>, <tt>Typewriter</tt></html>";

    JMenuBar buildMenuBar(Settings settings, ActionListener helpActionListener, ActionListener aboutActionListener) {
        JMenuBar bar = new JMenuBar();
        bar.putClientProperty("jgoodies.headerStyle", settings.getMenuBarHeaderStyle());
        bar.putClientProperty("Plastic.borderStyle", settings.getMenuBarPlasticBorderStyle());
        bar.putClientProperty("jgoodies.windows.borderStyle", settings.getMenuBarWindowsBorderStyle());
        bar.putClientProperty("Plastic.is3D", settings.getMenuBar3DHint());
        bar.add(this.buildFileMenu());
        bar.add(this.buildRadioMenu());
        bar.add(this.buildCheckMenu());
        bar.add(this.buildHtmlMenu());
        bar.add(this.buildAlignmentTestMenu());
        bar.add(this.buildHelpMenu(helpActionListener, aboutActionListener));
        return bar;
    }

    private JMenu buildFileMenu() {
        JMenu menu = this.createMenu("File", 'F');
        JMenu submenu = this.createMenu("New", 'N');
        submenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        submenu.add(this.createMenuItem("Project\u2026", 'P'));
        submenu.add(this.createMenuItem("Folder\u2026", 'F'));
        submenu.add(this.createMenuItem("Document\u2026", 'D', KeyStroke.getKeyStroke("ctrl F8")));
        submenu.addSeparator();
        submenu.add(this.createMenuItem("No icon hint set", 'N', KeyStroke.getKeyStroke("ctrl F9")));
        menu.add(submenu);
        menu.addSeparator();
        JMenuItem item = this.createMenuItem("Close", 'C', KeyStroke.getKeyStroke("ctrl F4"));
        menu.add(item);
        item = this.createMenuItem("Close All", 'o', KeyStroke.getKeyStroke("ctrl shift F4"));
        menu.add(item);
        menu.addSeparator();
        item = this.createMenuItem("Save description.txt", this.readImageIcon("save_edit.gif"), 'd', KeyStroke.getKeyStroke("ctrl S"));
        item.setEnabled(false);
        menu.add(item);
        item = this.createMenuItem("Save description.txt As\u2026", this.readImageIcon("saveas_edit.gif"), 'e');
        menu.add(item);
        item = this.createMenuItem("Save All", 'A', KeyStroke.getKeyStroke("ctrl shift S"));
        item.setEnabled(false);
        menu.add(item);
        menu.addSeparator();
        item = this.createMenuItem("Print", this.readImageIcon("print.gif"), 'P', KeyStroke.getKeyStroke("ctrl P"));
        menu.add(item);
        menu.addSeparator();
        menu.add(this.createMenuItem("1 WinXPMenuItemUI.java", '1'));
        menu.add(this.createMenuItem("2 WinXPUtils.java", '2'));
        menu.add(this.createMenuItem("3 WinXPBorders.java", '3'));
        menu.add(this.createMenuItem("4 WinXPLookAndFeel.java", '4'));
        if (!this.isQuitInOSMenu()) {
            menu.addSeparator();
            menu.add(this.createMenuItem("Exit", 'E'));
        }
        return menu;
    }

    private JMenu buildRadioMenu() {
        JMenu menu = this.createMenu("Radio", 'R');
        ButtonGroup group1 = new ButtonGroup();
        JRadioButtonMenuItem item = this.createRadioItem(true, false);
        group1.add(item);
        menu.add(item);
        item = this.createRadioItem(true, true);
        group1.add(item);
        menu.add(item);
        menu.addSeparator();
        item = this.createRadioItem(false, false);
        menu.add(item);
        item = this.createRadioItem(false, true);
        menu.add(item);
        menu.addSeparator();
        ButtonGroup group2 = new ButtonGroup();
        item = this.createRadioItem(true, false);
        item.setIcon(this.readImageIcon("pie_mode.png"));
        group2.add(item);
        menu.add(item);
        item = this.createRadioItem(true, true);
        item.setIcon(this.readImageIcon("bar_mode.png"));
        group2.add(item);
        menu.add(item);
        menu.addSeparator();
        item = this.createRadioItem(false, false);
        item.setIcon(this.readImageIcon("alphab_sort.png"));
        menu.add(item);
        item = this.createRadioItem(false, true);
        item.setIcon(this.readImageIcon("size_sort.png"));
        menu.add(item);
        return menu;
    }

    private JMenu buildCheckMenu() {
        JMenu menu = this.createMenu("Check", 'C');
        menu.add(this.createCheckItem(true, false));
        menu.add(this.createCheckItem(true, true));
        menu.addSeparator();
        menu.add(this.createCheckItem(false, false));
        menu.add(this.createCheckItem(false, true));
        menu.addSeparator();
        JCheckBoxMenuItem item = this.createCheckItem(true, false);
        item.setIcon(this.readImageIcon("check.gif"));
        item.setSelectedIcon(this.readImageIcon("check_selected.gif"));
        menu.add(item);
        item = this.createCheckItem(true, true);
        item.setIcon(this.readImageIcon("check.gif"));
        item.setSelectedIcon(this.readImageIcon("check_selected.gif"));
        menu.add(item);
        menu.addSeparator();
        item = this.createCheckItem(false, false);
        item.setIcon(this.readImageIcon("check.gif"));
        item.setSelectedIcon(this.readImageIcon("check_selected.gif"));
        menu.add(item);
        item = this.createCheckItem(false, true);
        item.setIcon(this.readImageIcon("check.gif"));
        item.setSelectedIcon(this.readImageIcon("check_selected.gif"));
        item.setDisabledSelectedIcon(this.readImageIcon("check_disabled_selected.gif"));
        menu.add(item);
        return menu;
    }

    private JMenu buildHtmlMenu() {
        JMenu menu = this.createMenu("Styled", 'S');
        menu.add(this.createSubmenu(HTML_TEXT));
        menu.add(this.createMenuItem(HTML_TEXT));
        menu.addSeparator();
        menu.add(new JRadioButtonMenuItem(HTML_TEXT, false));
        menu.add(new JRadioButtonMenuItem(HTML_TEXT, true));
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(HTML_TEXT, true));
        menu.add(new JCheckBoxMenuItem(HTML_TEXT, false));
        return menu;
    }

    private JMenu buildAlignmentTestMenu() {
        JMenu menu = this.createMenu("Alignment", 'A');
        menu.add(this.createMenuItem("Menu item"));
        menu.add(this.createMenuItem("Menu item with icon", this.readImageIcon("refresh.gif")));
        menu.addSeparator();
        JMenu submenu = this.createSubmenu("Submenu");
        menu.add(submenu);
        submenu = this.createSubmenu("Submenu with icon");
        submenu.setIcon(this.readImageIcon("refresh.gif"));
        menu.add(submenu);
        return menu;
    }

    private JMenu buildHelpMenu(ActionListener helpActionListener, ActionListener aboutActionListener) {
        JMenu menu = this.createMenu("Help", 'H');
        JMenuItem item = this.createMenuItem("Help Contents", this.readImageIcon("help.gif"), 'H');
        if (helpActionListener != null) {
            item.addActionListener(helpActionListener);
        }
        menu.add(item);
        if (!this.isAboutInOSMenu()) {
            menu.addSeparator();
            item = this.createMenuItem("About", 'a');
            item.addActionListener(aboutActionListener);
            menu.add(item);
        }
        return menu;
    }

    protected JMenu createMenu(String text, char mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    protected JMenuItem createMenuItem(String text) {
        return new JMenuItem(text);
    }

    protected JMenuItem createMenuItem(String text, char mnemonic) {
        return new JMenuItem(text, mnemonic);
    }

    protected JMenuItem createMenuItem(String text, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }

    protected JMenuItem createMenuItem(String text, Icon icon) {
        return new JMenuItem(text, icon);
    }

    protected JMenuItem createMenuItem(String text, Icon icon, char mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, icon);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    protected JMenuItem createMenuItem(String text, Icon icon, char mnemonic, KeyStroke key) {
        JMenuItem menuItem = this.createMenuItem(text, icon, mnemonic);
        menuItem.setAccelerator(key);
        return menuItem;
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(String text, boolean selected) {
        return new JRadioButtonMenuItem(text, selected);
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String text, boolean selected) {
        return new JCheckBoxMenuItem(text, selected);
    }

    protected boolean isQuitInOSMenu() {
        return false;
    }

    protected boolean isAboutInOSMenu() {
        return false;
    }

    private JRadioButtonMenuItem createRadioItem(boolean enabled, boolean selected) {
        JRadioButtonMenuItem item = this.createRadioButtonMenuItem(this.getToggleLabel(enabled, selected), selected);
        item.setEnabled(enabled);
        item.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
                source.setText(MenuBarView.this.getToggleLabel(source.isEnabled(), source.isSelected()));
            }
        });
        return item;
    }

    private JCheckBoxMenuItem createCheckItem(boolean enabled, boolean selected) {
        JCheckBoxMenuItem item = this.createCheckBoxMenuItem(this.getToggleLabel(enabled, selected), selected);
        item.setEnabled(enabled);
        item.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                source.setText(MenuBarView.this.getToggleLabel(source.isEnabled(), source.isSelected()));
            }
        });
        return item;
    }

    protected String getToggleLabel(boolean enabled, boolean selected) {
        String prefix = enabled ? "Enabled" : "Disabled";
        String suffix = selected ? "Selected" : "Deselected";
        return prefix + " and " + suffix;
    }

    private ImageIcon readImageIcon(String filename) {
        URL url = this.getClass().getResource("resources/images/" + filename);
        return new ImageIcon(url);
    }

    private JMenu createSubmenu(String text) {
        JMenu submenu = new JMenu(text);
        submenu.add(new JMenuItem("Item 1"));
        submenu.add(new JMenuItem("Item 2"));
        submenu.add(new JMenuItem("Item 3"));
        return submenu;
    }
}

