/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 *
 */
@XmlType(name = "tcp-connection")
public final class TcpConnectionMetaData implements Serializable {

    private static final long serialVersionUID = 2101881740511543307L;

    private NamedBeanMetaData handlerBean;
    private NamedBeanMetaData tcpClientBean;
    private TcpClientMetaData tcpClientMetaData;
    private NamedBeanMetaData executorBean;
    private NamedBeanMetaData scheduledExecutorBean;
    private int reconnectInterval = -1;
    private String name;

    public NamedBeanMetaData getHandlerBean() {
        return handlerBean;
    }

    @XmlElement(name = "handler-bean")
    public void setHandlerBean(final NamedBeanMetaData handlerBean) {
        this.handlerBean = handlerBean;
    }

    public NamedBeanMetaData getTcpClientBean() {
        return tcpClientBean;
    }

    @XmlElement(name = "tcp-client-bean")
    public void setTcpClientBean(final NamedBeanMetaData tcpClientBean) {
        this.tcpClientBean = tcpClientBean;
    }

    public TcpClientMetaData getTcpClientMetaData() {
        return tcpClientMetaData;
    }

    @XmlElement(name = "tcp-client")
    public void setTcpClientMetaData(final TcpClientMetaData tcpClientMetaData) {
        this.tcpClientMetaData = tcpClientMetaData;
    }

    public NamedBeanMetaData getExecutorBean() {
        return executorBean;
    }

    @XmlElement(name = "executor-bean")
    public void setExecutorBean(final NamedBeanMetaData executorBean) {
        this.executorBean = executorBean;
    }

    public String getName() {
        return name;
    }

    @XmlAttribute(name = "name")
    public void setName(final String name) {
        this.name = name;
    }

    public NamedBeanMetaData getScheduledExecutorBean() {
        return scheduledExecutorBean;
    }

    @XmlElement(name = "scheduled-executor-bean")
    public void setScheduledExecutorBean(final NamedBeanMetaData scheduledExecutorBean) {
        this.scheduledExecutorBean = scheduledExecutorBean;
    }

    public int getReconnectInterval() {
        return reconnectInterval;
    }

    @XmlAttribute(name = "reconnect-interval")
    public void setReconnectInterval(final int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }
}