/*******************************************************************************************************************************************
 ccontainer.c
*******************************************************************************************************************************************/

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CContainer);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CContainer::CContainer (CComponent *inOwner, const CWidgetListener *inListener)
	   :CWidget    (inOwner, inListener)
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CContainer::~CContainer ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// border width affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CContainer::SetPadding (const UInt16 inPadding)
{
	if (GetGtkWidget() != NULL) ::gtk_container_set_border_width (GTK_CONTAINER(GetGtkWidget()), inPadding);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// border width reader
//-----------------------------------------------------------------------------------------------------------------------------------------
UInt16 CContainer::GetPadding () const
{
	return GetGtkWidget() != NULL ? ::gtk_container_get_border_width (GTK_CONTAINER(GetGtkWidget())) : 0;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// child add generic handler
//-----------------------------------------------------------------------------------------------------------------------------------------
void CContainer::PerformContainerAdd (CWidget *inChild)
{
	if (GetGtkWidget() != NULL && inChild != NULL && inChild -> GetGtkWidget() != NULL) 
		::gtk_container_add (GTK_CONTAINER(GetGtkWidget()), inChild -> GetGtkWidget());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// child remove generic handler
//-----------------------------------------------------------------------------------------------------------------------------------------
void CContainer::PerformContainerRemove (CWidget *inChild)
{
	if (GetGtkWidget() != NULL && inChild != NULL && inChild -> GetGtkWidget() != NULL) 
		::gtk_container_remove (GTK_CONTAINER(GetGtkWidget()), inChild -> GetGtkWidget());
}


//-----------------------------------------------------------------------------------------------------------------------------------------
// gtkol handled children widgets
//-----------------------------------------------------------------------------------------------------------------------------------------
CWidgets CContainer::GetGtkChildren (const CMetaClass *inRequested, const CMetaClass *inRejected) const
{
	// out widgets
	CWidgets outWidgets; if (inRequested == NULL || !CMetaClass::MetaClassIs (__metaclass(CWidget), inRequested)) return outWidgets;

	// get the container children widgets components
	CComponents inComponents (GetChildren (inRequested, inRejected));

	// go through the children list
	for (size_t i=inComponents.GetLength(), j=0; i>0; i--, j++)
		if (static_cast <CWidget *> (*inComponents[j]) -> m_PerformContainerProcess)
			outWidgets += static_cast <CWidget *> (*inComponents[j]);

	// ok
	return outWidgets;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtkol in owner index of the specified gtkol widget
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CContainer::GetGtkInOwnerIndex (const CContainer *inOwner, const CWidget *inChild, const CMetaClass *inRequested, 
				       const CMetaClass *inRejected)
{
	// pointers check in
	if (inOwner == NULL || inChild == NULL) return -1;

	// get the handled gtkol children widgets
	CWidgets inChildren (inOwner -> GetGtkChildren (inRequested, inRejected));

	// go through the children list
	for (size_t i=inChildren.GetLength(), j=0; i>0; i--, j++) if ((*inChildren[j]) == const_cast <CWidget *> (inChild)) return j;

	// not found
	return -1;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// max children handling
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CContainer::GetGtkChildrenNumberLeft () const
{
	// a default container handles only one child max, so see if there is already one handled child in the gtk container...
	return 1 - GetGtkChildren().GetLength();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// container xml serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CContainer::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic serialization call
	CWidget::Serialize (ioXMLElementNode, inMode);

	// serialization request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// instanciate a new xml element
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CONTAINER_ELEMENT);

			// add the attribute the ccontainer instance is interested in
			newXMLElement -> AddAttribute (XML_CONTAINER_ATTR_PADDING, CString((UInt32)GetPadding()));

			// modify the input/output pointer so that serialization of overwritten definitions continues under this xml node
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;
	
		// xml load
		case XML_READ :
		{
			// get the node the ccontainer is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CONTAINER_ELEMENT);

			// check we got an expected ccontainer node
			if (inXMLNode == NULL)
				throw new CException (CString("CContainer::Serialize, specified xml node is not a \"") + 
							      XML_CONTAINER_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the ccontainer node
			ioXMLElementNode = inXMLNode;

			// read in the expected attribute
			SetPadding (::xml_node_get_attribute (inXMLNode, XML_CONTAINER_ATTR_PADDING).GetValue().ToULong());
		}
		break;
	}
}


