/*******************************************************************************************************************************************
 cvpaned.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer
		      |--CLayout
			 |--CPaned
			    |--CVPaned

 Vertical paned definition.
*******************************************************************************************************************************************/

#ifndef __CVPANED_H__
#define __CVPANED_H__

#include "cpaned.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CVPaned class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CVPaned : public CPaned
{
	// instanciation section
	public :

		CVPaned			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CVPaned	();

	// gtk widget instanciation request handler
	protected :

		// allocate the gtk vertical paned
		virtual GtkWidget *	PerformWidgetInstanciate	();


	// CLayout redefinition
	public :

		// get the potential drop index from specified relative point and given drop candidate
		virtual SInt16		GetDropIndexAtPoint		(const TPoint &inRelativePoint, const CControl *inCandidate) const;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('vpnd', CVPaned, CPaned);

#endif
