/*******************************************************************************************************************************************
 clayout.h
 
 CClass	
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CLayout

 Layout abstraction. The layout purpose is to manage the sub widgets positions.
*******************************************************************************************************************************************/

#ifndef __CLAYOUT_H__
#define __CLAYOUT_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// clayout xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <clayout size-group="none|horizontal|vertical|both" [ignore-hidden="true|false"]>
//    ...
// </clayout>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_LAYOUT_ELEMENT 		("clayout");
static CString XML_LAYOUT_ATTR_SIZE_GROUP	("size-group");
static CString XML_LAYOUT_ATTR_IGNORE_HIDDEN	("ignore-hidden");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CLayout class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CLayout : public CContainer
{
	// instanciation section
	public :

		CLayout				(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CLayout		() =0;

	// CComponent redefinition
	public :

		// expected owner type : __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// CControl redefinition
	public :

		// get the layout's widget at specified relative point
		virtual CControl *		GetControlAtPoint		(const TPoint &inRelativePoint) const;

	// CContainer redefinition
	public :
		
		// get the container children number handling left, defaults to -1 at this level i.e. no limitation
		virtual SInt16			GetGtkChildrenNumberLeft	() const;

	// CLayout abstraction
	public :

		// the layout may be analysed in dnd processes as an indirect drop site target, this function must return the insertion
		// index of a given potential new child inCandidate from layout's relative coordinates specifications; defaults to an 
		// append specification index after the referenced child at the given position if it is a widget, -1 is returned if the
		// referenced child is just a control or there is no child handled yet into the layout
		virtual SInt16			GetDropIndexAtPoint		(const TPoint &inRelativePoint, 
										 const CControl *inCandidate) const;
	
		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('lyot', CLayout, CContainer);

#endif
