/*******************************************************************************************************************************************
 cfiledialog.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CForm
		         |--CDialog
			    |--CFileDialog

 The CFileDialog should be used to retrieve file or directory names from the user. It will create a new dialog window containing a directory
 list, and a file list corresponding to the current working directory. The filesystem can be navigated using the directory list or the 
 drop-down history menu. Alternatively, the TAB key can be used to navigate using filename completion. Simple file operations : create
 directory, delete file, and rename file, are available from buttons at the top of the dialog.
*******************************************************************************************************************************************/

#ifndef __CFILEDIALOG_H__
#define __CFILEDIALOG_H__

#include "cdialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization constants; there is no pattern nor current selection serialization done on the file dialog, see cdialog.h comments
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cfiledialog selection="single|multiple" root="working_directory">
//   ...
// </cfiledialog>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FILEDIALOG_ELEMENT		("cfiledialog");
static CString XML_FILEDIALOG_ATTR_SELECTION	("selection");
static CString XML_FILEDIALOG_ATTR_ROOT		("root");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CFileDialog class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileDialog : public CDialog
{
	// instanciation section
	public :

		CFileDialog			(CForm *inOwner=NULL, const CString &inCaption=CString(), const bool inModal=false, 
						 const CDialogListener *inListener=NULL);
		virtual ~CFileDialog		();

	// gtk widget protected handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// file dialog specific functions
	public :

		// multiple selection access
		virtual void			SetSelectionMultiple		(const bool);
		virtual bool			GetSelectionMultiple		() const;

		// default path for the file requestor
		virtual void			SetFileSelectionOn		(const CString &);
		virtual CString			GetFileSelectionOn		() const;

		// pattern access, attempt to match pattern to a valid filenames or subdirectories in the current directory
		virtual void			SetFilePattern			(const CString &);
		
		// get file dialog file names selection
		virtual CStrings		GetSelection			() const;

	// CSerialized redefinition
	public :

		// gtkol file dialog xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declarations
DECLARE_DYNAMIC_METACLASS ('fdlg', CFileDialog, CDialog);

#endif
