/*******************************************************************************************************************************************
 cfilechooserdialog.h
 
 CClass							CClass
 |--CSerialized						|--CSerialized
    |--CMetaModule					   |--CMetaModule
       |--CObject					      |--CObjectListener
          |--CComponent					         |
	     |--CControl				         |
	        |--CWidget				         |--CWidgetListener
		   |--CContainer			   	    |
		      |--CForm					    |--CFormListener
		         |--CDialog				       |
			    |--CFileDialog			       |
			       |--CFileChooserDialog		       |--CFileChooserDialogListener

 The CFileChooserDialog dialog box is suitable for use with "File/Open" or "File/Save as" commands.
*******************************************************************************************************************************************/

#ifndef __CFILECHOOSERDIALOG_H__
#define __CFILECHOOSERDIALOG_H__

#include "cfiledialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization constants, see cdialog.h for some explanations
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cfilechooserdialog type="open|save|select-folder|create-folder" previewable="true|false">
//    ...
// </cfilechooserdialog>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FILECHOOSERDIALOG_ELEMENT		("cfilechooserdialog");
static CString XML_FILECHOOSERDIALOG_ATTR_TYPE		("type");
static CString XML_FILECHOOSERDIALOG_ATTR_PREVIEWABLE	("previewable");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CFileChooserDialogListener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileChooserDialogListener : public CDialogListener
{
	// instanciation section
	public :

		CFileChooserDialogListener		();
		virtual ~CFileChooserDialogListener	()=0;

	// specific file chooser listening
	public :

		// called when the current folder of the inSender file chooser dialog has changed
		virtual void				OnFolderChanged			(CObject *inSender)		{ }

		// called when the current selection of the inSender file chooser dialog has been modified
		virtual void				OnSelectionChanged		(CObject *inSender)		{ }

		// called when the preview function of the inSender file chooser dialog is enabled and about to be changed to reflect
		// the given file name preview
		virtual void				OnUpdatePreview			(CObject *inSender, const CString &inFileName,
											 Bool &ioDoPreview)		{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_fod', CFileChooserDialogListener, CDialogListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CFileChooserDialog
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileChooserDialog : public CFileDialog
{
	// instanciation section
	public :

		CFileChooserDialog			(CForm *inOwner=NULL, const CString &inCaption=CString(), 
							 const GtkFileChooserAction=GTK_FILE_CHOOSER_ACTION_OPEN, const bool inModal=false,
							 const CFileChooserDialogListener *inListener=NULL);
		virtual ~CFileChooserDialog		();

	// protected gtk widget handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *			PerformWidgetInstanciate	();
		virtual void				PerformWidgetInitialize		();

	// CObject redefinition
	protected :

		// listener affectation, should be derived from CFileChooserDialogListener
		virtual const CMetaClass *		ListenerMustBe			() const;

	// CFileDialog redefinition
	public :

		// multiple selection access
		virtual void				SetSelectionMultiple		(const bool);
		virtual bool				GetSelectionMultiple		() const;

		// default path for the file requestor
		virtual void				SetFileSelectionOn		(const CString &);
		virtual CString				GetFileSelectionOn		() const;

		// get file chooser dialog file names selection
		virtual CStrings			GetSelection			() const;

	// CFileChooserDialog specifics
	public :

		// set the file chooser dialog type
		virtual void				SetFileChooserDialog		(const GtkFileChooserAction);
		GtkFileChooserAction			GetFileChooserDialog		() const;
	
		// previewable state of the file chooser dialog
		virtual void				SetPreviewable			(const bool);
		virtual bool				GetPreviewable			() const;

	// CSerialized redefinition
	public :

		// file chooser dialog xml serialization
		virtual void				Serialize			(CXMLElementNode *&, const int) THROWABLE;

	// protected attributes
	protected :

		// the file chooser dialog type
		GtkFileChooserAction			m_FileChooserDialog;

	// protected listener connexions
	protected :

		static void				OnFolderChanged			(GtkFileChooser *, gpointer);
		static void				OnSelectionChanged		(GtkFileChooser *, gpointer);
		static void				OnUpdatePreview			(GtkFileChooser *, gpointer);
	
		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declarations
DECLARE_DYNAMIC_METACLASS ('folg', CFileChooserDialog, CFileDialog);

#endif
