/*****************************************************************************
 *                                                                           *
 * Widget:    gtkimrot                                                       *
 * Uses:      GTK+1.2, GdkImlib                                              *
 * Purpose:   Rotate images.                                                 *
 * Author:    Andreas Tille <tillea@rki.de>                                  *
 * Date:      Nov 01, 1999                                                   *
 * Copyright: Andreas Tille, 1998, 1999                                      *
 * License:   LGPL                                                           *
 *                                                                           *
 *****************************************************************************/

#ifndef __GTK_IMROT_H__
#define __GTK_IMROT_H__

#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_IMROT            (gtk_imrot_get_type ())
#define GTK_IMROT(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_IMROT, GtkImRot))
#define GTK_IMROT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IMROT, GtkImRotClass))
#define GTK_IS_IMROT(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_IMROT))
#define GTK_IS_IMROT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IMROT))

typedef struct _GtkImRot          GtkImRot;
typedef struct _GtkImRotClass     GtkImRotClass;

struct _GtkImRot
{
  GtkWindow        window;

  GdkImlibImage   *im;         /* ImLib structur with pixmap of known dimension */
  gdouble          alpha;      /* rotating angle                                */
  guchar          *data;       /* RGB data                                      */
  gint             width;      /* width of rotated image                        */
  gint             height;     /* height of rotated image                       */
  guchar          *o_data;     /* original RGB data                             */
  gint             o_width;    /* width of original image                       */
  gint             o_height;   /* height of original image                      */
  GtkWidget       *main_vbox;
  GtkWidget       *draw;       /* drawable to show pixmap                       */
  GdkPixmap       *pm;         /* Backing pixmap for drawing area               */
  GtkWidget       *ok_button;
  GtkWidget       *cancel_button;
  GtkWidget       *apply_button;
  GtkWidget       *parms;      /* hbox with parameters                          */
  GtkAdjustment   *angle;
};


struct _GtkImRotClass
{
  GtkWindowClass parent_class;
};


GtkType    gtk_imrot_get_type   (void);
GtkWidget* gtk_imrot_new        (const gchar *title, GdkImlibImage *im, gdouble alpha);
/* The following functions could be called without initalizing GTK */
gdouble    gtk_imrot_get_alpha  (GtkImRot *imrot);
gint       gtk_imrot_set        (GtkImRot *imrot, gdouble alpha);

void    gtk_imrot_mirror_horizontally(guchar *data, gint width, gint height, gchar storepix);
void    gtk_imrot_mirror_vertically(guchar *data, gint width, gint height, gchar storepix);
guchar *gtk_imrot_crop_image_buffer(guchar *image, gint width, gint x, gint y, 
                                    gint w, gint h, gchar storepix);
gint    gtk_imgrot_quarter(GtkImRot *image, guint rotations);
gint    gtk_imrot_sharpen_image(GtkImRot *image);
gint    gtk_imrot_rotate_image(GtkImRot *image, gdouble degrees);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_IMROT_H__ */

