// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_BATCH_H
#define _LIBGDAMM_BATCH_H


#include <glibmm.h>

// -*- C++ -*- //

/* batch.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/holder.h>
#include <libgdamm/statement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaBatch GdaBatch;
typedef struct _GdaBatchClass GdaBatchClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Batch_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Multiple SQL statements grouped together.
 *
 * The Gda::Batch object represents one or more SQL statements (as Gda::Statement objects) in a single object.
 * A Gda::Batch can either be built "manually" by assembling together several Gda::Statement objects, or from an 
 * SQL string using a Gda::SqlParser object.
 *
 * @ingroup DataHandlers
 */

class Batch : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Batch CppObjectType;
  typedef Batch_Class CppClassType;
  typedef GdaBatch BaseObjectType;
  typedef GdaBatchClass BaseClassType;

private:  friend class Batch_Class;
  static CppClassType batch_class_;

private:
  // noncopyable
  Batch(const Batch&);
  Batch& operator=(const Batch&);

protected:
  explicit Batch(const Glib::ConstructParams& construct_params);
  explicit Batch(GdaBatch* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Batch();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaBatch*       gobj()       { return reinterpret_cast<GdaBatch*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaBatch* gobj() const { return reinterpret_cast<GdaBatch*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaBatch* gobj_copy();

private:

protected:
  Batch();
public:
  
  static Glib::RefPtr<Batch> create();

  
  /** Copy constructor
   * @return A the new copy of @a orig.
   */
  Glib::RefPtr<Batch> copy();  
  
  
  /** Add @a stmt to the list of statements managed by @a batch. A Gda::Statement object can be
   * added multiple times to a Gda::Batch object.
   * @param stmt A statement to add to @a batch's statements list.
   */
  void add_statement(const Glib::RefPtr<Statement>& stmt);
  
  /** Removes @a stmt from the list of statements managed by @a batch. If @a stmt is present several
   * times in @a batch's statements' list, then only the first one is removed.
   * @param stmt A statement to remove from @a batch's statements list.
   */
  void remove_statement(const Glib::RefPtr<Statement>& stmt);
  
  /** Creates a string representing the contents of @a batch.
   * @return A string containing the serialized version of @a batch.
   */
  Glib::ustring serialize() const;

  typedef Glib::SListHandle<Glib::RefPtr<const Statement> > StatementSList;

  //There is no non-const override for this, because the C function returns const items.
   

  /** Get a list of the Gda::Statement objects contained in @a batch
   * @return A list of Gda::Statement which should not be modified.
   */
  StatementSList get_statements() const;

  
  /** Get a new Gda::Set object which groups all the execution parameters
   * which @a stmt needs. This new object is returned though @a out_params.
   * 
   * Note that if @a stmt does not need any parameter, then @a out_params is set to <tt>0</tt>.
   * @param out_params A place to store a new Gda::Set object, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool get_parameters(Glib::RefPtr<Set>& out_params);
  #else
  bool get_parameters(Glib::RefPtr<Set>& out_params, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    
  // FIXME: Use better marshaller in libgda. TODO: Bug number?
   

  /**
   * @par Prototype:
   * <tt>void on_my_%changed(Glib::RefPtr<Statement> stmt)</tt>
   */

  Glib::SignalProxy1< void,Glib::RefPtr<Statement> > signal_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Batch
   */
  Glib::RefPtr<Gnome::Gda::Batch> wrap(GdaBatch* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_BATCH_H */

