/**
 * @file libgalago-gtk/galago-gtk-service-menu-item.h Service menu item widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_SERVICE_MENU_ITEM_H_
#define _GALAGO_GTK_SERVICE_MENU_ITEM_H_

typedef struct _GalagoGtkServiceMenuItem      GalagoGtkServiceMenuItem;
typedef struct _GalagoGtkServiceMenuItemClass GalagoGtkServiceMenuItemClass;
typedef struct _GalagoGtkServiceMenuItemPriv  GalagoGtkServiceMenuItemPriv;

#include <libgalago/galago.h>
#include <gtk/gtkimagemenuitem.h>

#define GALAGO_GTK_TYPE_SERVICE_MENU_ITEM (galago_gtk_service_menu_item_get_type())
#define GALAGO_GTK_SERVICE_MENU_ITEM(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_SERVICE_MENU_ITEM, GalagoGtkServiceMenuItem))
#define GALAGO_GTK_SERVICE_MENU_ITEM_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_SERVICE_MENU_ITEM, GalagoGtkServiceMenuItemClass))
#define GALAGO_GTK_IS_SERVICE_MENU_ITEM(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_SERVICE_MENU_ITEM))
#define GALAGO_GTK_IS_SERVICE_MENU_ITEM_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_SERVICE_MENU_ITEM))
#define GALAGO_GTK_SERVICE_MENU_ITEM_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_SERVICE_MENU_ITEM, GalagoGtkServiceMenuItemClass))

struct _GalagoGtkServiceMenuItem
{
	GtkImageMenuItem parent_object;

	GalagoGtkServiceMenuItemPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkServiceMenuItemClass
{
	GtkImageMenuItemClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_service_menu_item_get_type(void);

GtkWidget *galago_gtk_service_menu_item_new(GalagoService *service);

void galago_gtk_service_menu_item_set_service(GalagoGtkServiceMenuItem *item,
											  GalagoService *service);

GalagoService *galago_gtk_service_menu_item_get_service(const GalagoGtkServiceMenuItem *item);

G_END_DECLS

#endif /* _GALAGO_GTK_SERVICE_MENU_ITEM_H_ */
