/* vfs-impl-gnome-vfs.c generated by valac, the Vala compiler
 * generated from vfs-impl-gnome-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS implementation (with GNOME VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <libgnomevfs/gnome-vfs.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION (desktop_agnostic_vfs_gnome_vfs_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION, DesktopAgnosticVFSGnomeVFSImplementation))
#define DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION, DesktopAgnosticVFSGnomeVFSImplementationClass))
#define DESKTOP_AGNOSTIC_VFS_IS_GNOME_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IS_GNOME_VFS_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION, DesktopAgnosticVFSGnomeVFSImplementationClass))

typedef struct _DesktopAgnosticVFSGnomeVFSImplementation DesktopAgnosticVFSGnomeVFSImplementation;
typedef struct _DesktopAgnosticVFSGnomeVFSImplementationClass DesktopAgnosticVFSGnomeVFSImplementationClass;
typedef struct _DesktopAgnosticVFSGnomeVFSImplementationPrivate DesktopAgnosticVFSGnomeVFSImplementationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS (desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFSClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorGnomeVFS DesktopAgnosticVFSVolumeMonitorGnomeVFS;
typedef struct _DesktopAgnosticVFSVolumeMonitorGnomeVFSClass DesktopAgnosticVFSVolumeMonitorGnomeVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS (desktop_agnostic_vfs_file_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileGnomeVFS DesktopAgnosticVFSFileGnomeVFS;
typedef struct _DesktopAgnosticVFSFileGnomeVFSClass DesktopAgnosticVFSFileGnomeVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS (desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFS DesktopAgnosticVFSFileMonitorGnomeVFS;
typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFSClass DesktopAgnosticVFSFileMonitorGnomeVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS (desktop_agnostic_vfs_trash_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS, DesktopAgnosticVFSTrashGnomeVFSClass))

typedef struct _DesktopAgnosticVFSTrashGnomeVFS DesktopAgnosticVFSTrashGnomeVFS;
typedef struct _DesktopAgnosticVFSTrashGnomeVFSClass DesktopAgnosticVFSTrashGnomeVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS (desktop_agnostic_vfs_volume_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFSClass))

typedef struct _DesktopAgnosticVFSVolumeGnomeVFS DesktopAgnosticVFSVolumeGnomeVFS;
typedef struct _DesktopAgnosticVFSVolumeGnomeVFSClass DesktopAgnosticVFSVolumeGnomeVFSClass;

struct _DesktopAgnosticVFSGnomeVFSImplementation {
	GObject parent_instance;
	DesktopAgnosticVFSGnomeVFSImplementationPrivate * priv;
};

struct _DesktopAgnosticVFSGnomeVFSImplementationClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSGnomeVFSImplementationPrivate {
	DesktopAgnosticVFSVolumeMonitor* vmonitor;
};


static gpointer desktop_agnostic_vfs_gnome_vfs_implementation_parent_class = NULL;
static DesktopAgnosticVFSImplementationIface* desktop_agnostic_vfs_gnome_vfs_implementation_desktop_agnostic_vfs_implementation_parent_iface = NULL;

GType desktop_agnostic_vfs_gnome_vfs_implementation_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION, DesktopAgnosticVFSGnomeVFSImplementationPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_NAME,
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE,
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_TRASH_TYPE,
	DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_VOLUME_TYPE
};
static void desktop_agnostic_vfs_gnome_vfs_implementation_real_init (DesktopAgnosticVFSImplementation* base);
static void _g_slist_free_g_object_unref (GSList* self);
static GSList* desktop_agnostic_vfs_gnome_vfs_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error);
DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_new (void);
DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_construct (GType object_type);
GType desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_type (void);
static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_gnome_vfs_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base);
static void desktop_agnostic_vfs_gnome_vfs_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base);
DesktopAgnosticVFSGnomeVFSImplementation* desktop_agnostic_vfs_gnome_vfs_implementation_new (void);
DesktopAgnosticVFSGnomeVFSImplementation* desktop_agnostic_vfs_gnome_vfs_implementation_construct (GType object_type);
GType desktop_agnostic_vfs_file_gnome_vfs_get_type (void);
GType desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type (void);
GType desktop_agnostic_vfs_trash_gnome_vfs_get_type (void);
GType desktop_agnostic_vfs_volume_gnome_vfs_get_type (void);
static void desktop_agnostic_vfs_gnome_vfs_implementation_finalize (GObject* obj);
static void desktop_agnostic_vfs_gnome_vfs_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_plugin (void);



static void desktop_agnostic_vfs_gnome_vfs_implementation_real_init (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	gnome_vfs_init ();
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_gnome_vfs_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	GSList* result;
	GError * _inner_error_;
	GSList* files;
	GList* uris;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	g_return_val_if_fail (uri_list != NULL, NULL);
	_inner_error_ = NULL;
	files = NULL;
	uris = gnome_vfs_uri_list_parse (uri_list);
	{
		GList* uri_collection;
		GList* uri_it;
		uri_collection = uris;
		for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
			GnomeVFSURI* uri;
			uri = (GnomeVFSURI*) uri_it->data;
			{
				char* uri_str;
				DesktopAgnosticVFSFile* file;
				DesktopAgnosticVFSFile* _tmp0_;
				uri_str = g_strdup (gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE));
				file = desktop_agnostic_vfs_file_new_for_uri (uri_str, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri_str);
					__g_slist_free_g_object_unref0 (files);
					return NULL;
				}
				files = g_slist_append (files, (_tmp0_ = file, file = NULL, _tmp0_));
				_g_free0 (uri_str);
				_g_object_unref0 (file);
			}
		}
	}
	result = files;
	return result;
}


static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_gnome_vfs_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	DesktopAgnosticVFSVolumeMonitor* result;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	if (self->priv->vmonitor == NULL) {
		DesktopAgnosticVFSVolumeMonitor* _tmp0_;
		self->priv->vmonitor = (_tmp0_ = (DesktopAgnosticVFSVolumeMonitor*) desktop_agnostic_vfs_volume_monitor_gnome_vfs_new (), _g_object_unref0 (self->priv->vmonitor), _tmp0_);
	}
	result = self->priv->vmonitor;
	return result;
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	gnome_vfs_shutdown ();
}


DesktopAgnosticVFSGnomeVFSImplementation* desktop_agnostic_vfs_gnome_vfs_implementation_construct (GType object_type) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSGnomeVFSImplementation* desktop_agnostic_vfs_gnome_vfs_implementation_new (void) {
	return desktop_agnostic_vfs_gnome_vfs_implementation_construct (DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION);
}


static const char* desktop_agnostic_vfs_gnome_vfs_implementation_real_get_name (DesktopAgnosticVFSImplementation* base) {
	const char* result;
	DesktopAgnosticVFSGnomeVFSImplementation* self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	result = "GNOME VFS";
	return result;
}


static GType desktop_agnostic_vfs_gnome_vfs_implementation_real_get_file_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGnomeVFSImplementation* self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS;
	return result;
}


static GType desktop_agnostic_vfs_gnome_vfs_implementation_real_get_file_monitor_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGnomeVFSImplementation* self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS;
	return result;
}


static GType desktop_agnostic_vfs_gnome_vfs_implementation_real_get_trash_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGnomeVFSImplementation* self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GNOME_VFS;
	return result;
}


static GType desktop_agnostic_vfs_gnome_vfs_implementation_real_get_volume_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGnomeVFSImplementation* self;
	self = (DesktopAgnosticVFSGnomeVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS;
	return result;
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_class_init (DesktopAgnosticVFSGnomeVFSImplementationClass * klass) {
	desktop_agnostic_vfs_gnome_vfs_implementation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSGnomeVFSImplementationPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_gnome_vfs_implementation_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_gnome_vfs_implementation_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE, "file-monitor-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_TRASH_TYPE, "trash-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_VOLUME_TYPE, "volume-type");
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_desktop_agnostic_vfs_implementation_interface_init (DesktopAgnosticVFSImplementationIface * iface) {
	desktop_agnostic_vfs_gnome_vfs_implementation_desktop_agnostic_vfs_implementation_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = desktop_agnostic_vfs_gnome_vfs_implementation_real_init;
	iface->files_from_uri_list = desktop_agnostic_vfs_gnome_vfs_implementation_real_files_from_uri_list;
	iface->volume_monitor_get_default = desktop_agnostic_vfs_gnome_vfs_implementation_real_volume_monitor_get_default;
	iface->shutdown = desktop_agnostic_vfs_gnome_vfs_implementation_real_shutdown;
	iface->get_name = desktop_agnostic_vfs_gnome_vfs_implementation_real_get_name;
	iface->get_file_type = desktop_agnostic_vfs_gnome_vfs_implementation_real_get_file_type;
	iface->get_file_monitor_type = desktop_agnostic_vfs_gnome_vfs_implementation_real_get_file_monitor_type;
	iface->get_trash_type = desktop_agnostic_vfs_gnome_vfs_implementation_real_get_trash_type;
	iface->get_volume_type = desktop_agnostic_vfs_gnome_vfs_implementation_real_get_volume_type;
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_instance_init (DesktopAgnosticVFSGnomeVFSImplementation * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_finalize (GObject* obj) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION (obj);
	_g_object_unref0 (self->priv->vmonitor);
	G_OBJECT_CLASS (desktop_agnostic_vfs_gnome_vfs_implementation_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_gnome_vfs_implementation_get_type (void) {
	static GType desktop_agnostic_vfs_gnome_vfs_implementation_type_id = 0;
	if (desktop_agnostic_vfs_gnome_vfs_implementation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSGnomeVFSImplementationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_gnome_vfs_implementation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSGnomeVFSImplementation), 0, (GInstanceInitFunc) desktop_agnostic_vfs_gnome_vfs_implementation_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_implementation_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_gnome_vfs_implementation_desktop_agnostic_vfs_implementation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		desktop_agnostic_vfs_gnome_vfs_implementation_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSGnomeVFSImplementation", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_gnome_vfs_implementation_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, &desktop_agnostic_vfs_implementation_info);
	}
	return desktop_agnostic_vfs_gnome_vfs_implementation_type_id;
}


static void desktop_agnostic_vfs_gnome_vfs_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGnomeVFSImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_implementation_get_name ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_monitor_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_TRASH_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_trash_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GNOME_VFS_IMPLEMENTATION_VOLUME_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_volume_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_GNOME_VFS_IMPLEMENTATION;
	return result;
}




