/*--------------------------------------------------------------------------+
$Id: ClassHierarchyMapTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.List;

import javax.swing.JFrame;

import junit.framework.TestCase;

/**
 * Test for {@link ClassHierarchyMap}.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: A7BD4A89D28B0E0DA05089B4BF217792
 */
public class ClassHierarchyMapTest extends TestCase {
	/**
	 * Test for {@link ClassHierarchyMap#get(Class)} and
	 * {@link ClassHierarchyMap#get(Object)}.
	 */
	public void testGet() {
		ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
		assertNull(map.get(""));
		assertNull(map.get(String.class));

		map.put(Object.class, "object");
		assertEquals("object", map.get(Object.class));
		assertEquals("object", map.get(new Object()));
		assertEquals("object", map.get(String.class));
		assertEquals("object", map.get(""));

		map.put(String.class, "string");
		assertEquals("object", map.get(Object.class));
		assertEquals("object", map.get(new Object()));
		assertEquals("string", map.get(String.class));
		assertEquals("string", map.get(""));
	}

	/**
	 * Test for {@link ClassHierarchyMap#getDeclared(Class)} and
	 * {@link ClassHierarchyMap#getDeclared(Object)}.
	 */
	public void testGetDeclared() {
		ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
		assertNull(map.get(""));
		assertNull(map.get(String.class));

		map.put(Object.class, "object");
		assertEquals("object", map.getDeclared(Object.class));
		assertEquals("object", map.getDeclared(new Object()));
		assertNull(map.getDeclared(String.class));
		assertNull(map.getDeclared(""));

		map.put(String.class, "string");
		assertEquals("object", map.getDeclared(Object.class));
		assertEquals("object", map.getDeclared(new Object()));
		assertEquals("string", map.getDeclared(String.class));
		assertEquals("string", map.getDeclared(""));
	}

	/**
	 * Test for {@link ClassHierarchyMap#getAll(Class)} and
	 * {@link ClassHierarchyMap#getAll(Object)}.
	 */
	public void testGetAllDeepHierarchy() {
		ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();

		map.put(JFrame.class, "JFrame");
		map.put(Container.class, "Container");
		map.put(Component.class, "Component");

		List<String> list = map.getAll(JFrame.class);
		assertEquals(3, list.size());
		assertEquals("JFrame", list.get(0));
		assertEquals("Container", list.get(1));
		assertEquals("Component", list.get(2));

		list = map.getAll(Window.class);
		assertEquals(2, list.size());
		assertEquals("Container", list.get(0));
		assertEquals("Component", list.get(1));

		list = map.getAll(Object.class);
		assertTrue(list.isEmpty());
	}

	/**
	 * Test for {@link ClassHierarchyMap#getAll(Class)} and
	 * {@link ClassHierarchyMap#getAll(Object)}.
	 */
	public void testGetAllShallowHierarchy() {
		ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();

		map.put(Object.class, "object");
		assertEquals("object", map.get(String.class));
		map.put(String.class, "string");
		assertEquals("string", map.get(String.class));

		List<String> list = map.getAll(String.class);
		assertEquals(2, list.size());
		assertEquals("string", list.get(0));
		assertEquals("object", list.get(1));

		list = map.getAll("");
		assertEquals(2, list.size());
		assertEquals("string", list.get(0));
		assertEquals("object", list.get(1));

		list = map.getAll(Object.class);
		assertEquals(1, list.size());
		assertEquals("object", list.get(0));

		list = map.getAll(new Object());
		assertEquals(1, list.size());
		assertEquals("object", list.get(0));

		list = map.getAll(Integer.class);
		assertEquals(1, list.size());
		assertEquals("object", list.get(0));

		list = map.getAll(1);
		assertEquals(1, list.size());
		assertEquals("object", list.get(0));

	}
}