/*--------------------------------------------------------------------------+
$Id: DirectoryOnlyFilter.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.File;
import java.io.FileFilter;

/**
 * This is a file filter which accepts only directories and rejects files.
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 6FA6B175E80D76BCB3A1B1736E12B3C1
 */
public class DirectoryOnlyFilter implements FileFilter {

	/** Accepts directories and rejects files. */
	public boolean accept(File file) {
		return file.isDirectory();
	}
}