/*============================================================================
 * Main BFT documentation page
 *============================================================================*/

/*
  This file is part of the "Base Functions and Types" library, intended to
  simplify and enhance portability, memory and I/O use for scientific codes.

  Copyright (C) 2004  EDF

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*-----------------------------------------------------------------------------*/

/*!
 \mainpage BFT documentation
 
 \section intro Introduction

 The "Base Functions and Types" library is intended to simplify and enhance
 portability, memory and I/O use for scientific codes. It contains
 a number of system library wrappers for common services such as file
 I/O or memory management, ensuring portability of the calling code.

 \subsection intro_portability Portability

 Using lower-level services in C or C++ often requires the definition
 of preprocessor symbols such as \c _POSIX_SOURCE (or \c OSF_SOURCE, or
 \c HPUX_SOURCE, ...). On certain systems, largefile support also requires
 additionnal preprocessor symbols such as \c _FILE_OFFSET_BITS or
 \c _LARGEFILE_SOURCE, and \c fseek/ftell replaced with \c fseeko/ftello.
 
 Authors of scientific code seeking portability should not have to worry
 about these issues unless they deliberately choose to use low-level functions.
 BFT tries to hide such portability issues while maintaining an API similar
 to that of the standard \c libc where applicable.
 
 \subsection intro_retcode_error Return codes and error handling

 In most scientific codes destined to run in a batch environment, errors are
 usually fatal, especially when dealing with file access and memory allocation.
 The functions provided by the BFT library always check for return codes,
 and call the appropriate error handler when applicable. The default is
 to terminate the running program after printing the appropriate message,
 but the user may define and set other error handlers with different
 behavior.

 \subsection intro_add_func Added functionnality

 BFT functions similar to \c libc functions add functionnality such
 as optional byte-swapping for conversion from internal to external
 data repressentation (or vice-versa), or optional memory-allocation
 logging and tracking of non-freed pointers.

 \subsection intro_goals Goals and Limitations

 The BFT library tries to provide a set of utilitarian functions for
 common use, but does not seek to define a framework. As a general
 rule, functions provided by BFT should provide added portability
 or functionnality when compared to their \c libc or Posix counterparts
 (when such counterparts exist), as simple wrapping with no added
 functionnality only makes code less readable to an experienced developper
 and is to be avoided.

 Subsets of BFT may be used independently if desired, and are orthogonal,
 except as regards error handlers. With non-default error handlers, they
 can be made fully orthogonal. Only certain subsets may be used if
 preferred.

 The BFT library provides memory-usage measurement functions, whose
 implementations are system-dependent. If it has not yet been ported
 to a given type of environment, these functions should return 0.
 The user should thus check for the return values of such functions,
 but the API is guaranteed.

 \section install Installation

 The BFT library may be configured and installed using the
 \c configure shell script and \c make. Please read the \c INSTALL
 file in the toplevel source directory if you are not familiar
 with configuration scripts generated through GNU autoconf and automake.
*/
