/* 
 **  mod_layout.h -- Common defines.
 **  $Revision: 1.1.1.1 $
*/

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "http_log.h"
#include "http_request.h"
#include "ap_config.h"
#include "apr_buckets.h"
#include "apr_strings.h"
#include "apr_lib.h"
#include "apr_tables.h"
#include "apr_fnmatch.h"
#include "util_filter.h"
#include <string.h>
#include "version.h"
#include "directives.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


#define BUFFER_LENGTH 1024

#define UNSET (-1)
#define OFF (0)
#define ON (1)
#define isOff(a) ((a == ON) ? 0 : 1 )
#define isOn(a) ((a == ON) ? 1 : 0 )

/* layout states */
#define LAYOUT (0)
#define HTTP (1)
#define HEADER (2)
#define ORIGIN (3)
#define FOOTER (4)

/* layout ? */
#define APPEND (1)
#define REPLACE (2)
#define PREPEND (3)

#ifndef __WATCHPOINT_H__
#define __WATCHPOINT_H__
/* Some personal debugging functions */
#ifdef HAVE_DEBUG
#define WATCHPOINT printf("\nWATCHPOINT %s:%d (%s)\n", __FILE__, __LINE__,__func__);fflush(stdout);
#define WATCHPOINT_STRING(A) printf("\nWATCHPOINT %s:%d (%s) %s\n", __FILE__, __LINE__,__func__,A);fflush(stdout);
#define WATCHPOINT_STRING_LENGTH(A,B) printf("\nWATCHPOINT %s:%d (%s) %.*s\n", __FILE__, __LINE__,__func__,(int)B,A);fflush(stdout);
#define WATCHPOINT_NUMBER(A) printf("\nWATCHPOINT %s:%d (%s) %zu\n", __FILE__, __LINE__,__func__,(size_t)(A));fflush(stdout);
#define WATCHPOINT_ERRNO(A) printf("\nWATCHPOINT %s:%d (%s) %s\n", __FILE__, __LINE__,__func__, strerror(A));A= 0;fflush(stdout);
#define WATCHPOINT_ASSERT(A) assert((A));
#else
#define WATCHPOINT
#define WATCHPOINT_STRING(A)
#define WATCHPOINT_STRING_LENGTH(A,B)
#define WATCHPOINT_NUMBER(A)
#define WATCHPOINT_ERRNO(A)
#define WATCHPOINT_ASSERT(A)
#endif

#endif /* __WATCHPOINT_H__ */
#define LAYOUT_EXPORT(type)    type

#define LAYOUT_BEGINTAG "<body*>"
#define LAYOUT_ENDTAG "</body>"
#define LAYOUT_TIMEFORMAT "%A, %d-%b-%Y %H:%M:%S %Z"

typedef struct {
  int type;									/* If it is static, file, dynamic */
  int kind;									/* Header, Footer or random layout */
  int append;								/* Either APPEND, REPLACE, or PREPEND */
  const char *string;				/* Whatever the layout is */
  const char *comment;			/* The comment that is displayed if comments are on */
  const char *pattern;			/* The pattern we match against */
} layout_string;

typedef struct {
  size_t size;
  char *file;
} mmap_data;

typedef struct {
  int header;
  int footer;
  int length;
  int http;
  int origin;
  const char *type;
  const char *mime;
  ap_filter_t *f; 
  apr_bucket_brigade *b;
} layout_request;

typedef struct {
  apr_array_header_t *layouts;
  int header_enabled;
  int footer_enabled;
  int display_origin;
  apr_table_t *override;
  apr_table_t *override_uri;
  int comment;
  /* These next three variables change with each request */
  const char *time_format;
  apr_table_t *uris_ignore;
  apr_table_t *uris_ignore_header;
  apr_table_t *uris_ignore_footer;
  apr_table_t *tag_ignore;
  apr_table_t *tag_ignore_footer;
  apr_table_t *tag_ignore_header;
  int append_header;
  int append_footer;
  int notes;
  const char *begin_tag;
  const char *end_tag;
  const char *dir;
} layout_conf;

typedef struct layout_filter_struct {
  apr_bucket_brigade *b;
  const char *output;
} layout_filter_struct;

#include "proto.h"
