#ifndef FFMPEG_ACCES_H
#define FFMPEG_ACCES_H

#include "avcodec.h"
#include "avformat.h"

typedef struct FfmpegMovie{
  AVFormatContext *pFormatCtx;
  AVCodecContext *pCodecCtx;
  AVFrame         *pCurrentFrame;
  AVFrame* pConvertedFrame;
  int videoStream;
  void* ppmData;
}FfmpegMovie;

int ffmpegLoadMovie(char* movieName , FfmpegMovie* resultMovie);

int ffmpegConvertCurrentFrame(FfmpegMovie* movie);
int ffmpegNextFrame(FfmpegMovie* movie);
int ffmpegResetMovieToStart(FfmpegMovie* movie);
void ffmpegMovieBackToStart(FfmpegMovie* movie);
int ffmpegInit();


int saveTIFFPictureToFile(char* fileName,char* buffer,unsigned int width, unsigned int height);

int ffmpegErrorOccured();
char* ffmpegLastErrorOccured();

#endif
