/* -*- mode: c; c-basic-offset: 8; indent-tabs-mode: nil; -*-
 * vim:expandtab:shiftwidth=8:tabstop=8:
 *
 * GPL HEADER START
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License version 2 for more details (a copy is included
 * in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; If not, see
 * http://www.sun.com/software/products/lustre/docs/GPLv2.pdf
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 *
 * GPL HEADER END
 */
/*
 * Copyright  2008 Sun Microsystems, Inc. All rights reserved
 * Use is subject to license terms.
 */
/*
 * This file is part of Lustre, http://www.lustre.org/
 * Lustre is a trademark of Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <liblustre.h>
#include <lustre_lib.h>
#include <lustre/lustre_idl.h>
#include <lustre_disk.h>

#undef LASSERT
#undef LASSERTF
#define CLASSERT(cond) ({ switch(42) { case (cond): case 0: break; } })
#define LASSERT(cond) if (!(cond)) { printf("failed " #cond "\n"); ret = 1; }
#define LASSERTF(cond, fmt, arg) if (!(cond)) { printf("failed '" #cond "'" fmt, arg);ret = 1;}

int ret;

void lustre_assert_wire_constants(void);

int main()
{
        lustre_assert_wire_constants();

        if (ret == 0)
                printf("wire constants OK\n");

        return ret;
}
void lustre_assert_wire_constants(void)
{
        /* Wire protocol assertions generated by 'wirecheck'
         * (make -C lustre/utils newwiretest)
         * running on Linux localhost.localdomain 2.6.18-prep #3 SMP Sun Nov 23 08:04:44 EST 2008 i68
         * with gcc version 4.1.1 20061011 (Red Hat 4.1.1-30) */


        /* Constants... */
        LASSERTF(LUSTRE_MSG_MAGIC_V1 == 0x0BD00BD0," found %lld\n",
                 (long long)LUSTRE_MSG_MAGIC_V1);
        LASSERTF(LUSTRE_MSG_MAGIC_V2 == 0x0BD00BD3," found %lld\n",
                 (long long)LUSTRE_MSG_MAGIC_V2);
        LASSERTF(PTLRPC_MSG_VERSION == 0x00000003," found %lld\n",
                 (long long)PTLRPC_MSG_VERSION);
        LASSERTF(MSGHDR_AT_SUPPORT == 1, " found %lld\n",
                 (long long)MSGHDR_AT_SUPPORT);
        LASSERTF(PTL_RPC_MSG_REQUEST == 4711, " found %lld\n",
                 (long long)PTL_RPC_MSG_REQUEST);
        LASSERTF(PTL_RPC_MSG_ERR == 4712, " found %lld\n",
                 (long long)PTL_RPC_MSG_ERR);
        LASSERTF(PTL_RPC_MSG_REPLY == 4713, " found %lld\n",
                 (long long)PTL_RPC_MSG_REPLY);
        LASSERTF(MSG_LAST_REPLAY == 1, " found %lld\n",
                 (long long)MSG_LAST_REPLAY);
        LASSERTF(MSG_RESENT == 2, " found %lld\n",
                 (long long)MSG_RESENT);
        LASSERTF(MSG_REPLAY == 4, " found %lld\n",
                 (long long)MSG_REPLAY);
        LASSERTF(MSG_CONNECT_RECOVERING == 1, " found %lld\n",
                 (long long)MSG_CONNECT_RECOVERING);
        LASSERTF(MSG_CONNECT_RECONNECT == 2, " found %lld\n",
                 (long long)MSG_CONNECT_RECONNECT);
        LASSERTF(MSG_CONNECT_REPLAYABLE == 4, " found %lld\n",
                 (long long)MSG_CONNECT_REPLAYABLE);
        LASSERTF(OST_REPLY == 0, " found %lld\n",
                 (long long)OST_REPLY);
        LASSERTF(OST_GETATTR == 1, " found %lld\n",
                 (long long)OST_GETATTR);
        LASSERTF(OST_SETATTR == 2, " found %lld\n",
                 (long long)OST_SETATTR);
        LASSERTF(OST_READ == 3, " found %lld\n",
                 (long long)OST_READ);
        LASSERTF(OST_WRITE == 4, " found %lld\n",
                 (long long)OST_WRITE);
        LASSERTF(OST_CREATE == 5, " found %lld\n",
                 (long long)OST_CREATE);
        LASSERTF(OST_DESTROY == 6, " found %lld\n",
                 (long long)OST_DESTROY);
        LASSERTF(OST_GET_INFO == 7, " found %lld\n",
                 (long long)OST_GET_INFO);
        LASSERTF(OST_CONNECT == 8, " found %lld\n",
                 (long long)OST_CONNECT);
        LASSERTF(OST_DISCONNECT == 9, " found %lld\n",
                 (long long)OST_DISCONNECT);
        LASSERTF(OST_PUNCH == 10, " found %lld\n",
                 (long long)OST_PUNCH);
        LASSERTF(OST_OPEN == 11, " found %lld\n",
                 (long long)OST_OPEN);
        LASSERTF(OST_CLOSE == 12, " found %lld\n",
                 (long long)OST_CLOSE);
        LASSERTF(OST_STATFS == 13, " found %lld\n",
                 (long long)OST_STATFS);
        LASSERTF(OST_SYNC == 16, " found %lld\n",
                 (long long)OST_SYNC);
        LASSERTF(OST_QUOTACHECK == 18, " found %lld\n",
                 (long long)OST_QUOTACHECK);
        LASSERTF(OST_QUOTACTL == 19, " found %lld\n",
                 (long long)OST_QUOTACTL);
        LASSERTF(OST_QUOTA_ADJUST_QUNIT == 20, " found %lld\n",
                 (long long)OST_QUOTA_ADJUST_QUNIT);
        LASSERTF(OST_LAST_OPC == 21, " found %lld\n",
                 (long long)OST_LAST_OPC);
        LASSERTF(OBD_OBJECT_EOF == 0xffffffffffffffffULL," found %lld\n",
                 (long long)OBD_OBJECT_EOF);
        LASSERTF(MDS_GETATTR == 33, " found %lld\n",
                 (long long)MDS_GETATTR);
        LASSERTF(MDS_GETATTR_NAME == 34, " found %lld\n",
                 (long long)MDS_GETATTR_NAME);
        LASSERTF(MDS_CLOSE == 35, " found %lld\n",
                 (long long)MDS_CLOSE);
        LASSERTF(MDS_REINT == 36, " found %lld\n",
                 (long long)MDS_REINT);
        LASSERTF(MDS_READPAGE == 37, " found %lld\n",
                 (long long)MDS_READPAGE);
        LASSERTF(MDS_CONNECT == 38, " found %lld\n",
                 (long long)MDS_CONNECT);
        LASSERTF(MDS_DISCONNECT == 39, " found %lld\n",
                 (long long)MDS_DISCONNECT);
        LASSERTF(MDS_GETSTATUS == 40, " found %lld\n",
                 (long long)MDS_GETSTATUS);
        LASSERTF(MDS_STATFS == 41, " found %lld\n",
                 (long long)MDS_STATFS);
        LASSERTF(MDS_PIN == 42, " found %lld\n",
                 (long long)MDS_PIN);
        LASSERTF(MDS_UNPIN == 43, " found %lld\n",
                 (long long)MDS_UNPIN);
        LASSERTF(MDS_SYNC == 44, " found %lld\n",
                 (long long)MDS_SYNC);
        LASSERTF(MDS_DONE_WRITING == 45, " found %lld\n",
                 (long long)MDS_DONE_WRITING);
        LASSERTF(MDS_SET_INFO == 46, " found %lld\n",
                 (long long)MDS_SET_INFO);
        LASSERTF(MDS_QUOTACHECK == 47, " found %lld\n",
                 (long long)MDS_QUOTACHECK);
        LASSERTF(MDS_QUOTACTL == 48, " found %lld\n",
                 (long long)MDS_QUOTACTL);
        LASSERTF(MDS_GETXATTR == 49, " found %lld\n",
                 (long long)MDS_GETXATTR);
        LASSERTF(MDS_SETXATTR == 50, " found %lld\n",
                 (long long)MDS_SETXATTR);
        LASSERTF(MDS_WRITEPAGE == 51, " found %lld\n",
                 (long long)MDS_WRITEPAGE);
        LASSERTF(MDS_IS_SUBDIR == 52, " found %lld\n",
                 (long long)MDS_IS_SUBDIR);
        LASSERTF(MDS_LAST_OPC == 53, " found %lld\n",
                 (long long)MDS_LAST_OPC);
        LASSERTF(REINT_SETATTR == 1, " found %lld\n",
                 (long long)REINT_SETATTR);
        LASSERTF(REINT_CREATE == 2, " found %lld\n",
                 (long long)REINT_CREATE);
        LASSERTF(REINT_LINK == 3, " found %lld\n",
                 (long long)REINT_LINK);
        LASSERTF(REINT_UNLINK == 4, " found %lld\n",
                 (long long)REINT_UNLINK);
        LASSERTF(REINT_RENAME == 5, " found %lld\n",
                 (long long)REINT_RENAME);
        LASSERTF(REINT_OPEN == 6, " found %lld\n",
                 (long long)REINT_OPEN);
        LASSERTF(REINT_SETXATTR == 7, " found %lld\n",
                 (long long)REINT_SETXATTR);
        LASSERTF(REINT_MAX == 8, " found %lld\n",
                 (long long)REINT_MAX);
        LASSERTF(MGS_CONNECT == 250, " found %lld\n",
                 (long long)MGS_CONNECT);
        LASSERTF(MGS_DISCONNECT == 251, " found %lld\n",
                 (long long)MGS_DISCONNECT);
        LASSERTF(MGS_EXCEPTION == 252, " found %lld\n",
                 (long long)MGS_EXCEPTION);
        LASSERTF(MGS_TARGET_REG == 253, " found %lld\n",
                 (long long)MGS_TARGET_REG);
        LASSERTF(MGS_TARGET_DEL == 254, " found %lld\n",
                 (long long)MGS_TARGET_DEL);
        LASSERTF(MGS_SET_INFO == 255, " found %lld\n",
                 (long long)MGS_SET_INFO);
        LASSERTF(DISP_IT_EXECD == 1, " found %lld\n",
                 (long long)DISP_IT_EXECD);
        LASSERTF(DISP_LOOKUP_EXECD == 2, " found %lld\n",
                 (long long)DISP_LOOKUP_EXECD);
        LASSERTF(DISP_LOOKUP_NEG == 4, " found %lld\n",
                 (long long)DISP_LOOKUP_NEG);
        LASSERTF(DISP_LOOKUP_POS == 8, " found %lld\n",
                 (long long)DISP_LOOKUP_POS);
        LASSERTF(DISP_OPEN_CREATE == 16, " found %lld\n",
                 (long long)DISP_OPEN_CREATE);
        LASSERTF(DISP_OPEN_OPEN == 32, " found %lld\n",
                 (long long)DISP_OPEN_OPEN);
        LASSERTF(MDS_STATUS_CONN == 1, " found %lld\n",
                 (long long)MDS_STATUS_CONN);
        LASSERTF(MDS_STATUS_LOV == 2, " found %lld\n",
                 (long long)MDS_STATUS_LOV);
        LASSERTF(LDLM_ENQUEUE == 101, " found %lld\n",
                 (long long)LDLM_ENQUEUE);
        LASSERTF(LDLM_CONVERT == 102, " found %lld\n",
                 (long long)LDLM_CONVERT);
        LASSERTF(LDLM_CANCEL == 103, " found %lld\n",
                 (long long)LDLM_CANCEL);
        LASSERTF(LDLM_BL_CALLBACK == 104, " found %lld\n",
                 (long long)LDLM_BL_CALLBACK);
        LASSERTF(LDLM_CP_CALLBACK == 105, " found %lld\n",
                 (long long)LDLM_CP_CALLBACK);
        LASSERTF(LDLM_GL_CALLBACK == 106, " found %lld\n",
                 (long long)LDLM_GL_CALLBACK);
        LASSERTF(LDLM_LAST_OPC == 107, " found %lld\n",
                 (long long)LDLM_LAST_OPC);
        LASSERTF(LCK_EX == 1, " found %lld\n",
                 (long long)LCK_EX);
        LASSERTF(LCK_PW == 2, " found %lld\n",
                 (long long)LCK_PW);
        LASSERTF(LCK_PR == 4, " found %lld\n",
                 (long long)LCK_PR);
        LASSERTF(LCK_CW == 8, " found %lld\n",
                 (long long)LCK_CW);
        LASSERTF(LCK_CR == 16, " found %lld\n",
                 (long long)LCK_CR);
        LASSERTF(LCK_NL == 32, " found %lld\n",
                 (long long)LCK_NL);
        LASSERTF(LCK_GROUP == 64, " found %lld\n",
                 (long long)LCK_GROUP);
        LASSERTF(LCK_MAXMODE == 65, " found %lld\n",
                 (long long)LCK_MAXMODE);
        LASSERTF(LCK_MODE_NUM == 7, " found %lld\n",
                 (long long)LCK_MODE_NUM);
        CLASSERT(LDLM_PLAIN == 10);
        CLASSERT(LDLM_EXTENT == 11);
        CLASSERT(LDLM_FLOCK == 12);
        CLASSERT(LDLM_IBITS == 13);
        LASSERTF(OBD_PING == 400, " found %lld\n",
                 (long long)OBD_PING);
        LASSERTF(OBD_LOG_CANCEL == 401, " found %lld\n",
                 (long long)OBD_LOG_CANCEL);
        LASSERTF(OBD_QC_CALLBACK == 402, " found %lld\n",
                 (long long)OBD_QC_CALLBACK);
        LASSERTF(OBD_LAST_OPC == 403, " found %lld\n",
                 (long long)OBD_LAST_OPC);
        LASSERTF(QUOTA_DQACQ == 601, " found %lld\n",
                 (long long)QUOTA_DQACQ);
        LASSERTF(QUOTA_DQREL == 602, " found %lld\n",
                 (long long)QUOTA_DQREL);
        LASSERTF(MGS_CONNECT == 250, " found %lld\n",
                 (long long)MGS_CONNECT);
        LASSERTF(MGS_DISCONNECT == 251, " found %lld\n",
                 (long long)MGS_DISCONNECT);
        LASSERTF(MGS_EXCEPTION == 252, " found %lld\n",
                 (long long)MGS_EXCEPTION);
        LASSERTF(MGS_TARGET_REG == 253, " found %lld\n",
                 (long long)MGS_TARGET_REG);
        LASSERTF(MGS_TARGET_DEL == 254, " found %lld\n",
                 (long long)MGS_TARGET_DEL);
        LASSERTF(MGS_SET_INFO == 255, " found %lld\n",
                 (long long)MGS_SET_INFO);
        /* Sizes and Offsets */

        /* Checks for struct obd_uuid */
        LASSERTF((int)sizeof(struct obd_uuid) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct obd_uuid));

        /* Checks for struct lustre_handle */
        LASSERTF((int)sizeof(struct lustre_handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(struct lustre_handle));
        LASSERTF((int)offsetof(struct lustre_handle, cookie) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_handle, cookie));
        LASSERTF((int)sizeof(((struct lustre_handle *)0)->cookie) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_handle *)0)->cookie));

        /* Checks for struct lustre_msg_v1 */
        LASSERTF((int)sizeof(struct lustre_msg_v1) == 64, " found %lld\n",
                 (long long)(int)sizeof(struct lustre_msg_v1));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_handle) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_handle));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_handle));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_magic) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_magic));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_magic) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_magic));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_type) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_type));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_type));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_version) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_version));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_version) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_version));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_opc) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_opc));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_opc) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_opc));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_last_xid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_last_xid));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_last_xid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_last_xid));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_last_committed) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_last_committed));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_last_committed) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_last_committed));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_transno) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_transno));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_transno) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_transno));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_status) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_status));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_status) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_status));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_flags) == 52, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_flags));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_flags));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_conn_cnt) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_conn_cnt));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_conn_cnt) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_conn_cnt));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_bufcount) == 60, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_bufcount));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_bufcount) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_bufcount));
        LASSERTF((int)offsetof(struct lustre_msg_v1, lm_buflens[0]) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v1, lm_buflens[0]));
        LASSERTF((int)sizeof(((struct lustre_msg_v1 *)0)->lm_buflens[0]) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v1 *)0)->lm_buflens[0]));

        /* Checks for struct lustre_msg_v2 */
        LASSERTF((int)sizeof(struct lustre_msg_v2) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct lustre_msg_v2));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_bufcount) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_bufcount));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_secflvr) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_secflvr));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_magic) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_magic));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_repsize) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_repsize));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_cksum) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_cksum));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_flags) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_flags));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_2) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_2));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_3) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_3));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3));
        LASSERTF((int)offsetof(struct lustre_msg_v2, lm_buflens[0]) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_msg_v2, lm_buflens[0]));
        LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]));
        LASSERT(offsetof(struct lustre_msg_v1, lm_magic) == offsetof(struct lustre_msg_v2, lm_magic));

        /* Checks for struct ptlrpc_body */
        LASSERTF((int)sizeof(struct ptlrpc_body) == 152, " found %lld\n",
                 (long long)(int)sizeof(struct ptlrpc_body));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_handle) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_handle));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_handle));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_type) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_type));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_type));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_version) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_version));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_version) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_version));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_opc) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_opc));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_opc) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_opc));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_status) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_status));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_status) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_status));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_last_xid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_last_xid));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_last_xid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_last_xid));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_last_seen) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_last_seen));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_last_seen) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_last_seen));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_last_committed) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_last_committed));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_last_committed) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_last_committed));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_transno) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_transno));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_transno) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_transno));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_flags) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_flags));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_flags));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_op_flags) == 60, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_op_flags));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_op_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_op_flags));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_conn_cnt) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_conn_cnt));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_conn_cnt) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_conn_cnt));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_timeout) == 68, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_timeout));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_timeout) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_timeout));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_service_time) == 72, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_service_time));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_service_time) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_service_time));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_slv) == 80, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_slv));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_slv) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_slv));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_limit) == 76, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_limit));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_limit) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_limit));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_pre_versions) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_pre_versions));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_pre_versions) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_pre_versions));
        LASSERTF((int)offsetof(struct ptlrpc_body, pb_padding) == 120, " found %lld\n",
                 (long long)(int)offsetof(struct ptlrpc_body, pb_padding));
        LASSERTF((int)sizeof(((struct ptlrpc_body *)0)->pb_padding) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct ptlrpc_body *)0)->pb_padding));

        /* Checks for struct obd_connect_data */
        LASSERTF((int)sizeof(struct obd_connect_data) == 72, " found %lld\n",
                 (long long)(int)sizeof(struct obd_connect_data));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_connect_flags) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_connect_flags));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_version) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_version));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_version) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_version));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_grant));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_index) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_index));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_index));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_brw_size) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_brw_size));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_ibits_known) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_ibits_known));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_nllu) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_nllu));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_nllu) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_nllu));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_nllg) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_nllg));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_nllg) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_nllg));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_transno) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_transno));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_transno) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_transno));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_group) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_group));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_group) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_group));
        LASSERTF((int)offsetof(struct obd_connect_data, ocd_cksum_types) == 52, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, ocd_cksum_types));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types));
        LASSERTF((int)offsetof(struct obd_connect_data, padding1) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, padding1));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding1) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding1));
        LASSERTF((int)offsetof(struct obd_connect_data, padding2) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct obd_connect_data, padding2));
        LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding2) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding2));
        CLASSERT(OBD_CONNECT_RDONLY == 0x1ULL);
        CLASSERT(OBD_CONNECT_INDEX == 0x2ULL);
        CLASSERT(OBD_CONNECT_GRANT == 0x8ULL);
        CLASSERT(OBD_CONNECT_SRVLOCK == 0x10ULL);
        CLASSERT(OBD_CONNECT_VERSION == 0x20ULL);
        CLASSERT(OBD_CONNECT_REQPORTAL == 0x40ULL);
        CLASSERT(OBD_CONNECT_ACL == 0x80ULL);
        CLASSERT(OBD_CONNECT_XATTR == 0x100ULL);
        CLASSERT(OBD_CONNECT_CROW == 0x200ULL);
        CLASSERT(OBD_CONNECT_TRUNCLOCK == 0x400ULL);
        CLASSERT(OBD_CONNECT_TRANSNO == 0x800ULL);
        CLASSERT(OBD_CONNECT_IBITS == 0x1000ULL);
        CLASSERT(OBD_CONNECT_JOIN == 0x2000ULL);
        CLASSERT(OBD_CONNECT_ATTRFID == 0x4000ULL);
        CLASSERT(OBD_CONNECT_NODEVOH == 0x8000ULL);
        CLASSERT(OBD_CONNECT_RMT_CLIENT == 0x10000ULL);
        CLASSERT(OBD_CONNECT_RMT_CLIENT_FORCE == 0x20000ULL);
        CLASSERT(OBD_CONNECT_BRW_SIZE == 0x40000ULL);
        CLASSERT(OBD_CONNECT_QUOTA64 == 0x80000ULL);
        CLASSERT(OBD_CONNECT_MDS_CAPA == 0x100000ULL);
        CLASSERT(OBD_CONNECT_OSS_CAPA == 0x200000ULL);
        CLASSERT(OBD_CONNECT_CANCELSET == 0x400000ULL);
        CLASSERT(OBD_CONNECT_SOM == 0x00800000ULL);
        CLASSERT(OBD_CONNECT_AT == 0x01000000ULL);
        CLASSERT(OBD_CONNECT_LRU_RESIZE == 0x02000000ULL);
        CLASSERT(OBD_CONNECT_MDS_MDS == 0x04000000ULL);
        CLASSERT(OBD_CONNECT_REAL == 0x08000000ULL);
        CLASSERT(OBD_CONNECT_FID == 0x40000000ULL);
        CLASSERT(OBD_CONNECT_CKSUM == 0x20000000ULL);
        CLASSERT(OBD_CONNECT_VBR == 0x80000000ULL);

        /* Checks for struct obdo */
        LASSERTF((int)sizeof(struct obdo) == 208, " found %lld\n",
                 (long long)(int)sizeof(struct obdo));
        LASSERTF((int)offsetof(struct obdo, o_valid) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_valid));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_valid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_valid));
        LASSERTF((int)offsetof(struct obdo, o_id) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_id));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_id));
        LASSERTF((int)offsetof(struct obdo, o_gr) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_gr));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_gr));
        LASSERTF((int)offsetof(struct obdo, o_fid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_fid));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_fid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_fid));
        LASSERTF((int)offsetof(struct obdo, o_size) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_size));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_size) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_size));
        LASSERTF((int)offsetof(struct obdo, o_mtime) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_mtime));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_mtime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_mtime));
        LASSERTF((int)offsetof(struct obdo, o_atime) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_atime));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_atime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_atime));
        LASSERTF((int)offsetof(struct obdo, o_ctime) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_ctime));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_ctime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_ctime));
        LASSERTF((int)offsetof(struct obdo, o_blocks) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_blocks));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_blocks) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_blocks));
        LASSERTF((int)offsetof(struct obdo, o_grant) == 72, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_grant));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_grant) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_grant));
        LASSERTF((int)offsetof(struct obdo, o_blksize) == 80, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_blksize));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_blksize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_blksize));
        LASSERTF((int)offsetof(struct obdo, o_mode) == 84, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_mode));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_mode));
        LASSERTF((int)offsetof(struct obdo, o_uid) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_uid));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_uid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_uid));
        LASSERTF((int)offsetof(struct obdo, o_gid) == 92, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_gid));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_gid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_gid));
        LASSERTF((int)offsetof(struct obdo, o_flags) == 96, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_flags));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_flags));
        LASSERTF((int)offsetof(struct obdo, o_nlink) == 100, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_nlink));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_nlink) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_nlink));
        LASSERTF((int)offsetof(struct obdo, o_generation) == 104, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_generation));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_generation) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_generation));
        LASSERTF((int)offsetof(struct obdo, o_misc) == 108, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_misc));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_misc) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_misc));
        LASSERTF((int)offsetof(struct obdo, o_easize) == 112, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_easize));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_easize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_easize));
        LASSERTF((int)offsetof(struct obdo, o_mds) == 116, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_mds));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_mds) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_mds));
        LASSERTF((int)offsetof(struct obdo, o_stripe_idx) == 120, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_stripe_idx));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_stripe_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_stripe_idx));
        LASSERTF((int)offsetof(struct obdo, o_padding_1) == 124, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_1));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_1));
        LASSERTF((int)offsetof(struct obdo, o_handle) == 128, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_handle));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_handle));
        LASSERTF((int)offsetof(struct obdo, o_lcookie) == 136, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_lcookie));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_lcookie) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_lcookie));
        LASSERTF((int)offsetof(struct obdo, o_padding_2) == 168, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_2));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_2) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_2));
        LASSERTF((int)offsetof(struct obdo, o_padding_3) == 176, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_3));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_3) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_3));
        LASSERTF((int)offsetof(struct obdo, o_padding_4) == 184, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_4));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_4) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_4));
        LASSERTF((int)offsetof(struct obdo, o_padding_5) == 192, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_5));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_5) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_5));
        LASSERTF((int)offsetof(struct obdo, o_padding_6) == 200, " found %lld\n",
                 (long long)(int)offsetof(struct obdo, o_padding_6));
        LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_6) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obdo *)0)->o_padding_6));
        CLASSERT(OBD_MD_FLID == (0x00000001ULL));
        CLASSERT(OBD_MD_FLATIME == (0x00000002ULL));
        CLASSERT(OBD_MD_FLMTIME == (0x00000004ULL));
        CLASSERT(OBD_MD_FLCTIME == (0x00000008ULL));
        CLASSERT(OBD_MD_FLSIZE == (0x00000010ULL));
        CLASSERT(OBD_MD_FLBLOCKS == (0x00000020ULL));
        CLASSERT(OBD_MD_FLBLKSZ == (0x00000040ULL));
        CLASSERT(OBD_MD_FLMODE == (0x00000080ULL));
        CLASSERT(OBD_MD_FLTYPE == (0x00000100ULL));
        CLASSERT(OBD_MD_FLUID == (0x00000200ULL));
        CLASSERT(OBD_MD_FLGID == (0x00000400ULL));
        CLASSERT(OBD_MD_FLFLAGS == (0x00000800ULL));
        CLASSERT(OBD_MD_FLNLINK == (0x00002000ULL));
        CLASSERT(OBD_MD_FLGENER == (0x00004000ULL));
        CLASSERT(OBD_MD_FLRDEV == (0x00010000ULL));
        CLASSERT(OBD_MD_FLEASIZE == (0x00020000ULL));
        CLASSERT(OBD_MD_LINKNAME == (0x00040000ULL));
        CLASSERT(OBD_MD_FLHANDLE == (0x00080000ULL));
        CLASSERT(OBD_MD_FLCKSUM == (0x00100000ULL));
        CLASSERT(OBD_MD_FLQOS == (0x00200000ULL));
        CLASSERT(OBD_MD_FLCOOKIE == (0x00800000ULL));
        CLASSERT(OBD_MD_FLGROUP == (0x01000000ULL));
        CLASSERT(OBD_MD_FLFID == (0x02000000ULL));
        CLASSERT(OBD_MD_FLEPOCH == (0x04000000ULL));
        CLASSERT(OBD_MD_FLGRANT == (0x08000000ULL));
        CLASSERT(OBD_MD_FLDIREA == (0x10000000ULL));
        CLASSERT(OBD_MD_FLUSRQUOTA == (0x20000000ULL));
        CLASSERT(OBD_MD_FLGRPQUOTA == (0x40000000ULL));
        CLASSERT(OBD_MD_FLMODEASIZE == (0x80000000ULL));
        CLASSERT(OBD_MD_MDS == (0x0000000100000000ULL));
        CLASSERT(OBD_MD_REINT == (0x0000000200000000ULL));
        CLASSERT(OBD_MD_FLXATTR == (0x0000001000000000ULL));
        CLASSERT(OBD_MD_FLXATTRLS == (0x0000002000000000ULL));
        CLASSERT(OBD_MD_FLXATTRRM == (0x0000004000000000ULL));
        CLASSERT(OBD_MD_FLACL == (0x0000008000000000ULL));
        CLASSERT(OBD_FL_INLINEDATA == (0x00000001));
        CLASSERT(OBD_FL_OBDMDEXISTS == (0x00000002));
        CLASSERT(OBD_FL_DELORPHAN == (0x00000004));
        CLASSERT(OBD_FL_NORPC == (0x00000008));
        CLASSERT(OBD_FL_IDONLY == (0x00000010));
        CLASSERT(OBD_FL_RECREATE_OBJS == (0x00000020));
        CLASSERT(OBD_FL_DEBUG_CHECK == (0x00000040));
        CLASSERT(OBD_FL_NO_USRQUOTA == (0x00000100));
        CLASSERT(OBD_FL_NO_GRPQUOTA == (0x00000200));
        CLASSERT(OBD_FL_CREATE_CROW == (0x00000400));
        CLASSERT(OBD_FL_TRUNCLOCK == (0x00000800));
        CLASSERT(OBD_FL_CKSUM_CRC32 == (0x00001000));
        CLASSERT(OBD_FL_CKSUM_ADLER == (0x00002000));
        CLASSERT(OBD_FL_SHRINK_GRANT == (0x00020000));
        CLASSERT(OBD_CKSUM_CRC32 == 1);
        CLASSERT(OBD_CKSUM_ADLER == 2);

        /* Checks for struct lov_mds_md_v1 */
        LASSERTF((int)sizeof(struct lov_mds_md_v1) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct lov_mds_md_v1));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_magic) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_magic));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_pattern) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_pattern));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_object_id) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_object_id));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_object_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_object_id));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_object_gr) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_object_gr));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_object_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_object_gr));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_size) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_size));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_count) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_count));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count));
        LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_objects) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_objects));
        LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects) == 0, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects));

        /* Checks for struct lov_ost_data_v1 */
        LASSERTF((int)sizeof(struct lov_ost_data_v1) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct lov_ost_data_v1));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_object_id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_object_id));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_id));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_object_gr) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_object_gr));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_gr));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_gen) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_gen));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_idx) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_idx));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx));
        CLASSERT(LOV_MAGIC_V1 == 0x0BD10BD0);
        CLASSERT(LOV_MAGIC_JOIN == 0x0BD20BD0);
        LASSERTF(LOV_PATTERN_RAID0 == 1, " found %lld\n",
                 (long long)LOV_PATTERN_RAID0);
        LASSERTF(LOV_PATTERN_RAID1 == 2, " found %lld\n",
                 (long long)LOV_PATTERN_RAID1);

        /* Checks for struct lov_mds_md_v3 */
        LASSERTF((int)sizeof(struct lov_mds_md_v3) == 48, " found %lld\n",
                 (long long)(int)sizeof(struct lov_mds_md_v3));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_magic) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_magic));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pattern) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pattern));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_object_id) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_object_id));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_object_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_object_id));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_object_gr) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_object_gr));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_object_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_object_gr));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_size) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_size));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_count) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_count));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pool_name) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pool_name));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name));
        LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_objects) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_objects));
        LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects) == 0, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects));

        /* Checks for struct lov_ost_data_v1 */
        LASSERTF((int)sizeof(struct lov_ost_data_v1) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct lov_ost_data_v1));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_object_id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_object_id));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_id));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_object_gr) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_object_gr));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_object_gr));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_gen) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_gen));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen));
        LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_idx) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_idx));
        LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx));
        CLASSERT(LOV_MAGIC_V3 == 0x0BD30BD0);
        LASSERTF(LOV_PATTERN_RAID0 == 1, " found %lld\n",
                 (long long)LOV_PATTERN_RAID0);
        LASSERTF(LOV_PATTERN_RAID1 == 2, " found %lld\n",
                 (long long)LOV_PATTERN_RAID1);

        /* Checks for struct lov_mds_md_join */
        LASSERTF((int)sizeof(struct lov_mds_md_join) == 56, " found %lld\n",
                 (long long)(int)sizeof(struct lov_mds_md_join));
        LASSERTF((int)offsetof(struct lov_mds_md_join, lmmj_md) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_join, lmmj_md));
        LASSERTF((int)sizeof(((struct lov_mds_md_join *)0)->lmmj_md) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_join *)0)->lmmj_md));
        LASSERTF((int)offsetof(struct lov_mds_md_join, lmmj_array_id) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_join, lmmj_array_id));
        LASSERTF((int)sizeof(((struct lov_mds_md_join *)0)->lmmj_array_id) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_join *)0)->lmmj_array_id));
        LASSERTF((int)offsetof(struct lov_mds_md_join, lmmj_extent_count) == 52, " found %lld\n",
                 (long long)(int)offsetof(struct lov_mds_md_join, lmmj_extent_count));
        LASSERTF((int)sizeof(((struct lov_mds_md_join *)0)->lmmj_extent_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_mds_md_join *)0)->lmmj_extent_count));

        /* Checks for struct obd_statfs */
        LASSERTF((int)sizeof(struct obd_statfs) == 144, " found %lld\n",
                 (long long)(int)sizeof(struct obd_statfs));
        LASSERTF((int)offsetof(struct obd_statfs, os_type) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_type));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_type) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_type));
        LASSERTF((int)offsetof(struct obd_statfs, os_blocks) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_blocks));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_blocks) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_blocks));
        LASSERTF((int)offsetof(struct obd_statfs, os_bfree) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_bfree));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bfree) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bfree));
        LASSERTF((int)offsetof(struct obd_statfs, os_bavail) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_bavail));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bavail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bavail));
        LASSERTF((int)offsetof(struct obd_statfs, os_ffree) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_ffree));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_ffree) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_ffree));
        LASSERTF((int)offsetof(struct obd_statfs, os_fsid) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_fsid));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_fsid) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_fsid));
        LASSERTF((int)offsetof(struct obd_statfs, os_bsize) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_bsize));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bsize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bsize));
        LASSERTF((int)offsetof(struct obd_statfs, os_namelen) == 92, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_namelen));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_namelen) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_namelen));
        LASSERTF((int)offsetof(struct obd_statfs, os_state) == 104, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_state));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_state) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_state));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare1) == 108, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare1));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare1));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare2) == 112, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare2));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare2));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare3) == 116, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare3));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare3) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare3));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare4) == 120, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare4));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare4) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare4));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare5) == 124, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare5));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare5) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare5));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare6) == 128, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare6));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare6) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare6));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare7) == 132, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare7));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare7) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare7));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare8) == 136, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare8));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare8) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare8));
        LASSERTF((int)offsetof(struct obd_statfs, os_spare9) == 140, " found %lld\n",
                 (long long)(int)offsetof(struct obd_statfs, os_spare9));
        LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare9) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare9));

        /* Checks for struct obd_ioobj */
        LASSERTF((int)sizeof(struct obd_ioobj) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct obd_ioobj));
        LASSERTF((int)offsetof(struct obd_ioobj, ioo_id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_ioobj, ioo_id));
        LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_id));
        LASSERTF((int)offsetof(struct obd_ioobj, ioo_gr) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_ioobj, ioo_gr));
        LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_gr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_gr));
        LASSERTF((int)offsetof(struct obd_ioobj, ioo_type) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_ioobj, ioo_type));
        LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_type));
        LASSERTF((int)offsetof(struct obd_ioobj, ioo_bufcnt) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct obd_ioobj, ioo_bufcnt));
        LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt));

        /* Checks for struct obd_quotactl */
        LASSERTF((int)sizeof(struct obd_quotactl) == 112, " found %lld\n",
                 (long long)(int)sizeof(struct obd_quotactl));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_cmd) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_cmd));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_cmd) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_cmd));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_type) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_type));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_type));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_id) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_id));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_id) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_id));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_stat) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_stat));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_stat) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_stat));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_dqinfo) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_dqinfo));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo) == 24, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo));
        LASSERTF((int)offsetof(struct obd_quotactl, qc_dqblk) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct obd_quotactl, qc_dqblk));
        LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqblk) == 72, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqblk));

        /* Checks for struct obd_dqinfo */
        LASSERTF((int)sizeof(struct obd_dqinfo) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct obd_dqinfo));
        LASSERTF((int)offsetof(struct obd_dqinfo, dqi_bgrace) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqinfo, dqi_bgrace));
        LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace));
        LASSERTF((int)offsetof(struct obd_dqinfo, dqi_igrace) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqinfo, dqi_igrace));
        LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace));
        LASSERTF((int)offsetof(struct obd_dqinfo, dqi_flags) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqinfo, dqi_flags));
        LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_flags));
        LASSERTF((int)offsetof(struct obd_dqinfo, dqi_valid) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqinfo, dqi_valid));
        LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_valid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_valid));

        /* Checks for struct obd_dqblk */
        LASSERTF((int)sizeof(struct obd_dqblk) == 72, " found %lld\n",
                 (long long)(int)sizeof(struct obd_dqblk));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_bhardlimit) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_bhardlimit));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_bsoftlimit) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_bsoftlimit));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_curspace) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_curspace));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curspace) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curspace));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_ihardlimit) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_ihardlimit));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_isoftlimit) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_isoftlimit));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_curinodes) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_curinodes));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_btime) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_btime));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_btime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_btime));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_itime) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_itime));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_itime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_itime));
        LASSERTF((int)offsetof(struct obd_dqblk, dqb_valid) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, dqb_valid));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_valid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_valid));
        LASSERTF((int)offsetof(struct obd_dqblk, padding) == 68, " found %lld\n",
                 (long long)(int)offsetof(struct obd_dqblk, padding));
        LASSERTF((int)sizeof(((struct obd_dqblk *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct obd_dqblk *)0)->padding));
        LASSERTF(Q_QUOTACHECK == 0x800100," found %lld\n",
                 (long long)Q_QUOTACHECK);
        LASSERTF(Q_INITQUOTA == 0x800101," found %lld\n",
                 (long long)Q_INITQUOTA);
        LASSERTF(Q_GETOINFO == 0x800102," found %lld\n",
                 (long long)Q_GETOINFO);
        LASSERTF(Q_GETOQUOTA == 0x800103," found %lld\n",
                 (long long)Q_GETOQUOTA);

        /* Checks for struct niobuf_remote */
        LASSERTF((int)sizeof(struct niobuf_remote) == 16, " found %lld\n",
                 (long long)(int)sizeof(struct niobuf_remote));
        LASSERTF((int)offsetof(struct niobuf_remote, offset) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct niobuf_remote, offset));
        LASSERTF((int)sizeof(((struct niobuf_remote *)0)->offset) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct niobuf_remote *)0)->offset));
        LASSERTF((int)offsetof(struct niobuf_remote, len) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct niobuf_remote, len));
        LASSERTF((int)sizeof(((struct niobuf_remote *)0)->len) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct niobuf_remote *)0)->len));
        LASSERTF((int)offsetof(struct niobuf_remote, flags) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct niobuf_remote, flags));
        LASSERTF((int)sizeof(((struct niobuf_remote *)0)->flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct niobuf_remote *)0)->flags));
        LASSERTF(OBD_BRW_READ == 1, " found %lld\n",
                 (long long)OBD_BRW_READ);
        LASSERTF(OBD_BRW_WRITE == 2, " found %lld\n",
                 (long long)OBD_BRW_WRITE);
        LASSERTF(OBD_BRW_SYNC == 8, " found %lld\n",
                 (long long)OBD_BRW_SYNC);
        LASSERTF(OBD_BRW_FROM_GRANT == 32, " found %lld\n",
                 (long long)OBD_BRW_FROM_GRANT);
        LASSERTF(OBD_BRW_NOQUOTA == 256, " found %lld\n",
                 (long long)OBD_BRW_NOQUOTA);

        /* Checks for struct ost_body */
        LASSERTF((int)sizeof(struct ost_body) == 208, " found %lld\n",
                 (long long)(int)sizeof(struct ost_body));
        LASSERTF((int)offsetof(struct ost_body, oa) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ost_body, oa));
        LASSERTF((int)sizeof(((struct ost_body *)0)->oa) == 208, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_body *)0)->oa));

        /* Checks for struct ll_fid */
        LASSERTF((int)sizeof(struct ll_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(struct ll_fid));
        LASSERTF((int)offsetof(struct ll_fid, id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fid, id));
        LASSERTF((int)sizeof(((struct ll_fid *)0)->id) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fid *)0)->id));
        LASSERTF((int)offsetof(struct ll_fid, generation) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fid, generation));
        LASSERTF((int)sizeof(((struct ll_fid *)0)->generation) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fid *)0)->generation));
        LASSERTF((int)offsetof(struct ll_fid, f_type) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fid, f_type));
        LASSERTF((int)sizeof(((struct ll_fid *)0)->f_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fid *)0)->f_type));

        /* Checks for struct mds_status_req */
        LASSERTF((int)sizeof(struct mds_status_req) == 8, " found %lld\n",
                 (long long)(int)sizeof(struct mds_status_req));
        LASSERTF((int)offsetof(struct mds_status_req, flags) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_status_req, flags));
        LASSERTF((int)sizeof(((struct mds_status_req *)0)->flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_status_req *)0)->flags));
        LASSERTF((int)offsetof(struct mds_status_req, repbuf) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_status_req, repbuf));
        LASSERTF((int)sizeof(((struct mds_status_req *)0)->repbuf) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_status_req *)0)->repbuf));

        /* Checks for struct mds_body */
        LASSERTF((int)sizeof(struct mds_body) == 168, " found %lld\n",
                 (long long)(int)sizeof(struct mds_body));
        LASSERTF((int)offsetof(struct mds_body, fid1) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, fid1));
        LASSERTF((int)sizeof(((struct mds_body *)0)->fid1) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->fid1));
        LASSERTF((int)offsetof(struct mds_body, fid2) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, fid2));
        LASSERTF((int)sizeof(((struct mds_body *)0)->fid2) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->fid2));
        LASSERTF((int)offsetof(struct mds_body, handle) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, handle));
        LASSERTF((int)sizeof(((struct mds_body *)0)->handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->handle));
        LASSERTF((int)offsetof(struct mds_body, size) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, size));
        LASSERTF((int)sizeof(((struct mds_body *)0)->size) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->size));
        LASSERTF((int)offsetof(struct mds_body, blocks) == 80, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, blocks));
        LASSERTF((int)sizeof(((struct mds_body *)0)->blocks) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->blocks));
        LASSERTF((int)offsetof(struct mds_body, io_epoch) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, io_epoch));
        LASSERTF((int)sizeof(((struct mds_body *)0)->io_epoch) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->io_epoch));
        LASSERTF((int)offsetof(struct mds_body, ino) == 96, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, ino));
        LASSERTF((int)sizeof(((struct mds_body *)0)->ino) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->ino));
        LASSERTF((int)offsetof(struct mds_body, valid) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, valid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->valid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->valid));
        LASSERTF((int)offsetof(struct mds_body, fsuid) == 104, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, fsuid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->fsuid));
        LASSERTF((int)offsetof(struct mds_body, fsgid) == 108, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, fsgid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->fsgid));
        LASSERTF((int)offsetof(struct mds_body, capability) == 112, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, capability));
        LASSERTF((int)sizeof(((struct mds_body *)0)->capability) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->capability));
        LASSERTF((int)offsetof(struct mds_body, mode) == 116, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, mode));
        LASSERTF((int)sizeof(((struct mds_body *)0)->mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->mode));
        LASSERTF((int)offsetof(struct mds_body, uid) == 120, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, uid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->uid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->uid));
        LASSERTF((int)offsetof(struct mds_body, gid) == 124, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, gid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->gid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->gid));
        LASSERTF((int)offsetof(struct mds_body, mtime) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, mtime));
        LASSERTF((int)sizeof(((struct mds_body *)0)->mtime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->mtime));
        LASSERTF((int)offsetof(struct mds_body, ctime) == 72, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, ctime));
        LASSERTF((int)sizeof(((struct mds_body *)0)->ctime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->ctime));
        LASSERTF((int)offsetof(struct mds_body, atime) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, atime));
        LASSERTF((int)sizeof(((struct mds_body *)0)->atime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->atime));
        LASSERTF((int)offsetof(struct mds_body, flags) == 128, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, flags));
        LASSERTF((int)sizeof(((struct mds_body *)0)->flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->flags));
        LASSERTF((int)offsetof(struct mds_body, rdev) == 132, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, rdev));
        LASSERTF((int)sizeof(((struct mds_body *)0)->rdev) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->rdev));
        LASSERTF((int)offsetof(struct mds_body, nlink) == 136, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, nlink));
        LASSERTF((int)sizeof(((struct mds_body *)0)->nlink) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->nlink));
        LASSERTF((int)offsetof(struct mds_body, generation) == 140, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, generation));
        LASSERTF((int)sizeof(((struct mds_body *)0)->generation) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->generation));
        LASSERTF((int)offsetof(struct mds_body, suppgid) == 144, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, suppgid));
        LASSERTF((int)sizeof(((struct mds_body *)0)->suppgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->suppgid));
        LASSERTF((int)offsetof(struct mds_body, eadatasize) == 148, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, eadatasize));
        LASSERTF((int)sizeof(((struct mds_body *)0)->eadatasize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->eadatasize));
        LASSERTF((int)offsetof(struct mds_body, aclsize) == 152, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, aclsize));
        LASSERTF((int)sizeof(((struct mds_body *)0)->aclsize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->aclsize));
        LASSERTF((int)offsetof(struct mds_body, max_mdsize) == 156, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, max_mdsize));
        LASSERTF((int)sizeof(((struct mds_body *)0)->max_mdsize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->max_mdsize));
        LASSERTF((int)offsetof(struct mds_body, max_cookiesize) == 160, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, max_cookiesize));
        LASSERTF((int)sizeof(((struct mds_body *)0)->max_cookiesize) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->max_cookiesize));
        LASSERTF((int)offsetof(struct mds_body, padding_4) == 164, " found %lld\n",
                 (long long)(int)offsetof(struct mds_body, padding_4));
        LASSERTF((int)sizeof(((struct mds_body *)0)->padding_4) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_body *)0)->padding_4));
        LASSERTF(FMODE_READ == 1, " found %lld\n",
                 (long long)FMODE_READ);
        LASSERTF(FMODE_WRITE == 2, " found %lld\n",
                 (long long)FMODE_WRITE);
        LASSERTF(MDS_FMODE_EXEC == 4, " found %lld\n",
                 (long long)MDS_FMODE_EXEC);
        CLASSERT(MDS_OPEN_CREAT == 00000100);
        CLASSERT(MDS_OPEN_EXCL == 00000200);
        CLASSERT(MDS_OPEN_TRUNC == 00001000);
        CLASSERT(MDS_OPEN_APPEND == 00002000);
        CLASSERT(MDS_OPEN_SYNC == 00010000);
        CLASSERT(MDS_OPEN_DIRECTORY == 00200000);
        CLASSERT(MDS_OPEN_DELAY_CREATE == 0100000000);
        CLASSERT(MDS_OPEN_OWNEROVERRIDE == 0200000000);
        CLASSERT(MDS_OPEN_JOIN_FILE == 0400000000);
        CLASSERT(MDS_OPEN_HAS_EA == 010000000000);
        CLASSERT(MDS_OPEN_HAS_OBJS == 020000000000);
        CLASSERT(MDS_SYNC_FL == 0x00000008);
        CLASSERT(MDS_IMMUTABLE_FL == 0x00000010);
        CLASSERT(MDS_APPEND_FL == 0x00000020);
        CLASSERT(MDS_NOATIME_FL == 0x00000080);
        CLASSERT(MDS_DIRSYNC_FL == 0x00010000);
        CLASSERT(MDS_BFLAG_EXT_FLAGS == 0x80000000);
        CLASSERT(MDS_INODELOCK_LOOKUP == 0x000001);
        CLASSERT(MDS_INODELOCK_UPDATE == 0x000002);
        CLASSERT(MDS_INODELOCK_OPEN == 0x000004);

        /* Checks for struct mds_rec_setattr */
        LASSERTF((int)sizeof(struct mds_rec_setattr) == 96, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_setattr));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_opcode) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_opcode));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_opcode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_opcode));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_fsuid) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_fsuid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_fsuid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_fsgid) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_fsgid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_fsgid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_cap) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_cap));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_cap) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_cap));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_suppgid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_suppgid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_suppgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_suppgid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_mode) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_mode));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_mode));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_fid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_fid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_fid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_valid) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_valid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_valid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_valid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_size) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_size));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_size) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_size));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_mtime) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_mtime));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_mtime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_mtime));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_atime) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_atime));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_atime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_atime));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_ctime) == 72, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_ctime));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_ctime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_ctime));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_uid) == 80, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_uid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_uid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_uid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_gid) == 84, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_gid));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_gid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_gid));
        LASSERTF((int)offsetof(struct mds_rec_setattr, sa_attr_flags) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_setattr, sa_attr_flags));
        LASSERTF((int)sizeof(((struct mds_rec_setattr *)0)->sa_attr_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_setattr *)0)->sa_attr_flags));
        CLASSERT(MDS_ATTR_MODE == 0x1ULL);
        CLASSERT(MDS_ATTR_UID == 0x2ULL);
        CLASSERT(MDS_ATTR_GID == 0x4ULL);
        CLASSERT(MDS_ATTR_SIZE == 0x8ULL);
        CLASSERT(MDS_ATTR_ATIME == 0x10ULL);
        CLASSERT(MDS_ATTR_MTIME == 0x20ULL);
        CLASSERT(MDS_ATTR_CTIME == 0x40ULL);
        CLASSERT(MDS_ATTR_ATIME_SET == 0x80ULL);
        CLASSERT(MDS_ATTR_MTIME_SET == 0x100ULL);
        CLASSERT(MDS_ATTR_FORCE == 0x200ULL);
        CLASSERT(MDS_ATTR_ATTR_FLAG == 0x400ULL);
        CLASSERT(MDS_ATTR_KILL_SUID == 0x800ULL);
        CLASSERT(MDS_ATTR_KILL_SGID == 0x1000ULL);
        CLASSERT(MDS_ATTR_CTIME_SET == 0x2000ULL);
        CLASSERT(MDS_ATTR_FROM_OPEN == 0x4000ULL);

        /* Checks for struct mds_rec_create */
        LASSERTF((int)sizeof(struct mds_rec_create) == 96, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_create));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_opcode) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_opcode));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_opcode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_opcode));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_fsuid) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_fsuid));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_fsuid));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_fsgid) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_fsgid));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_fsgid));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_cap) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_cap));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_cap) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_cap));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_flags) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_flags));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_flags));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_mode) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_mode));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_mode));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_fid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_fid));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_fid));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_replayfid) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_replayfid));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_replayfid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_replayfid));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_time) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_time));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_time) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_time));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_rdev) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_rdev));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_rdev) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_rdev));
        LASSERTF((int)offsetof(struct mds_rec_create, cr_suppgid) == 72, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_create, cr_suppgid));
        LASSERTF((int)sizeof(((struct mds_rec_create *)0)->cr_suppgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_create *)0)->cr_suppgid));

        /* Checks for struct mds_rec_link */
        LASSERTF((int)sizeof(struct mds_rec_link) == 80, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_link));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_opcode) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_opcode));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_opcode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_opcode));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_fsuid) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_fsuid));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_fsuid));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_fsgid) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_fsgid));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_fsgid));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_cap) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_cap));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_cap) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_cap));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_suppgid1) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_suppgid1));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_suppgid1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_suppgid1));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_suppgid2) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_suppgid2));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_suppgid2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_suppgid2));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_fid1) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_fid1));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_fid1) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_fid1));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_fid2) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_fid2));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_fid2) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_fid2));
        LASSERTF((int)offsetof(struct mds_rec_link, lk_time) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_link, lk_time));
        LASSERTF((int)sizeof(((struct mds_rec_link *)0)->lk_time) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_link *)0)->lk_time));

        /* Checks for struct mds_rec_unlink */
        LASSERTF((int)sizeof(struct mds_rec_unlink) == 80, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_unlink));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_opcode) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_opcode));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_opcode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_opcode));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_fsuid) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_fsuid));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_fsuid));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_fsgid) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_fsgid));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_fsgid));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_cap) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_cap));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_cap) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_cap));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_suppgid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_suppgid));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_suppgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_suppgid));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_mode) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_mode));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_mode));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_fid1) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_fid1));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_fid1) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_fid1));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_fid2) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_fid2));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_fid2) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_fid2));
        LASSERTF((int)offsetof(struct mds_rec_unlink, ul_time) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_unlink, ul_time));
        LASSERTF((int)sizeof(((struct mds_rec_unlink *)0)->ul_time) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_unlink *)0)->ul_time));

        /* Checks for struct mds_rec_rename */
        LASSERTF((int)sizeof(struct mds_rec_rename) == 80, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_rename));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_opcode) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_opcode));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_opcode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_opcode));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_fsuid) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_fsuid));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_fsuid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_fsuid));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_fsgid) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_fsgid));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_fsgid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_fsgid));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_cap) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_cap));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_cap) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_cap));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_suppgid1) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_suppgid1));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_suppgid1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_suppgid1));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_suppgid2) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_suppgid2));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_suppgid2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_suppgid2));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_fid1) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_fid1));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_fid1) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_fid1));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_fid2) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_fid2));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_fid2) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_fid2));
        LASSERTF((int)offsetof(struct mds_rec_rename, rn_time) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_rename, rn_time));
        LASSERTF((int)sizeof(((struct mds_rec_rename *)0)->rn_time) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_rename *)0)->rn_time));

        /* Checks for struct mds_rec_join */
        LASSERTF((int)sizeof(struct mds_rec_join) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct mds_rec_join));
        LASSERTF((int)offsetof(struct mds_rec_join, jr_fid) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_join, jr_fid));
        LASSERTF((int)sizeof(((struct mds_rec_join *)0)->jr_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_join *)0)->jr_fid));
        LASSERTF((int)offsetof(struct mds_rec_join, jr_headsize) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_rec_join, jr_headsize));
        LASSERTF((int)sizeof(((struct mds_rec_join *)0)->jr_headsize) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_rec_join *)0)->jr_headsize));

        /* Checks for struct lov_desc */
        LASSERTF((int)sizeof(struct lov_desc) == 88, " found %lld\n",
                 (long long)(int)sizeof(struct lov_desc));
        LASSERTF((int)offsetof(struct lov_desc, ld_tgt_count) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_tgt_count));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_tgt_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_tgt_count));
        LASSERTF((int)offsetof(struct lov_desc, ld_active_tgt_count) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_active_tgt_count));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count));
        LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_count) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_count));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count));
        LASSERTF((int)offsetof(struct lov_desc, ld_pattern) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_pattern));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_pattern) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_pattern));
        LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_size) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_size));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size));
        LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_offset) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_offset));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset));
        LASSERTF((int)offsetof(struct lov_desc, ld_qos_maxage) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_qos_maxage));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_qos_maxage) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_qos_maxage));
        LASSERTF((int)offsetof(struct lov_desc, ld_padding_1) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_padding_1));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_1));
        LASSERTF((int)offsetof(struct lov_desc, ld_padding_2) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_padding_2));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_2));
        LASSERTF((int)offsetof(struct lov_desc, ld_uuid) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct lov_desc, ld_uuid));
        LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_uuid) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct lov_desc *)0)->ld_uuid));

        /* Checks for struct ldlm_res_id */
        LASSERTF((int)sizeof(struct ldlm_res_id) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_res_id));
        LASSERTF((int)offsetof(struct ldlm_res_id, name[4]) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_res_id, name[4]));
        LASSERTF((int)sizeof(((struct ldlm_res_id *)0)->name[4]) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_res_id *)0)->name[4]));

        /* Checks for struct ldlm_extent */
        LASSERTF((int)sizeof(struct ldlm_extent) == 24, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_extent));
        LASSERTF((int)offsetof(struct ldlm_extent, start) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_extent, start));
        LASSERTF((int)sizeof(((struct ldlm_extent *)0)->start) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_extent *)0)->start));
        LASSERTF((int)offsetof(struct ldlm_extent, end) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_extent, end));
        LASSERTF((int)sizeof(((struct ldlm_extent *)0)->end) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_extent *)0)->end));
        LASSERTF((int)offsetof(struct ldlm_extent, gid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_extent, gid));
        LASSERTF((int)sizeof(((struct ldlm_extent *)0)->gid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_extent *)0)->gid));

        /* Checks for struct ldlm_flock */
        LASSERTF((int)sizeof(struct ldlm_flock) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_flock));
        LASSERTF((int)offsetof(struct ldlm_flock, start) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_flock, start));
        LASSERTF((int)sizeof(((struct ldlm_flock *)0)->start) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_flock *)0)->start));
        LASSERTF((int)offsetof(struct ldlm_flock, end) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_flock, end));
        LASSERTF((int)sizeof(((struct ldlm_flock *)0)->end) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_flock *)0)->end));
        LASSERTF((int)offsetof(struct ldlm_flock, blocking_pid) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_flock, blocking_pid));
        LASSERTF((int)sizeof(((struct ldlm_flock *)0)->blocking_pid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_flock *)0)->blocking_pid));
        LASSERTF((int)offsetof(struct ldlm_flock, pid) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_flock, pid));
        LASSERTF((int)sizeof(((struct ldlm_flock *)0)->pid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_flock *)0)->pid));

        /* Checks for struct ldlm_inodebits */
        LASSERTF((int)sizeof(struct ldlm_inodebits) == 8, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_inodebits));
        LASSERTF((int)offsetof(struct ldlm_inodebits, bits) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_inodebits, bits));
        LASSERTF((int)sizeof(((struct ldlm_inodebits *)0)->bits) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_inodebits *)0)->bits));

        /* Checks for struct ldlm_intent */
        LASSERTF((int)sizeof(struct ldlm_intent) == 8, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_intent));
        LASSERTF((int)offsetof(struct ldlm_intent, opc) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_intent, opc));
        LASSERTF((int)sizeof(((struct ldlm_intent *)0)->opc) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_intent *)0)->opc));

        /* Checks for struct ldlm_resource_desc */
        LASSERTF((int)sizeof(struct ldlm_resource_desc) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_resource_desc));
        LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_type) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_resource_desc, lr_type));
        LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_type));
        LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_padding) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_resource_desc, lr_padding));
        LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_padding));
        LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_name) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_resource_desc, lr_name));
        LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_name) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_name));

        /* Checks for struct ldlm_lock_desc */
        LASSERTF((int)sizeof(struct ldlm_lock_desc) == 80, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_lock_desc));
        LASSERTF((int)offsetof(struct ldlm_lock_desc, l_resource) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_lock_desc, l_resource));
        LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_resource) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_resource));
        LASSERTF((int)offsetof(struct ldlm_lock_desc, l_req_mode) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_lock_desc, l_req_mode));
        LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode));
        LASSERTF((int)offsetof(struct ldlm_lock_desc, l_granted_mode) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_lock_desc, l_granted_mode));
        LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode));
        LASSERTF((int)offsetof(struct ldlm_lock_desc, l_policy_data) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_lock_desc, l_policy_data));
        LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data));

        /* Checks for struct ldlm_request */
        LASSERTF((int)sizeof(struct ldlm_request) == 104, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_request));
        LASSERTF((int)offsetof(struct ldlm_request, lock_flags) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_request, lock_flags));
        LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_flags));
        LASSERTF((int)offsetof(struct ldlm_request, lock_count) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_request, lock_count));
        LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_count));
        LASSERTF((int)offsetof(struct ldlm_request, lock_desc) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_request, lock_desc));
        LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_desc) == 80, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_desc));
        LASSERTF((int)offsetof(struct ldlm_request, lock_handle) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_request, lock_handle));
        LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_handle) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_handle));

        /* Checks for struct ldlm_reply */
        LASSERTF((int)sizeof(struct ldlm_reply) == 112, " found %lld\n",
                 (long long)(int)sizeof(struct ldlm_reply));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_flags) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_flags));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_flags));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_padding) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_padding));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_padding));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_desc) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_desc));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_desc) == 80, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_desc));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_handle) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_handle));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_handle) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_handle));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res1) == 96, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res1));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1));
        LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res2) == 104, " found %lld\n",
                 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res2));
        LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2));

        /* Checks for struct ost_lvb */
        LASSERTF((int)sizeof(struct ost_lvb) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct ost_lvb));
        LASSERTF((int)offsetof(struct ost_lvb, lvb_size) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ost_lvb, lvb_size));
        LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_size) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_size));
        LASSERTF((int)offsetof(struct ost_lvb, lvb_mtime) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ost_lvb, lvb_mtime));
        LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_mtime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_mtime));
        LASSERTF((int)offsetof(struct ost_lvb, lvb_atime) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct ost_lvb, lvb_atime));
        LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_atime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_atime));
        LASSERTF((int)offsetof(struct ost_lvb, lvb_ctime) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct ost_lvb, lvb_ctime));
        LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_ctime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_ctime));
        LASSERTF((int)offsetof(struct ost_lvb, lvb_blocks) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct ost_lvb, lvb_blocks));
        LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_blocks) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_blocks));

        /* Checks for struct cfg_marker */
        LASSERTF((int)sizeof(struct cfg_marker) == 160, " found %lld\n",
                 (long long)(int)sizeof(struct cfg_marker));
        LASSERTF((int)offsetof(struct cfg_marker, cm_step) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_step));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_step) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_step));
        LASSERTF((int)offsetof(struct cfg_marker, cm_flags) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_flags));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_flags));
        LASSERTF((int)offsetof(struct cfg_marker, cm_vers) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_vers));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_vers) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_vers));
        LASSERTF((int)offsetof(struct cfg_marker, cm_createtime) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_createtime));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_createtime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_createtime));
        LASSERTF((int)offsetof(struct cfg_marker, cm_canceltime) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_canceltime));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_canceltime) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_canceltime));
        LASSERTF((int)offsetof(struct cfg_marker, cm_tgtname) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_tgtname));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_tgtname) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_tgtname));
        LASSERTF((int)offsetof(struct cfg_marker, cm_comment) == 96, " found %lld\n",
                 (long long)(int)offsetof(struct cfg_marker, cm_comment));
        LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_comment) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_comment));

        /* Checks for struct llog_logid */
        LASSERTF((int)sizeof(struct llog_logid) == 20, " found %lld\n",
                 (long long)(int)sizeof(struct llog_logid));
        LASSERTF((int)offsetof(struct llog_logid, lgl_oid) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid, lgl_oid));
        LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_oid));
        LASSERTF((int)offsetof(struct llog_logid, lgl_ogr) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid, lgl_ogr));
        LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_ogr) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_ogr));
        LASSERTF((int)offsetof(struct llog_logid, lgl_ogen) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid, lgl_ogen));
        LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_ogen) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_ogen));
        CLASSERT(OST_SZ_REC == 274730752);
        CLASSERT(OST_RAID1_REC == 274731008);
        CLASSERT(MDS_UNLINK_REC == 274801668);
        CLASSERT(MDS_SETATTR_REC == 274801665);
        CLASSERT(OBD_CFG_REC == 274857984);
        CLASSERT(PTL_CFG_REC == 274923520);
        CLASSERT(LLOG_GEN_REC == 274989056);
        CLASSERT(LLOG_JOIN_REC == 275054592);
        CLASSERT(LLOG_HDR_MAGIC == 275010873);
        CLASSERT(LLOG_LOGID_MAGIC == 275010875);

        /* Checks for struct llog_catid */
        LASSERTF((int)sizeof(struct llog_catid) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct llog_catid));
        LASSERTF((int)offsetof(struct llog_catid, lci_logid) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_catid, lci_logid));
        LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_logid) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_catid *)0)->lci_logid));
        LASSERTF((int)offsetof(struct llog_catid, lci_padding1) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct llog_catid, lci_padding1));
        LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding1));
        LASSERTF((int)offsetof(struct llog_catid, lci_padding2) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_catid, lci_padding2));
        LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding2));
        LASSERTF((int)offsetof(struct llog_catid, lci_padding3) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_catid, lci_padding3));
        LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding3) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding3));

        /* Checks for struct llog_rec_hdr */
        LASSERTF((int)sizeof(struct llog_rec_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(struct llog_rec_hdr));
        LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_len) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_hdr, lrh_len));
        LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_len) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_len));
        LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_index) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_hdr, lrh_index));
        LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_index));
        LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_type) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_hdr, lrh_type));
        LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_type));
        LASSERTF((int)offsetof(struct llog_rec_hdr, padding) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_hdr, padding));
        LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->padding));

        /* Checks for struct llog_rec_tail */
        LASSERTF((int)sizeof(struct llog_rec_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(struct llog_rec_tail));
        LASSERTF((int)offsetof(struct llog_rec_tail, lrt_len) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_tail, lrt_len));
        LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_len) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_len));
        LASSERTF((int)offsetof(struct llog_rec_tail, lrt_index) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct llog_rec_tail, lrt_index));
        LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_index));

        /* Checks for struct llog_logid_rec */
        LASSERTF((int)sizeof(struct llog_logid_rec) == 64, " found %lld\n",
                 (long long)(int)sizeof(struct llog_logid_rec));
        LASSERTF((int)offsetof(struct llog_logid_rec, lid_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, lid_hdr));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_hdr));
        LASSERTF((int)offsetof(struct llog_logid_rec, lid_id) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, lid_id));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_id) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_id));
        LASSERTF((int)offsetof(struct llog_logid_rec, padding1) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, padding1));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->padding1) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->padding1));
        LASSERTF((int)offsetof(struct llog_logid_rec, padding2) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, padding2));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->padding2) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->padding2));
        LASSERTF((int)offsetof(struct llog_logid_rec, padding3) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, padding3));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->padding3) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->padding3));
        LASSERTF((int)offsetof(struct llog_logid_rec, padding4) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, padding4));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->padding4) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->padding4));
        LASSERTF((int)offsetof(struct llog_logid_rec, padding5) == 52, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, padding5));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->padding5) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->padding5));
        LASSERTF((int)offsetof(struct llog_logid_rec, lid_tail) == 56, " found %lld\n",
                 (long long)(int)offsetof(struct llog_logid_rec, lid_tail));
        LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_tail));

        /* Checks for struct llog_create_rec */
        LASSERTF((int)sizeof(struct llog_create_rec) == 56, " found %lld\n",
                 (long long)(int)sizeof(struct llog_create_rec));
        LASSERTF((int)offsetof(struct llog_create_rec, lcr_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_create_rec, lcr_hdr));
        LASSERTF((int)sizeof(((struct llog_create_rec *)0)->lcr_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_create_rec *)0)->lcr_hdr));
        LASSERTF((int)offsetof(struct llog_create_rec, lcr_fid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_create_rec, lcr_fid));
        LASSERTF((int)sizeof(((struct llog_create_rec *)0)->lcr_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_create_rec *)0)->lcr_fid));
        LASSERTF((int)offsetof(struct llog_create_rec, lcr_oid) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_create_rec, lcr_oid));
        LASSERTF((int)sizeof(((struct llog_create_rec *)0)->lcr_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_create_rec *)0)->lcr_oid));
        LASSERTF((int)offsetof(struct llog_create_rec, lcr_ogr) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_create_rec, lcr_ogr));
        LASSERTF((int)sizeof(((struct llog_create_rec *)0)->lcr_ogr) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_create_rec *)0)->lcr_ogr));
        LASSERTF((int)offsetof(struct llog_create_rec, padding) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct llog_create_rec, padding));
        LASSERTF((int)sizeof(((struct llog_create_rec *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_create_rec *)0)->padding));

        /* Checks for struct llog_orphan_rec */
        LASSERTF((int)sizeof(struct llog_orphan_rec) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct llog_orphan_rec));
        LASSERTF((int)offsetof(struct llog_orphan_rec, lor_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_orphan_rec, lor_hdr));
        LASSERTF((int)sizeof(((struct llog_orphan_rec *)0)->lor_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_orphan_rec *)0)->lor_hdr));
        LASSERTF((int)offsetof(struct llog_orphan_rec, lor_oid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_orphan_rec, lor_oid));
        LASSERTF((int)sizeof(((struct llog_orphan_rec *)0)->lor_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_orphan_rec *)0)->lor_oid));
        LASSERTF((int)offsetof(struct llog_orphan_rec, lor_ogen) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_orphan_rec, lor_ogen));
        LASSERTF((int)sizeof(((struct llog_orphan_rec *)0)->lor_ogen) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_orphan_rec *)0)->lor_ogen));
        LASSERTF((int)offsetof(struct llog_orphan_rec, padding) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_orphan_rec, padding));
        LASSERTF((int)sizeof(((struct llog_orphan_rec *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_orphan_rec *)0)->padding));
        LASSERTF((int)offsetof(struct llog_orphan_rec, lor_tail) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_orphan_rec, lor_tail));
        LASSERTF((int)sizeof(((struct llog_orphan_rec *)0)->lor_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_orphan_rec *)0)->lor_tail));

        /* Checks for struct llog_unlink_rec */
        LASSERTF((int)sizeof(struct llog_unlink_rec) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct llog_unlink_rec));
        LASSERTF((int)offsetof(struct llog_unlink_rec, lur_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_unlink_rec, lur_hdr));
        LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr));
        LASSERTF((int)offsetof(struct llog_unlink_rec, lur_oid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_unlink_rec, lur_oid));
        LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_oid));
        LASSERTF((int)offsetof(struct llog_unlink_rec, lur_ogr) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_unlink_rec, lur_ogr));
        LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_ogr) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_ogr));
        LASSERTF((int)offsetof(struct llog_unlink_rec, lur_count) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_unlink_rec, lur_count));
        LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_count));
        LASSERTF((int)offsetof(struct llog_unlink_rec, lur_tail) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_unlink_rec, lur_tail));
        LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_tail));

        /* Checks for struct llog_setattr_rec */
        LASSERTF((int)sizeof(struct llog_setattr_rec) == 48, " found %lld\n",
                 (long long)(int)sizeof(struct llog_setattr_rec));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_hdr));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_hdr));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_oid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_oid));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_oid));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_ogr) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_ogr));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_ogr) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_ogr));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_uid) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_uid));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_uid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_uid));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_gid) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_gid));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_gid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_gid));
        LASSERTF((int)offsetof(struct llog_setattr_rec, padding) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, padding));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->padding));
        LASSERTF((int)offsetof(struct llog_setattr_rec, lsr_tail) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr_rec, lsr_tail));
        LASSERTF((int)sizeof(((struct llog_setattr_rec *)0)->lsr_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr_rec *)0)->lsr_tail));

        /* Checks for struct llog_setattr64_rec */
        LASSERTF((int)sizeof(struct llog_setattr64_rec) == 56, " found %lld\n",
                 (long long)(int)sizeof(struct llog_setattr64_rec));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_hdr));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_oid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_oid));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oid) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oid));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_ogr) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_ogr));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_ogr) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_ogr));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, padding) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, padding));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->padding));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid_h) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid_h));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid_h) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid_h));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h));
        LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_tail) == 48, " found %lld\n",
                 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_tail));
        LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_tail));

        /* Checks for struct llog_size_change_rec */
        LASSERTF((int)sizeof(struct llog_size_change_rec) == 48, " found %lld\n",
                 (long long)(int)sizeof(struct llog_size_change_rec));
        LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_size_change_rec, lsc_hdr));
        LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr));
        LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_fid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_size_change_rec, lsc_fid));
        LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid));
        LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_io_epoch) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_size_change_rec, lsc_io_epoch));
        LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_io_epoch) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_io_epoch));
        LASSERTF((int)offsetof(struct llog_size_change_rec, padding) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llog_size_change_rec, padding));
        LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->padding));
        LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_tail) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_size_change_rec, lsc_tail));
        LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail));

        /* Checks for struct llog_gen */
        LASSERTF((int)sizeof(struct llog_gen) == 16, " found %lld\n",
                 (long long)(int)sizeof(struct llog_gen));
        LASSERTF((int)offsetof(struct llog_gen, mnt_cnt) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_gen, mnt_cnt));
        LASSERTF((int)sizeof(((struct llog_gen *)0)->mnt_cnt) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_gen *)0)->mnt_cnt));
        LASSERTF((int)offsetof(struct llog_gen, conn_cnt) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct llog_gen, conn_cnt));
        LASSERTF((int)sizeof(((struct llog_gen *)0)->conn_cnt) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_gen *)0)->conn_cnt));

        /* Checks for struct llog_gen_rec */
        LASSERTF((int)sizeof(struct llog_gen_rec) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct llog_gen_rec));
        LASSERTF((int)offsetof(struct llog_gen_rec, lgr_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_gen_rec, lgr_hdr));
        LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr));
        LASSERTF((int)offsetof(struct llog_gen_rec, lgr_gen) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_gen_rec, lgr_gen));
        LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_gen) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_gen));
        LASSERTF((int)offsetof(struct llog_gen_rec, lgr_tail) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_gen_rec, lgr_tail));
        LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_tail));

        /* Checks for struct llog_log_hdr */
        LASSERTF((int)sizeof(struct llog_log_hdr) == 8192, " found %lld\n",
                 (long long)(int)sizeof(struct llog_log_hdr));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_hdr));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_hdr));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_timestamp) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_timestamp));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_count) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_count));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_count));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_bitmap_offset) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_bitmap_offset));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_size) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_size));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_size) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_size));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_flags) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_flags));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_flags));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_cat_idx) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_cat_idx));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_tgtuuid) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_tgtuuid));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_reserved) == 84, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_reserved));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_reserved) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_reserved));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_bitmap) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_bitmap));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap) == 8096, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap));
        LASSERTF((int)offsetof(struct llog_log_hdr, llh_tail) == 8184, " found %lld\n",
                 (long long)(int)offsetof(struct llog_log_hdr, llh_tail));
        LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_tail));

        /* Checks for struct llog_cookie */
        LASSERTF((int)sizeof(struct llog_cookie) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct llog_cookie));
        LASSERTF((int)offsetof(struct llog_cookie, lgc_lgl) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_cookie, lgc_lgl));
        LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_lgl) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_lgl));
        LASSERTF((int)offsetof(struct llog_cookie, lgc_subsys) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct llog_cookie, lgc_subsys));
        LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_subsys) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_subsys));
        LASSERTF((int)offsetof(struct llog_cookie, lgc_index) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llog_cookie, lgc_index));
        LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_index));
        LASSERTF((int)offsetof(struct llog_cookie, lgc_padding) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llog_cookie, lgc_padding));
        LASSERTF((int)sizeof(((struct llog_cookie *)0)->lgc_padding) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_cookie *)0)->lgc_padding));

        /* Checks for struct llogd_body */
        LASSERTF((int)sizeof(struct llogd_body) == 48, " found %lld\n",
                 (long long)(int)sizeof(struct llogd_body));
        LASSERTF((int)offsetof(struct llogd_body, lgd_logid) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_logid));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_logid) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_logid));
        LASSERTF((int)offsetof(struct llogd_body, lgd_ctxt_idx) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_ctxt_idx));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx));
        LASSERTF((int)offsetof(struct llogd_body, lgd_llh_flags) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_llh_flags));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_llh_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_llh_flags));
        LASSERTF((int)offsetof(struct llogd_body, lgd_index) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_index));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_index));
        LASSERTF((int)offsetof(struct llogd_body, lgd_saved_index) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_saved_index));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_saved_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_saved_index));
        LASSERTF((int)offsetof(struct llogd_body, lgd_len) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_len));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_len) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_len));
        LASSERTF((int)offsetof(struct llogd_body, lgd_cur_offset) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_body, lgd_cur_offset));
        LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_cur_offset) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_cur_offset));
        CLASSERT(LLOG_ORIGIN_HANDLE_CREATE == 501);
        CLASSERT(LLOG_ORIGIN_HANDLE_NEXT_BLOCK == 502);
        CLASSERT(LLOG_ORIGIN_HANDLE_READ_HEADER == 503);
        CLASSERT(LLOG_ORIGIN_HANDLE_WRITE_REC == 504);
        CLASSERT(LLOG_ORIGIN_HANDLE_CLOSE == 505);
        CLASSERT(LLOG_ORIGIN_CONNECT == 506);
        CLASSERT(LLOG_CATINFO == 507);
        CLASSERT(LLOG_ORIGIN_HANDLE_PREV_BLOCK == 508);
        CLASSERT(LLOG_ORIGIN_HANDLE_DESTROY == 509);

        /* Checks for struct llogd_conn_body */
        LASSERTF((int)sizeof(struct llogd_conn_body) == 40, " found %lld\n",
                 (long long)(int)sizeof(struct llogd_conn_body));
        LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_gen) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_conn_body, lgdc_gen));
        LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen));
        LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_logid) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_conn_body, lgdc_logid));
        LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid) == 20, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid));
        LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx) == 36, " found %lld\n",
                 (long long)(int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx));
        LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx));

        /* Checks for struct llog_array_rec */
        LASSERTF((int)sizeof(struct llog_array_rec) == 72, " found %lld\n",
                 (long long)(int)sizeof(struct llog_array_rec));
        LASSERTF((int)offsetof(struct llog_array_rec, lmr_hdr) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct llog_array_rec, lmr_hdr));
        LASSERTF((int)sizeof(((struct llog_array_rec *)0)->lmr_hdr) == 16, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_array_rec *)0)->lmr_hdr));
        LASSERTF((int)offsetof(struct llog_array_rec, lmr_med) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct llog_array_rec, lmr_med));
        LASSERTF((int)sizeof(((struct llog_array_rec *)0)->lmr_med) == 48, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_array_rec *)0)->lmr_med));
        LASSERTF((int)offsetof(struct llog_array_rec, lmr_tail) == 64, " found %lld\n",
                 (long long)(int)offsetof(struct llog_array_rec, lmr_tail));
        LASSERTF((int)sizeof(((struct llog_array_rec *)0)->lmr_tail) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct llog_array_rec *)0)->lmr_tail));

        /* Checks for struct mds_extent_desc */
        LASSERTF((int)sizeof(struct mds_extent_desc) == 48, " found %lld\n",
                 (long long)(int)sizeof(struct mds_extent_desc));
        LASSERTF((int)offsetof(struct mds_extent_desc, med_start) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mds_extent_desc, med_start));
        LASSERTF((int)sizeof(((struct mds_extent_desc *)0)->med_start) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_extent_desc *)0)->med_start));
        LASSERTF((int)offsetof(struct mds_extent_desc, med_len) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mds_extent_desc, med_len));
        LASSERTF((int)sizeof(((struct mds_extent_desc *)0)->med_len) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_extent_desc *)0)->med_len));
        LASSERTF((int)offsetof(struct mds_extent_desc, med_lmm) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mds_extent_desc, med_lmm));
        LASSERTF((int)sizeof(((struct mds_extent_desc *)0)->med_lmm) == 32, " found %lld\n",
                 (long long)(int)sizeof(((struct mds_extent_desc *)0)->med_lmm));

        /* Checks for struct qunit_data */
        LASSERTF((int)sizeof(struct qunit_data) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct qunit_data));
        LASSERTF((int)offsetof(struct qunit_data, qd_id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data, qd_id));
        LASSERTF((int)sizeof(((struct qunit_data *)0)->qd_id) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data *)0)->qd_id));
        LASSERTF((int)offsetof(struct qunit_data, qd_flags) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data, qd_flags));
        LASSERTF((int)sizeof(((struct qunit_data *)0)->qd_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data *)0)->qd_flags));
        LASSERTF((int)offsetof(struct qunit_data, qd_count) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data, qd_count));
        LASSERTF((int)sizeof(((struct qunit_data *)0)->qd_count) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data *)0)->qd_count));
        LASSERTF((int)offsetof(struct qunit_data, qd_qunit) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data, qd_qunit));
        LASSERTF((int)sizeof(((struct qunit_data *)0)->qd_qunit) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data *)0)->qd_qunit));
        LASSERTF((int)offsetof(struct qunit_data, padding) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data, padding));
        LASSERTF((int)sizeof(((struct qunit_data *)0)->padding) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data *)0)->padding));

        /* Checks for struct qunit_data_old2 */
        LASSERTF((int)sizeof(struct qunit_data_old2) == 16, " found %lld\n",
                 (long long)(int)sizeof(struct qunit_data_old2));
        LASSERTF((int)offsetof(struct qunit_data_old2, qd_id) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data_old2, qd_id));
        LASSERTF((int)sizeof(((struct qunit_data_old2 *)0)->qd_id) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data_old2 *)0)->qd_id));
        LASSERTF((int)offsetof(struct qunit_data_old2, qd_flags) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data_old2, qd_flags));
        LASSERTF((int)sizeof(((struct qunit_data_old2 *)0)->qd_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data_old2 *)0)->qd_flags));
        LASSERTF((int)offsetof(struct qunit_data_old2, qd_count) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct qunit_data_old2, qd_count));
        LASSERTF((int)sizeof(((struct qunit_data_old2 *)0)->qd_count) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct qunit_data_old2 *)0)->qd_count));

        /* Checks for struct quota_adjust_qunit */
        LASSERTF((int)sizeof(struct quota_adjust_qunit) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct quota_adjust_qunit));
        LASSERTF((int)offsetof(struct quota_adjust_qunit, qaq_flags) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct quota_adjust_qunit, qaq_flags));
        LASSERTF((int)sizeof(((struct quota_adjust_qunit *)0)->qaq_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct quota_adjust_qunit *)0)->qaq_flags));
        LASSERTF((int)offsetof(struct quota_adjust_qunit, qaq_id) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct quota_adjust_qunit, qaq_id));
        LASSERTF((int)sizeof(((struct quota_adjust_qunit *)0)->qaq_id) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct quota_adjust_qunit *)0)->qaq_id));
        LASSERTF((int)offsetof(struct quota_adjust_qunit, qaq_bunit_sz) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct quota_adjust_qunit, qaq_bunit_sz));
        LASSERTF((int)sizeof(((struct quota_adjust_qunit *)0)->qaq_bunit_sz) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct quota_adjust_qunit *)0)->qaq_bunit_sz));
        LASSERTF((int)offsetof(struct quota_adjust_qunit, qaq_iunit_sz) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct quota_adjust_qunit, qaq_iunit_sz));
        LASSERTF((int)sizeof(((struct quota_adjust_qunit *)0)->qaq_iunit_sz) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct quota_adjust_qunit *)0)->qaq_iunit_sz));

        /* Checks for struct mgs_target_info */
        LASSERTF((int)sizeof(struct mgs_target_info) == 4544, " found %lld\n",
                 (long long)(int)sizeof(struct mgs_target_info));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_lustre_ver) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_lustre_ver));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_stripe_index) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_stripe_index));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_config_ver) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_config_ver));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_config_ver) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_config_ver));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_flags) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_flags));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_flags));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_nid_count) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_nid_count));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nid_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nid_count));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_fsname) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_fsname));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_fsname) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_fsname));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_svname) == 88, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_svname));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_svname) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_svname));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_uuid) == 152, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_uuid));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_uuid) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_uuid));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_nids) == 192, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_nids));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nids) == 256, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nids));
        LASSERTF((int)offsetof(struct mgs_target_info, mti_params) == 448, " found %lld\n",
                 (long long)(int)offsetof(struct mgs_target_info, mti_params));
        LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_params) == 4096, " found %lld\n",
                 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_params));

        /* Checks for struct lustre_disk_data */
        LASSERTF((int)sizeof(struct lustre_disk_data) == 12288, " found %lld\n",
                 (long long)(int)sizeof(struct lustre_disk_data));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_magic) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_magic));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_magic) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_magic));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_feature_compat) == 4, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_feature_compat));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_compat) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_compat));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_feature_rocompat) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_feature_rocompat));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_rocompat) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_rocompat));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_feature_incompat) == 12, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_feature_incompat));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_incompat) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_feature_incompat));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_config_ver) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_config_ver));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_config_ver) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_config_ver));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_flags) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_flags));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_flags));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_svindex) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_svindex));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_svindex) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_svindex));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_mount_type) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_mount_type));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_mount_type) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_mount_type));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_fsname) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_fsname));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_fsname) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_fsname));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_svname) == 96, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_svname));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_svname) == 64, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_svname));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_uuid) == 160, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_uuid));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_uuid) == 40, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_uuid));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_userdata) == 200, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_userdata));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_userdata) == 824, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_userdata));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_mount_opts) == 4096, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_mount_opts));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_mount_opts) == 4096, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_mount_opts));
        LASSERTF((int)offsetof(struct lustre_disk_data, ldd_params) == 8192, " found %lld\n",
                 (long long)(int)offsetof(struct lustre_disk_data, ldd_params));
        LASSERTF((int)sizeof(((struct lustre_disk_data *)0)->ldd_params) == 4096, " found %lld\n",
                 (long long)(int)sizeof(((struct lustre_disk_data *)0)->ldd_params));

        /* Checks for struct ll_user_fiemap */
        LASSERTF((int)sizeof(struct ll_user_fiemap) == 32, " found %lld\n",
                 (long long)(int)sizeof(struct ll_user_fiemap));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_start) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_start));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_start) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_start));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_length) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_length));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_length) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_length));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_flags) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_flags));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_flags));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_mapped_extents) == 20, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_mapped_extents));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_mapped_extents) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_mapped_extents));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_extent_count) == 24, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_extent_count));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_extent_count) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_extent_count));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_reserved) == 28, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_reserved));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_reserved) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_reserved));
        LASSERTF((int)offsetof(struct ll_user_fiemap, fm_extents) == 32, " found %lld\n",
                 (long long)(int)offsetof(struct ll_user_fiemap, fm_extents));
        LASSERTF((int)sizeof(((struct ll_user_fiemap *)0)->fm_extents) == 0, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_user_fiemap *)0)->fm_extents));
        CLASSERT(FIEMAP_FLAG_SYNC == 0x00000001);
        CLASSERT(FIEMAP_FLAG_XATTR == 0x00000002);
        CLASSERT(FIEMAP_FLAG_DEVICE_ORDER == 0x40000000);

        /* Checks for struct ll_fiemap_extent */
        LASSERTF((int)sizeof(struct ll_fiemap_extent) == 56, " found %lld\n",
                 (long long)(int)sizeof(struct ll_fiemap_extent));
        LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_logical) == 0, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fiemap_extent, fe_logical));
        LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_logical) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_logical));
        LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_physical) == 8, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fiemap_extent, fe_physical));
        LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_physical) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_physical));
        LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_length) == 16, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fiemap_extent, fe_length));
        LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_length) == 8, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_length));
        LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_flags) == 40, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fiemap_extent, fe_flags));
        LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_flags) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_flags));
        LASSERTF((int)offsetof(struct ll_fiemap_extent, fe_device) == 44, " found %lld\n",
                 (long long)(int)offsetof(struct ll_fiemap_extent, fe_device));
        LASSERTF((int)sizeof(((struct ll_fiemap_extent *)0)->fe_device) == 4, " found %lld\n",
                 (long long)(int)sizeof(((struct ll_fiemap_extent *)0)->fe_device));
        CLASSERT(FIEMAP_EXTENT_LAST == 0x00000001);
        CLASSERT(FIEMAP_EXTENT_UNKNOWN == 0x00000002);
        CLASSERT(FIEMAP_EXTENT_DELALLOC == 0x00000004);
        CLASSERT(FIEMAP_EXTENT_ENCODED == 0x00000008);
        CLASSERT(FIEMAP_EXTENT_DATA_ENCRYPTED == 0x00000080);
        CLASSERT(FIEMAP_EXTENT_NOT_ALIGNED == 0x00000100);
        CLASSERT(FIEMAP_EXTENT_DATA_INLINE == 0x00000200);
        CLASSERT(FIEMAP_EXTENT_DATA_TAIL == 0x00000400);
        CLASSERT(FIEMAP_EXTENT_UNWRITTEN == 0x00000800);
        CLASSERT(FIEMAP_EXTENT_MERGED == 0x00001000);
        CLASSERT(FIEMAP_EXTENT_NO_DIRECT == 0x40000000);
        CLASSERT(FIEMAP_EXTENT_NET == 0x80000000);
#if defined(LIBLUSTRE_POSIX_ACL) && defined(CONFIG_FS_POSIX_ACL)

        /* Checks for type posix_acl_xattr_entry */
        LASSERTF((int)sizeof(xattr_acl_entry) == 8, " found %lld\n",
                 (long long)(int)sizeof(xattr_acl_entry));
        LASSERTF((int)offsetof(xattr_acl_entry, e_tag) == 0, " found %lld\n",
                 (long long)(int)offsetof(xattr_acl_entry, e_tag));
        LASSERTF((int)sizeof(((xattr_acl_entry *)0)->e_tag) == 2, " found %lld\n",
                 (long long)(int)sizeof(((xattr_acl_entry *)0)->e_tag));
        LASSERTF((int)offsetof(xattr_acl_entry, e_perm) == 2, " found %lld\n",
                 (long long)(int)offsetof(xattr_acl_entry, e_perm));
        LASSERTF((int)sizeof(((xattr_acl_entry *)0)->e_perm) == 2, " found %lld\n",
                 (long long)(int)sizeof(((xattr_acl_entry *)0)->e_perm));
        LASSERTF((int)offsetof(xattr_acl_entry, e_id) == 4, " found %lld\n",
                 (long long)(int)offsetof(xattr_acl_entry, e_id));
        LASSERTF((int)sizeof(((xattr_acl_entry *)0)->e_id) == 4, " found %lld\n",
                 (long long)(int)sizeof(((xattr_acl_entry *)0)->e_id));

        /* Checks for type posix_acl_xattr_header */
        LASSERTF((int)sizeof(xattr_acl_header) == 4, " found %lld\n",
                 (long long)(int)sizeof(xattr_acl_header));
        LASSERTF((int)offsetof(xattr_acl_header, a_version) == 0, " found %lld\n",
                 (long long)(int)offsetof(xattr_acl_header, a_version));
        LASSERTF((int)sizeof(((xattr_acl_header *)0)->a_version) == 4, " found %lld\n",
                 (long long)(int)sizeof(((xattr_acl_header *)0)->a_version));
        LASSERTF((int)offsetof(xattr_acl_header, a_entries) == 4, " found %lld\n",
                 (long long)(int)offsetof(xattr_acl_header, a_entries));
        LASSERTF((int)sizeof(((xattr_acl_header *)0)->a_entries) == 0, " found %lld\n",
                 (long long)(int)sizeof(((xattr_acl_header *)0)->a_entries));
#endif
}

