/* lsmbox.h
 *
 * Copyright (C) 2002-2005 David Weinehall
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef _LSMBOX_H_
#define _LSMBOX_H_

#include <config.h>

#include <pwd.h>
#if TIME_WITH_SYS_TIME
#include <time.h>
#include <sys/time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#ifdef HAVE_UTIME
#include <utime.h>
#else
struct utimbuf {
	time_t actime;	/* access time */
	time_t modtime;	/* modification time */
};

/* Not a perfect work-around, but at least usable */
#define utime(__x, __y)		((void)0)
#endif /* HAVE_UTIME */
#undef NDEBUG
#include <assert.h>
#if defined(USE_CURSES) && HAVE_ATEXIT
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif /* HAVE_NCURSES_H */
#endif /* defined(USE_CURSES) && HAVE_ATEXIT */
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#elif HAVE_NDIR_H
#include <ndir.h>
#elif HAVE_DIR_H
#include <dir.h>
#elif HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#elif HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif /* DIRENT/NDIR/DIR/SYS_NDIR/SYS_DIR */
#include <getopt.h>
#include <limits.h>
#include <stdarg.h>
#include <stdlib.h>
#if STDC_HEADERS
#include <string.h>
#else
#if !HAVE_STRCHR
#define strchr			index
#define strrchr			rindex
#endif /* !HAVE_STRCHR */
#if !HAVE_MEMCPY
#define memcpy(dest, src, n)	bcopy((src), (dest), (n))
#define memmove(dest, src, n)	bcopy((src), (dest), (n))
#endif /* !HAVE_MEMCPY */
#endif /* STDC_HEADERS */
#if HAVE_UNISTD_H
#include <unistd.h>
#include <sys/types.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif /* HAVE_SYS_WAIT_H */
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val)	((unsigned)(stat_val) >> 8)
#endif /* WEXITSTATUS */
#ifndef WIFEXITED
#define WIFEXITED(stat_val)	(((stat_val) & 255) == 0)
#endif /* WIFEXITED */
#include <sys/stat.h>

#include <gettext.h>

#define _(__str)		gettext(__str)

#define SPOOLFILE_PATH		"/var/mail"	/* username follows */
#define MAILBOX_FOLDER_PATH	"Mail"		/* $HOME preceeds */
#define MAIL_COMMAND		"xterm -e mutt -f"

#define SET_STR			"set"
#define UNSET_STR		"unset"
#define MARK_OLD_STR		"mark_old"
#define SPOOLFILE_STR		"spoolfile"
#define MAILBOX_FOLDER_STR	"folder"
#define MAILBOX_STR		"mailboxes"
#define MH_SEQ_UNSEEN_STR	"mh_seq_unseen"
#define MAIL_COMMAND_STR	"lsmbox_mail_command"
#define PADDING_LEN_STR		"lsmbox_padding"

#define UNSEEN_STR		"unseen"

#define FROM_STR		"From "
#define STATUS_STR		"Status: "
#define CONTENT_LENGTH_STR	"Content-Length: "

#define BUF_SIZE		65536

#define MAILCHECK_DEFAULT	10
#define MAILCHECK_MINIMUM	3
#define HILIGHT_TIME		30
#define SELECTED_TIME		120

#define SKIP_EQ			(1 << 0)
#define SKIP_QU			(1 << 1)

#ifdef PATH_MAX
#define PADDING_MAX		PATH_MAX
#else
#ifdef FILENAME_MAX
#define PADDING_MAX		FILENAME_MAX
#else
#define PADDING_MAX		256
#endif
#endif

#ifdef USE_CURSES
#define OPTSTR		"ci:nop::sSt"
#else
#define OPTSTR		"nop::sSt"
#endif /* USE_CURSES */

struct option const options[] = {
#ifdef USE_CURSES
	{ "continuous", no_argument, 0, 'c' },
	{ "check-interval", required_argument, 0, 'i' },
#endif /* USE_CURSES */
	{ "new-only", no_argument, 0, 'n' },
	{ "no-old", no_argument, 0, 'o' },
	{ "no-summary", no_argument, 0, 's' },
	{ "padding", optional_argument, 0, 'p' },
	{ "short-names", no_argument, 0, 'S' },
	{ "no-total", no_argument, 0, 't' },
	{ "help", no_argument, 0, 'h' },
	{ "version", no_argument, 0, 'V' },
	{ 0, 0, 0, 0 }
};

typedef enum {
	MBOX,
	MAILDIR,
	MHDIR
} mbox_type_t;

typedef enum {
	E_OK,
	E_SYNTAX,
	E_UNKNOWN
} lsmbox_error_t;

#ifndef HAVE_VW_PRINTW
#define vw_printw		vwprintw
#endif /* HAVE_VW_PRINTW */

#endif /* _LSMBOX_H_ */
