/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/symbol.h"
#include "include/piece.h"

class LWSymbolRemark : public LWSymbol {

const gchar *getName ()
{
	return "remark";
}	

gchar *getHint ()
{
	return _("Remark");
}

gboolean canClone ()
{
	return FALSE;	
}

void onDndCopy (LWPiece *sourcepiece, LWPiece *destpiece)
{
	g_return_if_fail (sourcepiece->getSymbol() == this);
	g_return_if_fail (LW_TYPE_PROGRAM == destpiece->getRow()->getBoard()->getType());

	if (sourcepiece != destpiece)
		LWSymbol::onDndCopy(sourcepiece, destpiece);
}

void onDndMove (LWPiece *sourcepiece, LWPiece *destpiece)
{
	g_return_if_fail (sourcepiece->getSymbol() == this);
	g_return_if_fail (LW_TYPE_PROGRAM == destpiece->getRow()->getBoard()->getType());

	if (sourcepiece != destpiece)
		if (sourcepiece->getRow() != destpiece->getRow())
			LWSymbol::onDndMove(sourcepiece, destpiece);
		else {
			LWPiece *newpiece = new LWPiece (sourcepiece, destpiece->row);
			destpiece->getRow()->insertPieceBefore (newpiece, destpiece);
		}
}

void onAttach (LWPiece *piece)
{
	if (piece->getRow()->getBoard()->getType() == LW_TYPE_PROGRAM)
		piece->getRow()->setAsRemark (piece);
}

};

LWSymbol *new_LWSymbolRemark()
{
	return new LWSymbolRemark();
}
