/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandStep: public LWCommandSegment {
	
LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) argc;
	(void) args;
	
	g_return_val_if_reached (NULL);
}

const gchar *getName ()
{
	return "step";
}	

gchar *getHint ()
{
	return _("Step by");
}

void checkArgc (guint n)
{
	/* That will not be checked, because that command is skipped, but maybe some day,
	   it can be fixed */
		
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean matchPrevCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	/*
		missing to or dowto will caught in "for", 
		so we can assume here there is a to and downto,
		and show more clear message
	*/
		
	if (cmd == NULL)
			throw new LWMessage (LW_ERROR_StepButWhereIsFor);

	if (g_ascii_strcasecmp (cmd->getName(), "to") &&
		g_ascii_strcasecmp (cmd->getName(), "downto"))
			throw new LWMessage (LW_ERROR_StepButWhereIsFor);
	
	match();
	
	return TRUE;
}

gboolean canBeSkiped ()
{
	return isAlreadyMatched();
}

};

LWSymbol *new_LWCommandStep()
{
	return new LWCommandStep();
}
