/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include <gdk/gdkkeysyms.h>
#include "include/support.h"
#include "include/command.h"
#include "include/message.h"
#include "include/environment.h"
#include "include/wizard.h"

class LWCommandRead: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) args;
	
	g_return_val_if_fail (argc == 1, NULL);

	LWValue *value=new LWValue();
	
	g_queue_push_head (context->stack, (gpointer) value);
	
	context->resume = TRUE;
	context->wait_for = LW_RESUME_KEYPRESS;
	return NULL;
}	
	
LWValue *resume1 (LWContext *context, guint argc, LWValue *args[])	
{
	g_return_val_if_fail (argc == 1, NULL);

	LWValue *value = (LWValue *) g_queue_pop_head (context->stack);
	
	while (FALSE == g_queue_is_empty(context->queue_keys)) {
	
		guint key = GPOINTER_TO_UINT(g_queue_pop_head (context->queue_keys));

		LWValue *vchar = NULL;

			if (key >= GDK_A && key <= GDK_Z) {
				gchar *s = g_strdup_printf ("letter-%c", 'a'+key-GDK_A);
				vchar = new LWValue(LWEnvironment::getPixmapSet()->getPixmap(s));
				g_free (s);
			} else
			if (key >= GDK_a && key <= GDK_z) {
				gchar *s = g_strdup_printf ("letter-%c", 'a'+key-GDK_a);
				vchar = new LWValue(LWEnvironment::getPixmapSet()->getPixmap(s));
				g_free (s);
			} else
			if (key >= GDK_0 && key <= GDK_9) {
				gchar *s = g_strdup_printf ("%c", '0'+key-GDK_0);
				vchar = new LWValue(LWEnvironment::getPixmapSet()->getPixmap(s));
				g_free (s);
			} else
			if (key >= GDK_KP_0 && key <= GDK_KP_9) {
				gchar *s = g_strdup_printf ("%c", '0'+key-GDK_KP_0);
				vchar = new LWValue(LWEnvironment::getPixmapSet()->getPixmap(s));
				g_free (s);
			} else
			if (key == GDK_minus || key == GDK_KP_Subtract) {
				vchar = new LWValue(LWEnvironment::getPixmapSet()->getPixmap("-"));				
			} else
			if (key == GDK_space || key == GDK_KP_Space) {
				vchar = new LWValue((LWPixmap *) NULL);
			} else
			if (key == GDK_Return || key == GDK_KP_Enter) {
				args[0]->set (value);
				return NULL;
			} else
			if (key == GDK_BackSpace) {
				guint cnt = value->count();
				if (cnt > 0) {
					context->wizard->stepBack();
					LWValue v((LWPixmap *) NULL);
					context->wizard->create (&v);
					
					for (guint i=0; i < cnt; i++)
						context->wizard->stepBack();
					
					value->deleteIndex(cnt);
					context->wizard->create (value);
				}
				continue;
			} else
				continue;
		
			//Check is there a room for next character
			if (FALSE == context->wizard->isCreatingPossible())
				continue;
			
			for (guint i=0; i < value->count(); i++)
				context->wizard->stepBack();
		
			value->concat (vchar);
			delete vchar;
				
			context->wizard->create (value);
	}

	g_queue_push_head (context->stack, (gpointer) value);
	
	context->resume = TRUE;
	context->wait_for = LW_RESUME_KEYPRESS;
	return NULL;
}	

const gchar *getName (void) 
{
	return "read";
}	

gchar *getHint ()
{
	return _("Read a string from the user");
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable())
		throw new LWMessage (LW_ERROR_LValueIsNotVariable);
	
	if (TRUE == value->isSpecial())
		throw new LWMessage (LW_ERROR_DontUseSpecial);
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandRead()
{
	return new LWCommandRead();
}
