package tests::MinTest;

use strict;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::Min;
use Lire::ReportSpec;
use tests::MockAggregator;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_test_schema();

    $self->{'spec'} = new Lire::ReportSpec();
    $self->{'spec'}->superservice( 'test' );
    $self->{'spec'}->id( 'test-min' );

    my $mock = new tests::MockAggregator( 'report_spec' => $self->{'spec'} );

    $self->{'min'} = new Lire::Min( 'report_spec' => $self->{'spec'},
                                    'parent' => $mock,
                                    'field' => 'file_size',
                                    'name' => 'min' );

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->SUPER::tear_down();

    return;
}

sub test_sql_aggr_expr {
    my $self = $_[0];

    $self->{'min'}{'field'} = 'file-size';
    $self->assert_equals( 'min("file-size")', $self->{'min'}->sql_aggr_expr() );
}

1;
