#!/bin/sh

#
# Line6 Linux USB driver - 0.6
#
# Copyright (C) 2005, 2006 Markus Grabner (grabner@icg.tugraz.at)
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License as
#	published by the Free Software Foundation, version 2.
#

# stores all patches found in directory "./patches" on the PODxt Pro

SYSDIR=`line6_find_device.pl sysdir POD`

function store_data
{
    for p in `ls data/${1}_???_*.pod`; do
	n=`echo $p | perl -e 'while(<>){s/.*?_(\d\d\d).*/$1/;print $_;}'`
	echo "storing $1 #$n $p"
	cp $p $SYSDIR/dump_buf
	echo $n > $SYSDIR/store_$1
    done

    echo > $SYSDIR/finish
    sleep 3.1
}

store_data channel
store_data effects_setup
store_data amp_setup
