// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

#include <qmessagebox.h> 
#include <qfontinfo.h>
#include <qtoolbutton.h> 
#include <qfile.h>
#include <qfiledialog.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qapplication.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qtable.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qevent.h>
#include <qlabel.h>
#include <qregexp.h>

#include "utils.h"
#include "AxUnit.h"
#include "shellex.h"
#include "AxGetList.h"
#include "AxGetMsg.h"
#include "event.h"
#include "addrbook.h"
#include "automark.h"
#include "configw.h"



extern QApplication *Application;
extern TList_window *List_window;
extern TUtils 	     Util;
extern TAxUnit 	     AxU;
extern TShellEx      *ShellEx;
extern TAddrBook     *AddrBook;
extern TAutoMark     *AutoMark;
extern TConfig	     *ConfigW;


extern TAttrs FormAttrsTb[10];
extern int AlRdyRead[10000];
extern int IdxInDir[10000];
extern int MsgsInDir[10000];
extern int AutoMarkCount;
extern int StatusByte;
extern int MsgIndex;         //{## amount of Msgs to 'axgetmsg' ##}
extern int MsgsToRead[200];  //{## Msgs marked to 'axgetmsg' ##}
extern QString  PrgPath;
extern QString  ListPath;
extern bool  AgeExpire;
extern int   AgeExpireDays;
extern bool  NrExpire;
extern int   NumberExpire;



void TList_window::ListView1doubleClicked( QListViewItem *item )
{
 //  QListViewItem *item = new QListViewItem( ListView1 );
//   QMessageBox::information( this, "Title",QString::number(j,10) );
        
   if (item->text(0)!="!")  
        item->setText( 0, "!");
   else
  //   if (item->text(0)=="!")
     	item->setText( 0, "");
}



void TList_window::GetListBtn()
{
	AutoMarkCount = Util.LoadAutoMarkTbl();
	
    QListViewItem *curItem (ListView1->selectedItem() );
      TConBBS GetList;
      try
      {
      	GetList.run();
	while (GetList.running() )
	{
		if (StatusByte == 6 ) throw 2;
		Application->processEvents();	
	}
      }
      catch (int ex)
      {
	      GetList.terminate();
	      GetList.exit();
	      AxU.DiscBBS();
	      QMessageBox::critical( ShellEx, "Error",  "Cannot connect to BBS" );
      }

       ListView1->ensureItemVisible( curItem );
}


void TList_window::Quit_and_Save()
{
	QString tmp;
	int k;	
	int i;
	int j;
	int NrOfIdxs;
	int NrOfMsgs;
	int MinInList;
	bool found;
		
   	Util.SaveConfigFile();
   
	QDate Today = QDate::currentDate();
   	tmp.sprintf("%02d%02d", Today.month(), Today.day() );
	
	if ( AgeExpire )
	{
		k = Util.Look4Idx('i');
		for ( i=1; i<=k; i++)
		{
			QFileInfo info (PrgPath+"control/"+QString::number(IdxInDir[i])+".idx");
			QDateTime days;
			j = days.daysTo( info.lastModified() );
			if ( j>= AgeExpireDays ) 
			{
				QMessageBox::information( this, "Title", "Delete: " + QString::number(IdxInDir[i]) );
				QFile::remove( PrgPath+"mail/" + QString::number(IdxInDir[i]) );
			}
		}
	}
   
	if ( NrExpire && NumberExpire != 0 )
	{
		if ( ListView1->childCount() > NumberExpire )
		{
			QListViewItem *item; 
			while ( ListView1->childCount() > NumberExpire )
			{
				item = ListView1->firstChild();
				delete item;
			}
		}
		SaveList();
	}
	
	MinInList = ListView1->firstChild()->text(1).toInt();
	NrOfMsgs  = Util.Look4Msgs();                        
	NrOfIdxs   = Util.Look4Idx('i');                       
	
	for ( i=0; i<NrOfIdxs; i++ )
	{
		found = FALSE;
		for ( j=0; j<NrOfMsgs; j++) if ( IdxInDir[i]==MsgsInDir[j] ) found = TRUE;
		if ( AlRdyRead[i] >= MinInList ) found = TRUE;
		
		if (( ! found ) && ( IdxInDir[i] < MinInList))
			QFile::remove( PrgPath + "control/" + QString::number(IdxInDir[i]) + ".idx" );
	
	}
	
	Application->exit();
}
 

void TList_window::UpdateFormAttrs()
{
  QFontInfo fi (ListView1->font());
  QColor font_color(ListView1->foregroundColor());
  QColor background(ListView1->paletteBackgroundColor());
  
  FormAttrsTb[1].FontAttrs.Name      =  fi.family();
  FormAttrsTb[1].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[1].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[1].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[1].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[1].FontAttrs.Italic    =  fi.italic();
  
  FormAttrsTb[1].FormAttrs.Color  =  ListView1->paletteBackgroundColor().name();
  FormAttrsTb[1].FormAttrs.x      =  List_window->x();
  FormAttrsTb[1].FormAttrs.y      =  List_window->y();
  FormAttrsTb[1].FormAttrs.height =  List_window->height();
  FormAttrsTb[1].FormAttrs.width  =  List_window->width();

}



void TList_window::customEvent(QCustomEvent * e)
{
   if ( e->type() == 65433 ) 
   {  
      LiViLineEvent* lvln = (LiViLineEvent*)e;
      
      QListViewItem *item = new QListViewItem( ListView1 );
      if ( Util.AutoMarkChk( lvln->line(), AutoMarkCount ) ) 
      {
	      item->setText( 0,"!");
	      QPainter paint( this );
	      QColorGroup cg;
	      paint.setPen( Qt::blue );
	      item->paintCell( &paint, cg, 1,10,AlignCenter);
	      //paint.drawText( rect(), AlignCenter, "The Text" );

      }
        item->setText( 1, Util.substring('c','N',lvln->line()));
        item->setText( 2, Util.substring('c','L',lvln->line()));
        item->setText( 3, Util.substring('c','S',lvln->line()));
        item->setText( 4, " "+Util.substring('c','T',lvln->line()));
        item->setText( 5, Util.substring('c','A',lvln->line()));
        item->setText( 6, Util.substring('c','F',lvln->line()));
        item->setText( 7, Util.substring('c','D',lvln->line()));
        item->setText( 8, Util.substring('c','M',lvln->line()));
        item->setText( 9, Util.substring('c','X',lvln->line()));

 ListView1->ensureItemVisible( item );
   }

}


void TList_window::GetMsgBtn()
{
    TAxGetMsg GetMsgs;
//    QListViewItem *last = NULL;
    QListViewItem *item;
    idx_record idx_tmp;
    QString line;
    
    //last = ListView1->lastItem();
    
    if (StatusByte == 0)
    {
      StatusByte = 2;
      GetMsgsBtn->setToggleAction( TRUE );
      
      item = ListView1->findItem("!",0,Contains);
  //    QListViewItemIterator it (item);
      QListViewItemIterator it (ListView1->firstChild());
      while (it.current() != 0)
      {
        if (it.current()->text(0)=="!")
	{
	  idx_tmp.number  = it.current()->text(1).stripWhiteSpace();
	  idx_tmp.flag    = it.current()->text(2).stripWhiteSpace();
	  idx_tmp.size    = it.current()->text(3).stripWhiteSpace();
	  idx_tmp.to_a    = it.current()->text(4).stripWhiteSpace();
	  idx_tmp.at      = it.current()->text(5).stripWhiteSpace();
	  idx_tmp.from    = it.current()->text(6).stripWhiteSpace();
	  idx_tmp.date    = it.current()->text(7).stripWhiteSpace();
	  idx_tmp.time    = it.current()->text(8).stripWhiteSpace();
	  idx_tmp.subject = it.current()->text(9).stripWhiteSpace();
	
   line = Util.Idx2Str('i',idx_tmp);
   MsgIndex++;
   MsgsToRead[MsgIndex] = idx_tmp.number.toInt();
   
   
   QFile fl( PrgPath+"control/"+idx_tmp.number+".id_");
   if (! fl.exists())
   {
     fl.open( IO_WriteOnly);
     QTextStream stream( &fl );
     stream << line << (char)(0x0a);
     fl.close();
   }
 }
       it++;
     } //while
     
     if (MsgIndex > 0)
     {
	     try
	     {
 	       	GetMsgs.run();
		while (GetMsgs.running() )
		{
			if (StatusByte == 6 ) throw 2;
			Application->processEvents();	
		}
	     }
	     catch (int ex)
	     {
		     GetMsgs.terminate();
		     QMessageBox::critical( ShellEx, "Error",  "Cannot connect to BBS" );
	     }
       Application->processEvents();
       Util.GetList();
       Util.MsgDir( TRUE );
       //ListView1.setCurrentItem( last );
     
     }
     MsgIndex = 0;
     GetMsgsBtn->setToggleAction( FALSE );
     StatusByte = 0;
 
    }

}



void TList_window::hideEvent( QHideEvent *e )
{
 if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}


void TList_window::Add2MarkBtnClick()
{
	QString tmp;
	QListViewItem *list_item ( ListView1->currentItem() );
	bool found = FALSE;
	
	AddrBook->show();
	tmp = list_item->text(4).stripWhiteSpace();
//	QMessageBox::information( this, "Tytul",tmp );
	for (int row=0;row <= AddrBook->AddrList->numRows();row++)
	{
		if (AddrBook->AddrList->text(row, 1) == tmp ) 
		{
			found = TRUE;
			QMessageBox::critical( this, "Sorry",tmp + " already exists in you Address Book" );
		}
	}

	if ( (! found) && ( ! tmp.isEmpty() ) ) 
	{
		AddrBook->AddrList->insertRows( AddrBook->AddrList->numRows(),1);
		AddrBook->AddrList->setText(AddrBook->AddrList->numRows()-1,1,tmp);
	}
}


void TList_window::AutoMarkBtnClick()
{
	AutoMark->show();
}


void TList_window::CaptureBtnClick()
{
	ShellEx->show();
}


void TList_window::ClearBtnClick()
{
	int Btn;
	
	Btn = QMessageBox::question( List_window, "LinAMC","This action will delete whole bulletin's list\n" "Are you sure ?", QMessageBox::Yes, QMessageBox::No, 0 );
	
	if ( Btn == QMessageBox::Yes )
	{
		ListView1->clear();
		QDir dir (ListPath);
		dir.rename(ListPath, ListPath+".bak");
		SaveList();
	}

}


void TList_window::ColorBtnClick()
{
	QColor colorTmp = QColorDialog::getColor( ListView1->paletteBackgroundColor () );
	if ( colorTmp.isValid() ) ListView1->setPaletteBackgroundColor( colorTmp );
  	UpdateFormAttrs();
}



void TList_window::DeleteLinesBtnClick()
{
	int Btn;
	
	Btn = QMessageBox::question( List_window, "LinAMC","This action will delete selected lines\n" "Are you sure ?", QMessageBox::Yes, QMessageBox::No, 0 );
	
	if ( Btn == QMessageBox::Yes )
	{
		QListViewItemIterator it (ListView1->firstChild());
		while (it.current() != 0)
		{
			if (it.current()->isSelected() )
			{
				delete it.current();
			}
			it++;
		} //while
		
		SaveList();
	}
}


void TList_window::FontBtnClick()
{
    ListView1->setFont( QFontDialog::getFont( 0, ListView1->font() ) );
    UpdateFormAttrs();

}


void TList_window::InsertBtnClick()
{
	int Btn;
	
	Btn = QMessageBox::question( List_window, "LinAMC","This action will clear the list\n" "Are you sure ?", QMessageBox::Yes, QMessageBox::No, 0 );
	
	if ( Btn == QMessageBox::Yes )
	{
		QString s = QFileDialog::getOpenFileName(
				PrgPath+"ulistd/", "Text files (*.txt);; All files (*)",this,"open file dialog", "Choose a file to open " );
		
		if ( (s != ListPath) && (! s.isEmpty()) )
		{
			Util.CopyFile( s, ListPath );
			Util.GetList();
		}

	}

}


void TList_window::ListConfigBtnClick()
{
	//ConfigW->show();
}


void TList_window::RefreshList()
{
	Util.GetList();
}


void TList_window::RemoveTagBtnClick()
{

}


void TList_window::SaveBtnClick()
{
	QString s = QFileDialog::getSaveFileName(
			PrgPath+"/",
	"Text files (*.txt)",
	this,"save file dialog", "Choose a filename to save under"  );
		
	if ( (s != ListPath) && ( ! s.isEmpty() ) )
		Util.CopyFile( ListPath, s );
}


void TList_window::SetupBtnClick()
{
	ConfigW->show();
}


void TList_window::TagBtnClick()
{

}


void TList_window::ListTagBtnClick()
{

}


void TList_window::showEvent( QShowEvent * e )
{
  if ( ! e->spontaneous ()  )
  {
  QFont fi;
  QColor color; //(MsgList->paletteBackgroundColor());
  
  
  fi.setFamily(FormAttrsTb[1].FontAttrs.Name);
  fi.setPointSize(FormAttrsTb[1].FontAttrs.Size);
  
  fi.setFixedPitch(FormAttrsTb[1].FontAttrs.Pitch);
  fi.setBold(FormAttrsTb[1].FontAttrs.Bold);
  fi.setItalic(FormAttrsTb[1].FontAttrs.Italic);
  ListView1->setFont( fi );
  
  color.setNamedColor(FormAttrsTb[1].FormAttrs.Color);
  ListView1->setPaletteBackgroundColor(color);
  ListView1->setPaletteForegroundColor (FormAttrsTb[1].FontAttrs.Color); // Font Color
  
  move( FormAttrsTb[1].FormAttrs.x, FormAttrsTb[1].FormAttrs.y );
  resize( FormAttrsTb[1].FormAttrs.width, FormAttrsTb[1].FormAttrs.height );

  }
}



void TList_window::SaveList()
{
	QString s;
	QString line;
	idx_record idx_tmp;
	
 	QFile fl( ListPath );
	if (fl.open( IO_WriteOnly ))
	{
		QTextStream stream ( &fl );
		
		QListViewItemIterator it (ListView1->firstChild());
		while (it.current() != 0)
		{
			idx_tmp.number  = it.current()->text(1).stripWhiteSpace();
			idx_tmp.flag    = it.current()->text(2).stripWhiteSpace();
			idx_tmp.size    = it.current()->text(3).stripWhiteSpace();
			idx_tmp.to_a    = it.current()->text(4).stripWhiteSpace();
			idx_tmp.at      = it.current()->text(5).stripWhiteSpace();
			idx_tmp.from    = it.current()->text(6).stripWhiteSpace();
			idx_tmp.date    = it.current()->text(7).stripWhiteSpace();
			idx_tmp.time    = it.current()->text(8).stripWhiteSpace();
			idx_tmp.subject = it.current()->text(9).stripWhiteSpace();
	
			line = Util.Idx2Str('l',idx_tmp);
			stream << line << "\n";
			it++;
		} //while

		fl.close();
	}
	
	
}





void TList_window::contextMenu( QListViewItem *, const QPoint & , int )
{
	QPopupMenu* contextMenu = new QPopupMenu( this );
	Q_CHECK_PTR( contextMenu );
	QLabel *caption = new QLabel( "List actions", this );
	caption->setAlignment( Qt::AlignCenter );
	contextMenu->insertItem( caption );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Add TO to AutoMark",  this, SLOT(addTO2AMark()) );
	contextMenu->insertItem( "Add FROM to AutoMark",  this, SLOT(addFROM2AMark()) );
	contextMenu->insertItem( "Add BBS to AutoMark",  this, SLOT(addBBS2AMark()) );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Select 7+ parts",  this, SLOT(select7PL()) );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Change Background &color",  this, SLOT(ColorBtnClick()) );
	contextMenu->insertItem( "Change &font",  this, SLOT(FontBtnClick()) );
	contextMenu->exec( QCursor::pos() );
	delete contextMenu;

}


void TList_window::addTO2AMark()
{
	QListViewItem * item = ListView1->currentItem();
	QTable * AMTbl = AutoMark->AutoMarkTbl;
	AutoMark->show();
	AMTbl->setText( AMTbl->numRows()-1, 0, item->text(4).stripWhiteSpace()); //item->text(1)
}


void TList_window::addFROM2AMark()
{
	QListViewItem * item = ListView1->currentItem();
	QTable * AMTbl = AutoMark->AutoMarkTbl;
	AutoMark->show();
	AMTbl->setText( AMTbl->numRows()-1, 2, item->text(6).stripWhiteSpace()); //item->text(1)
}


void TList_window::addBBS2AMark( )
{
	QListViewItem * item = ListView1->currentItem();
	QTable * AMTbl = AutoMark->AutoMarkTbl;
	AutoMark->show();
	AMTbl->setText( AMTbl->numRows()-1, 1, item->text(5).stripWhiteSpace()); //item->text(1)
}


void TList_window::select7PL( )
{
	//QListViewItem * item = ListView1->firstChild();
	QListViewItemIterator  it (ListView1->firstChild());
	QListViewItem *item;
	QRegExp RegExp("\\s[0-9]{1,2}/[0-9]{1,2}$");
	QString tmp;
	int i;
	
	item = *it;
	i = RegExp.search(ListView1->currentItem()->text(9));
	if (i>-1) 
	{
		tmp = ListView1->currentItem()->text(9).left(i);
		//QMessageBox::information( this, "Title", "zm = "+tmp);
	
		while (*it)
		{
			item = *it;
			if (item->text(9).contains(tmp)>0) item->setText(0, "!");
			it++;
		}
	}
	
}


