/* $Id: limo.h,v 1.12 2000/01/24 00:37:05 fraserm Exp $
   $Log: limo.h,v $
   Revision 1.12  2000/01/24 00:37:05  fraserm
   Cygwin support, 'e' option

   Revision 1.11  1999/12/22 01:54:58  fraserm
   declared DEFSEPCHAR default separator character for -S

   Revision 1.10  1999/12/21 02:42:30  fraserm
   changes as per 0.3 in CHANGELOG

   Revision 1.9  1999/12/14 02:13:56  fraserm
   *** empty log message ***

   Revision 1.8  1999/07/01 01:41:13  fraserm
   LIMO_STYLE

   Revision 1.7  1999/06/15 23:48:39  fraserm
   added LIMO_WIDTH environment variable as "COLUMNS"

   Revision 1.6  1999/05/30 11:35:23  fraserm
   added support for multiple sort chunks

   Revision 1.5  1999/05/30 01:17:56  fraserm
   showhelp() warning at chunk definitions

   Revision 1.4  1999/05/30 01:08:34  fraserm
   added NOPRINT option for fix to padded filenames

   Revision 1.3  1999/05/26 23:51:13  fraserm
   added custom command stuff

   Revision 1.2  1999/05/16 19:49:24  fraserm
   changed n N and L to n +n N and +N

   Revision 1.1  1999/04/28 00:34:48  fraserm
   Initial revision

*/

/* Header file for limo */

/* Andre Oliveira da Costa <costa@cade.com.br> reports that this is required
   for Cygwin compiles under gcc-2.95.2, but I don't know which source files
   specifically require it, so this covers all the bases */
#include <sys/types.h>

/* buffer sizes */
#define CMDMAX 1024 /* maximum length of a custom command */
#define CMDOUTMAX 80 /* maximum length of custom command return data */
#define MAXCUSTCMDS (('9' - '0') + 1) /* max number of custom commands */

/* environment variables */
#define LIMO_FORMAT "LIMO_FORMAT" /* default format */
#define LIMO_FORMAT_L "LIMO_FORMAT_L" /* default format with -l */
#define LIMO_FORMAT_S "LIMO_FORMAT_S" /* default format with -s */
#define LIMO_ORDER "LIMO_ORDER"
#define LIMO_STYLE "LIMO_STYLE"
#define LIMO_WIDTH "COLUMNS"

/* embedded strings */
#define TOTAL_LABEL "(total)"; /* what's displayed in the filename field of
				  a total line */

/* general options */
#define SHOW_ALL 0x1 /* show all files, even those beginning with a period */
#define SHOW_DIR_HEAD 0x2 /* show a directory header line when listing a whole
			     directory */
#define DIRS_AS_FILES 0x4 /* treat a directory as a normal file when listing
			     i.e. don't show its contents */
#define USE_COMPARE_FILE 0x8 /* use the compare file structure for age
				calculations */
#define RECURSE 0x10 /* recurse into subdirectories */
#define NOPAD_NAMES 0x20 /* don't pad filenames with spaces to keep format
			    neat - need this for comma-separated format */
#define GET_OWNER 0x40 /* for each file node, get the username from the UID */
#define GET_GROUP 0x80 /* for each file node, get group name from the GID */
#define GET_LINK_TARGET 0x100 /* for each file node, get the link target */
#define VERBOSE 0x200 /* verbose output */
#define LAST_IN_ROW 0x400 /* temporarily set if a displayed file is the last
			     in its row */
#define NOPRINT 0x800 /* set if a file should not be displayed, just the width
			 calculated */
#define QUOTE_UNPRINTABLE 0x1000 /* replace unprintable characters in filenames
				    with '?' */
#define SHOW_TOTALS 0x2000 /* show totals after each list */
#define SAME_FILESYSTEM 0x4000 /* when recursing, stay in same filesystem */
#define SHOW_ALL_LIMITED 0x8000 /* show all except . and .. */
/* the options below here won't work unless ints are > 16 bits */
#define FULL_PATHNAMES 0x10000 /* show full pathname of each file */
#define OPTIONS_DEFAULT 0x0

/* printing style options */
#define COLUMN_DOWN 'd' /* columns, sorted down */
#define COLUMN_ACROSS 'a'/* columns, sorted across */
#define COMMA_JUST ',' /* comma separated, left justified */
#define STYLE_DEFAULT COLUMN_DOWN
#define WIDTH_DEFAULT 80 /* if all else fails */
#define DEFSEPCHAR ' ' /* default chunk separator */

/* sorting options */
#define SORT_DIR_ASC '+' /* ascending */
#define SORT_DIR_DESC '-' /* descending */
#define SORT_CHUNKS_DEFAULT "+n" /* by default, sort by filename */
#define SORT_ALLOWED_CHUNKS "nbspduUgGiamc" /* string of chunks that may be
					       sorted on */

/* different chunks of info specified by each spec letter; the lowercase ones
   only are also used for sorting
   IF YOU ADD ANY, ALSO CHANGE showhelp() IN limo.c! */
/* any character found in chunks that's not in the following string will
   not be preceded by a space when computing the format */
#define OPT_LETTERS "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
#define OPT_PREFIX '%' /* a la printf */
#define NAME 'n' /* the filename, or filename pointed to by symlink */
#define D_NAME "filename" /* all descriptions must be <= 24 characters */
#define NAMEID 'N' /* filename with an id knob appended, e.g. / for dir, @ for
		      symlink */
#define D_NAMEID "filename-with-type"
#define DESCSHORT 'd' /* short description of the file type:
			 File - normal file
			 Dir  - directory
			 Syml - symbolic link
			 ChSp - character special
			 BlSp - block special
			 FIFO - named pipe
			 Sock - socket */
#define D_DESCSHORT "description"
#define DESCLONG 'D' /* long description of the file type:
			File - normal file
			Directory  - directory
			Symbolic link - symbolic link
			Character special - character special
			Block special - block special
			FIFO - named pipe
			Socket - socket */
#define D_DESCLONG "long-description"
#define SIZEBLOCKS 'b' /* in blocks */
#define D_SIZEBLOCKS "size-blocks"
#define BYTESSHORT 's' /* bytes, short heuristic form
			  up to 999bytes: 999b; up to 9.9K: 9.9K;
			  up to 999K: 999K (rounded down);
			  9.9M; 999M; 9.9G; 999G) */
#define D_BYTESSHORT "size-bytes"
#define BYTESLONG 'S' /* bytes, long fixed form */
#define D_BYTESLONG "long-size-bytes"
#define MODESHORT 'p' /* octal protection mode, eg 100755 */
#define D_MODESHORT "mode-octal"
#define MODELONG 'P' /* protection mode string, eg. -rwxr-xr-x */
#define D_MODELONG "long-mode-bits"
#define OWNERNUMBER 'u' /* UID */
#define D_OWNERNUMBER "UID-number"
#define OWNERNAME 'U' /* owner username, or UID if none */
#define D_OWNERNAME "user-name"
#define GROUPNUMBER 'g' /* GID */
#define D_GROUPNUMBER "GID-number"
#define GROUPNAME 'G' /* group name, or GID if none */
#define D_GROUPNAME "group-name"
#define INODE 'i' /* inode number */
#define D_INODE "inode-number"
#define LINKS 'l' /* number of hard links */
#define D_LINKS "hard-links"
#define ACCESSSHORT 'a' /* time of last access, short form:
			   <24 hours: 15:24
			   <12 months: 09Aug; >12 months: Aug98;
			   >=50 years: 1998 */
#define D_ACCESSSHORT "accessed"
#define ACCESSLONG 'A' /* time of last access, long form:
			  Thu-09-Aug-1998-15:24:43 */
#define D_ACCESSLONG "long-accessed"
#define MODIFYSHORT 'm' /* time of last modification, short form */
#define D_MODIFYSHORT "modified"
#define MODIFYLONG 'M' /* obvious */
#define D_MODIFYLONG "long-modified"
#define CHANGESHORT 'c'
#define D_CHANGESHORT "changed"
#define CHANGELONG 'C'
#define D_CHANGELONG "long-changed"
#define RELATIVE '-' /* if this modifier appears before a a date format, the
			date displays as the age rather than the absolute
			datestamp, i.e., for short form:
			<60 min: -34m45; <24 hours: -13h43; <100 days: -56d13;
			else: -450d
			for long form:
			-003d 13:25:18; + is used for future times; */
#define D_RELATIVE "relative"
#define RAWTIME '=' /* if this appears before a long time format, it displays
		       as the raw timestamp, # of seconds since the epoch */
#define D_RAWTIME "raw-time"
#define LINK '+' /* if this appears before a filename option, displays
		    the link target following the filename a la
		    "-> target" */
#define D_LINK "show-link"
#define EFFECTIVE_SHORT 'e' /* effective current permissions on the file, e.g.
			       rwx = user has full permission;
			       r-x = real+execute;
			       --- = nothing */
#define D_EFFECTIVE_SHORT "effective"
#define HELP '?' /* not really a chunk, but meaningful to the showhelp()
		    function */

#define TIME_SHORT 0 /* these are for passing to the time display routines
			to make the call a little more readable */
#define TIME_LONG 1

#define DEFAULTCHUNKS "n" /* default output format if not given */
#define LONGCHUNKS "PlUGSm+n" /* similar to ls -l */
#define SHORTCHUNKS "sn" /* similar to ls -s */

/* possible error codes returned by the program */
#define ERROR_SUCCESS 0
#define ERROR_ARGS 1 /* error in arguments */
#define ERROR_PROC 2 /* during processing */

struct fnode {
  char *name;
  int namelen, linklen;
  char *username, *groupname, *linktarget; /* not always used */
  char **custvals; /* return values from custom commands */
  int *custlens; /* lengths of return values */
  struct stat *s;
};

struct totals {
  unsigned long count;
  off_t bytes;
  unsigned long blocks;
};

struct flist {
  unsigned long size; /* number of elements */
  unsigned long dirs; /* number of directories */
  int maxnamelen; /* length of longest filename */
  int maxlinklen; /* length of longest link target; not always used */
  int *maxcustlens; /* length of longest return from each custom command */
  struct fnode **fa;
};

struct custcmd {
  int linenum; /* which line of the output */
  int wordnum; /* which word of the output */
  char *cmd; /* the command itself */
};

void flist_clear();
unsigned long flist_append();
void flist_free();
void flist_sort();
int fnode_compare();
struct fnode *newfnode();
void fnode_free();
void display_file_list();
void display_directory();
int display_file();
char *get_custom();
