/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_DIARY_HEADER
#define LIFEOGRAPH_PANEL_DIARY_HEADER


#include "diary.hpp"
#include "widget_entrylist.hpp"


namespace LIFEO
{

class PanelDiary
{
	public:

								PanelDiary( void );

		void					update_entry_list( void );
		void					update_calendar( void );

		void					show( const DiaryElement* );
		void					present_current_row( void );
		void					show_prev_session_elem( void );

		void					handle_calendar_doubleclicked( void );
		void					handle_calendar_monthchanged( void );
		void					handle_calendar_dayselected( void );
		void					handle_calendar_button_pressed( GdkEventButton* );
		void					select_date_in_calendar( const Date& );

		void					handle_filter_favorites_toggled( void );
		void					handle_login( void );
		void					handle_logout( void );

		bool					make_path_deeper_last( Gtk::TreePath& );
		bool					move_path_next( Gtk::TreePath& );
		void					go_up( bool );
		void					go_down( bool );

		void					handle_entry_filter_changed( void );
		void					go_prev_match( void );
		void					go_next_match( void );
		void					replace_match( void );
		void					replace_all_matches( void );

		Gtk::TreeRow			get_row( const Gtk::TreePath& );

		void					handle_treeview_row_expanded( const Gtk::TreeIter&,
															  const Gtk::TreePath& );

	protected:
		void					create_chapter( const Date& );

		WidgetEntryList			*m_treeview_entries;

		Gtk::Calendar			*m_calendar;
		EntryIdletext			*m_entry_filter;
		EntryIdletext			*m_entry_replace;
		Gtk::ToolButton			*m_button_match_prev;
		Gtk::ToolButton			*m_button_match_next;
		Gtk::Toolbar			*m_toolbar_replace;
		Gtk::ToolButton			*m_toolbutton_replace;
		Gtk::ToolButton			*m_toolbutton_replace_all;

		Gtk::RadioMenuItem		*m_menuitem_sort_by_date;
		Gtk::RadioMenuItem		*m_menuitem_sort_by_size;
		Gtk::CheckMenuItem		*m_menuitem_filter_favorites;

		// LISTING TMP VARIABLES
		void					add_chapter_category_to_list( const CategoryChapters* );
		Entryiter				l_itr_entry;
		Gtk::TreeRow			l_row_diary;
		Gtk::TreeRow			l_row_entry;
		Entry					*l_entry;

	friend class Lifeograph;
};



} // end of namespace LIFEO

#endif
