/***********************************************************************************

	Copyright (C) 2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_PREFERENCES_HEADER
#define LIFEOGRAPH_DIALOG_PREFERENCES_HEADER


#include <gtkmm.h>

#include "diary.hpp"
#include "lifeobase.hpp"


namespace LIFEO
{


class DialogPreferences : public DialogEvent
{
	public:
		static void				create();
								DialogPreferences(	BaseObjectType*,
													const Glib::RefPtr< Gtk::Builder >& );
		void					handle_response( int );
		void					handle_chkbtn_autologout_toggled( void );
		void					handle_chkbtn_ftoolbar_toggled( void );

	protected:
		static DialogPreferences
								*ptr;
		Gtk::CheckButton		*m_chkbtn_autologout;
		Gtk::HBox				*m_hbox_max_idle_time;
		Gtk::SpinButton			*m_spinbutton_max_idle_time;
		Gtk::CheckButton		*m_chkbtn_bg_image;
		Gtk::FileChooserButton	*m_filebutton_bg_image;
		Gtk::CheckButton		*m_chkbtn_formatting_toolbar;

	private:

};

} // end of namespace LIFEO

#endif

