/***********************************************************************************

	Copyright (C) 2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "dialog_preferences.hpp"

namespace LIFEO
{

// STATIC MEMBERS
DialogPreferences *DialogPreferences::ptr;


DialogPreferences::DialogPreferences(	BaseObjectType* cobject,
										const Glib::RefPtr< Gtk::Builder > &refbuilder )
	:	DialogEvent( cobject, refbuilder )
{
	Lifeobase::builder->get_widget( "hbox_max_idle_time", m_hbox_max_idle_time );
	Lifeobase::builder->get_widget( "checkbutton_autologout", m_checkbox_autologout );
	Lifeobase::builder->get_widget( "spinbutton_max_idle_time", m_spinbutton_max_idle_time );
	Lifeobase::builder->get_widget( "checkbutton_bg_image", m_checkbox_bg_image );
	Lifeobase::builder->get_widget( "filebutton_bg_image", m_filebutton_bg_image );

	m_checkbox_autologout->set_active( Lifeobase::m_settings.autologout );
	m_hbox_max_idle_time->set_sensitive( Lifeobase::m_settings.autologout );
	m_spinbutton_max_idle_time->set_value( Lifeobase::m_settings.idletime );
	if( Lifeobase::m_settings.background == "none" )
	{
		m_checkbox_bg_image->set_active( false );
		m_filebutton_bg_image->set_sensitive( false );
	}
	else
	{
		m_checkbox_bg_image->set_active( true );
		m_filebutton_bg_image->set_filename( Lifeobase::m_settings.background );
	}

	m_checkbox_autologout->signal_toggled().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_checkbox_autologout_toggled ) );
	m_checkbox_bg_image->signal_toggled().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_checkbox_autologout_toggled ) );
	signal_response().connect(
			sigc::mem_fun( *this, &DialogPreferences::handle_response ) );
}

void
DialogPreferences::handle_checkbox_autologout_toggled( void )
{
	m_hbox_max_idle_time->set_sensitive( m_checkbox_autologout->get_active() );
	m_filebutton_bg_image->set_sensitive( m_checkbox_bg_image->get_active() );
}

void
DialogPreferences::handle_response( int )
{
	// APPLY CHANGES
	Lifeobase::m_settings.autologout = m_checkbox_autologout->get_active();
	Lifeobase::m_settings.idletime = m_spinbutton_max_idle_time->get_value_as_int();
	if( m_checkbox_bg_image->get_active() )
	{
		if( Lifeobase::m_settings.background != m_filebutton_bg_image->get_filename() )
		{
			Lifeobase::m_settings.background = m_filebutton_bg_image->get_filename();
			try
			{
				Lifeobase::pixbuf_background =
						Gdk::Pixbuf::create_from_file( Lifeobase::m_settings.background );
			}
			catch( Glib::Error &ex )
			{
				print_error( ex.what() );
				Lifeobase::m_settings.background = "none";
				Lifeobase::pixbuf_background.clear();
			}
		}
	}
	else
	{
		Lifeobase::m_settings.background = "none";
		Lifeobase::pixbuf_background.clear();
	}
}

void
DialogPreferences::create()
{
	// FIXME: for some reason subsequent usages of get_widget_derived causes an...
	// ...empty dialog to be shown
	if( ptr  == NULL )
		Lifeobase::builder->get_widget_derived( "dialog_preferences", ptr );
	ptr->run();
	ptr->hide();
}

}
