#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <parportled.h>

/* Get the current statistics on the cpu */

int cpu(FILE *pstat)
{
  int nidle, nnice, nsystem, nuser;
  int total;
  int user, nice, system, idle;
  static int last_user, last_nice, last_system, last_idle;
  char dummy[1024];

	rewind(pstat);
	
	fscanf(pstat,"%s %d %d %d %d", dummy, &user, &nice, &system, &idle);
	fflush(pstat);

  nidle = idle-last_idle;
  nuser = user-last_user;
  nsystem = system-last_system;
  nnice = nice-last_nice;

  total = nnice + nsystem + nuser + nidle;

	last_nice = nice;
  last_user = user;
  last_system=system;
  last_idle=idle;

	return(total-nidle);
}

int loop(void)
{
  FILE *pstat;
  int load;
  int lights[MAXLED];
  int blink=0;
	
  if(!(pstat = fopen("/proc/stat", "r")))
	{
    fprintf(stderr, "Unable to open /proc/stat\n");
    exit(EXIT_FAILURE);
  }
  
	/* Call cpu() a first time to init counters */
	cpu(pstat); 

	led_off_all();
	
  while(1)
	{
		blink++;
		for(load = 0; load < MAXLED; load++)
			lights[load] = 0;

		load = cpu(pstat) / 1.5; //(12 / (MAXLED - 1));

		while(load > 6) load--;

		for(; load >= 0; load--)
			lights[load] = 1;

		if(blink == 10) { lights[MAXLED-1] = 1; blink = 0; }
	
		led_off_all();
		led_set_on(lights);
		
    usleep(100000);
  }

	fclose(pstat);

  return(0);
}

int main(int argc, char **argv)
{
	pid_t id;

	if((id=fork()) != -1)
	{
		if(id == 0)
		{
			if(led_setperm())
			{
				fprintf(stderr,"Cannot open device, ioperm error.\n");
				exit(EXIT_FAILURE);
			}
			setsid();
      loop();
		}
	}
	else { printf("Could not fork!\n"); exit(EXIT_FAILURE); }
	
  return(EXIT_SUCCESS);
}
