/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "sequencemanager.h"
#include "globals.h"
#include "xmlutils.h"


void
SequenceManager_store_bank(SequenceManager_t *sm, const u_char bank)
{
  assert(bank < MAX_BANKS);
  sm->banks[sm->cur_bankset][bank] = sm->cur->id;
}


void
SequenceManager_use_bankset(SequenceManager_t *sm, const u_char bs)
{
  assert(bs < MAX_BANKS);
  sm->cur_bankset = bs;
}


void
SequenceManager_save_banks(const SequenceManager_t *sm)
{
  xmlDoc *doc;
  xmlNode *node;
  const gchar *home_dir = NULL;
  char *filename;
  int bs, b;

  home_dir = g_get_home_dir();
  filename = g_strdup_printf("%s/." PACKAGE_NAME, home_dir);
  rmkdir(filename);
  g_free(filename);
  filename = g_strdup_printf("%s/." PACKAGE_NAME "/banks.xml", home_dir);

  /* FIXME check return code of xml* functions */
  doc = xmlNewDoc((const xmlChar *)"1.0");
  node = doc->children = xmlNewDocNode(doc, NULL, (const xmlChar *)"banks", NULL);

  for (bs = 0; bs < MAX_BANKS; bs++)
    for (b = 0; b < MAX_BANKS; b++)
      if (sm->banks[bs][b]) {
	char str[20];
	xmlNode *nd;

	memset(str, '\0', 20);
	g_snprintf(str, 19, "%li", sm->banks[bs][b]);

	nd = xmlNewChild(node, NULL, (const xmlChar *)"bank", (const xmlChar *)str);

	memset(str, '\0', 20);
	g_snprintf(str, 19, "%d", bs);
	xmlSetProp(nd, (const xmlChar *)"set", (const xmlChar *)str);

	xml_set_id(nd, b);
      }
  
  xmlKeepBlanksDefault(0);
  xmlSaveFormatFile(filename, doc, 1);
  xmlFreeDoc(doc);
  g_free(filename);
}


void
SequenceManager_load_banks(SequenceManager_t *sm)
{
  xmlDocPtr doc = NULL; /* XmlTree */
  const gchar *home_dir = NULL;
  char *filename;
  xmlNodePtr node = NULL, bank_node = NULL;
  int i, j;

  for (i = 0; i < MAX_BANKS; i++)
    for (j = 0; j < MAX_BANKS; j++)
      sm->banks[i][j] = 0;

  home_dir = g_get_home_dir();
  filename = g_strdup_printf("%s/." PACKAGE_NAME "/banks.xml", home_dir);

  /* BLA ! */
  xmlKeepBlanksDefault(0);
  xmlSubstituteEntitiesDefault(1);

  doc = xmlParseFile(filename);
  g_free(filename);
  if (doc == NULL)
    return;

  node = xmlDocGetRootElement(doc);
  if (node == NULL)
    xerror("Banks: xmlDocGetRootElement error\n");

  node = xmlFindElement("banks", node);
  if (node == NULL)
    xerror("Banks: no <banks> found\n");

  bank_node = node->xmlChildrenNode;
  if (bank_node == NULL) /* Empty banks.xml file */
    return;

  while (bank_node != NULL) {
    long tmp1, tmp2;
    xmlChar *youhou;
    int res;
    long tmp3;

    youhou = xmlGetProp(bank_node, (const xmlChar *)"set");
    tmp1 = getintfield(youhou);
    xmlFree(youhou);
    assert(tmp1 >= 0);
    assert(tmp1 < MAX_BANKS);

    youhou = xmlGetProp(bank_node, (const xmlChar *)"id");
    tmp2 = getintfield(youhou);
    xmlFree(youhou);
    assert(tmp2 >= 0);
    assert(tmp2 < MAX_BANKS);

    res = xmlGetOptionalLong(doc, bank_node, &tmp3);
    if (res == -1)
      xerror("Banks: no value set\n");
    else {
      sm->banks[tmp1][tmp2] = tmp3;
#ifdef DEBUG
      printf("[i] Bankset: %li Bank: %li Sequence id: %li\n", tmp1, tmp2, tmp3);
#endif
    }

    bank_node = bank_node->next;
  }
}
