/**
 * \file script-test-store.c
 *
 * reads an article like text blob from stdin and sends it to
 * store_stream() for inspection and testing of the lua_hooks.
 *
 * see script-lua.c
 *
 * see debugutil.c:
 *
    static const char name[] = "STOP_AT_MESSAGEID";
    if (getenv(name)
	&& 0 == strcasecmp(mid, getenv(name)))
 *
 * clemens fischer <ino-news@spotteswoode.dnsalias.org>
 */

#include "critmem.h"
#include "leafnode.h"
#include "ln_log.h"
#include "mastring.h"
#include "strlcpy.h"

/* DO NOT #include "script.h" (causes duplicate hook entries) */
#include "script.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <errno.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

/*
  Read an article from input stream and store it into message.id and
  link it into the newsgroups.
 \return
 -  0 for success
 - -1 for OS error
 - -2 if duplicate
 - -3 if required header missing or duplicate
 - -4 if short read or data leftover (with maxbytes)
 -  1 if article killed by filter
 -  2 if article dropped by other reason (no valid newsgroups)

store.c::store_stream(FILE * in (means input file),
	     int nntpmode ( 1: unescape '.' and use '.' as end marker ),
	     const struct filterlist *f (filters or NULL),
	     ssize_t maxbytes (maximum byte count, -1 == unlimited),
	     int delayflg (delayed download:
			    0 == no, full article,
			    1 == yes, pseudo head
			    2 == yes, full article
			    3 == no, but article is from in.coming
			         and we have a message.id link)
	)
returns int

#define BAIL(r,msg) { rc = (r); if (*msg) ln_log(LNLOG_SERR, LNLOG_CARTICLE, ("store: " msg)); goto bail; }

*/

#define TEST_FN_DOWNLOAD_MODE 0

/*char *spooldir __attribute__((__weak__)) = "/news/";*/
void script_test_setglobals(void);
void script_test_setglobals(void)
{
    const char * host = "spotteswoode.dnsalias.org";
    const char * func = "script_test_setglobals";
    spooldir = critstrdup("/news/", func);
    localgroups = critstrdup("/etc/leafnode/local.groups", func);
    (void) strlcpy((char *) fqdn, host, strlen(host)+1);
}

int
main(int argc __unused, char * argv[])
{
    int rc; /* return code */
    script_return_t script_return;

    script_test_setglobals();
#if defined(SCRIPT_DEBUG)
    fprintf(stderr, "spooldir: >%s<\n", spooldir);
#endif
    rereadactive();
    /*readactive();*/

    (void) script_init_ready(0);
    script_return = script_fn_init();
    switch ((unsigned int) script_return)
    {
        case SCRIPT_UNAVAILABLE:
        case SCRIPT_NOERROR:
            (void) script_init_ready(1);
            break;
        case SCRIPT_WRONG_RESULT:
            (void) script_init_ready(0);
            ln_log(LNLOG_SINFO, LNLOG_CTOP,
               "script_fn_init returns wrong result or cannot init backend");
            /* currently, user script errors are ignored */
            break;
        default:
            if ((unsigned int) script_return > SCRIPT_STATUS_MAX) {
                ln_log(LNLOG_SINFO, LNLOG_CTOP,
                        "%s: script error %s", argv[0], script_return);
            } else {
                ln_log(LNLOG_SINFO, LNLOG_CTOP,
                        "%s: script error SCRIPT_ERROR_UNSPEC", argv[0]);
            }
    }

    script_return = script_fn_init_group(argv[1]);
    switch ((unsigned int) script_return)
    {
        case SCRIPT_NOERROR:
            break;
        case SCRIPT_IGNORE_GROUP:
            return 0;
        case SCRIPT_WRONG_RESULT:
            ln_log(LNLOG_SINFO, LNLOG_CTOP,
               "script_fn_init_group %s: returns wrong result type",
               argv[1]);
            /* currently, user script errors are ignored */
            break;
        default:
            if ((unsigned int) script_return > SCRIPT_STATUS_MAX) {
                ln_log(LNLOG_SINFO, LNLOG_CTOP,
                       "%s: script error %s", argv[1], script_return);
            } else {
                ln_log(LNLOG_SINFO, LNLOG_CTOP,
                       "%s: script error SCRIPT_ERROR_UNSPEC", argv[1]);
            }
    }

    rc = store_stream(stdin, 1, NULL, -1, TEST_FN_DOWNLOAD_MODE);
    (void) script_fn_finish(rc);
    exit(rc);
}

