/* build_tool_dialog.c generated by valac 0.12.1, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())
typedef struct _BuildToolDialogIconColumn BuildToolDialogIconColumn;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))

struct _BuildToolDialog {
	GtkDialog parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GtkDialogClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkEntry* entry_label;
	GtkEntry* entry_desc;
	GtkEntry* entry_extensions;
	GtkComboBox* combobox_icon;
	GtkEntry* entry_command;
	GtkButton* button_add;
	GtkTreeView* treeview_jobs;
	GtkButton* button_delete;
	GtkButton* button_up;
	GtkButton* button_down;
	GtkListStore* jobs_store;
};

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

struct _BuildToolDialogIconColumn {
	gchar* stock_id;
	gchar* label;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};


static gpointer build_tool_dialog_parent_class = NULL;
static BuildToolDialog* build_tool_dialog_instance;
static BuildToolDialog* build_tool_dialog_instance = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
enum  {
	BUILD_TOOL_DIALOG_DUMMY_PROPERTY
};
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_UNUSED;
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest);
static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self);
static BuildToolDialog* build_tool_dialog_new (void);
static BuildToolDialog* build_tool_dialog_construct (GType object_type);
static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_actions (BuildToolDialog* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void _lambda86_ (void);
static void __lambda86__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void build_tool_dialog_init (BuildToolDialog* self, gint num);
static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num);
GType post_processor_type_get_type (void) G_GNUC_CONST;
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
static void _lambda80_ (const gchar* path_string, const gchar* new_text, BuildToolDialog* self);
static void __lambda80__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void _lambda81_ (const gchar* path_string, BuildToolDialog* self);
static void __lambda81__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void _lambda82_ (const gchar* path_string, const gchar* new_text, BuildToolDialog* self);
static void __lambda82__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void build_tool_dialog_on_command_add (BuildToolDialog* self);
static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda83_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void __lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda84_ (BuildToolDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void __lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda85_ (BuildToolDialog* self);
static void __lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
BuildTool* build_tools_get (BuildTools* self, gint id);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
void build_tools_add (BuildTools* self, BuildTool* tool);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static void build_tool_dialog_finalize (GObject* obj);

static const BuildToolDialogIconColumn BUILD_TOOL_DIALOG_icons[9] = {{GTK_STOCK_EXECUTE, "Execute"}, {"compile_dvi", "LaTeX → DVI"}, {"compile_pdf", "LaTeX → PDF"}, {"compile_ps", "LaTeX → PS"}, {GTK_STOCK_CONVERT, "Convert"}, {GTK_STOCK_FILE, "View File"}, {"view_dvi", "View DVI"}, {"view_pdf", "View PDF"}, {"view_ps", "View PS"}};

static GType build_tool_dialog_job_column_get_type (void) {
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, "BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED", "must-succeed"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BuildToolDialog* build_tool_dialog_construct (GType object_type) {
	BuildToolDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp3_ = NULL;
	GtkVBox* _tmp4_;
	GtkVBox* main_vbox;
	GObject* _tmp5_ = NULL;
	GtkEntry* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkEntry* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkEntry* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkComboBox* _tmp12_;
	GObject* _tmp13_ = NULL;
	GtkEntry* _tmp14_;
	GObject* _tmp15_ = NULL;
	GtkButton* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkTreeView* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkButton* _tmp20_;
	GObject* _tmp21_ = NULL;
	GtkButton* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkButton* _tmp24_;
	GtkWidget* _tmp25_ = NULL;
	GtkBox* _tmp26_;
	GtkBox* content_area;
	GError * _inner_error_ = NULL;
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	_tmp0_ = _ ("Build Tool");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	_tmp1_ = g_build_filename (DATA_DIR, "ui", "build_tool.ui", NULL);
	path = _tmp1_;
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	gtk_builder_add_from_file (builder, path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_free0 (path);
		goto __catch28_g_error;
	}
	_tmp3_ = gtk_builder_get_object (builder, "main_vbox");
	_tmp4_ = _g_object_ref0 (GTK_VBOX (_tmp3_));
	main_vbox = _tmp4_;
	gtk_widget_unparent ((GtkWidget*) main_vbox);
	_tmp5_ = gtk_builder_get_object (builder, "entry_label");
	_tmp6_ = _g_object_ref0 (GTK_ENTRY (_tmp5_));
	_g_object_unref0 (self->priv->entry_label);
	self->priv->entry_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "entry_desc");
	_tmp8_ = _g_object_ref0 (GTK_ENTRY (_tmp7_));
	_g_object_unref0 (self->priv->entry_desc);
	self->priv->entry_desc = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "entry_extensions");
	_tmp10_ = _g_object_ref0 (GTK_ENTRY (_tmp9_));
	_g_object_unref0 (self->priv->entry_extensions);
	self->priv->entry_extensions = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "combobox_icon");
	_tmp12_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp11_));
	_g_object_unref0 (self->priv->combobox_icon);
	self->priv->combobox_icon = _tmp12_;
	_tmp13_ = gtk_builder_get_object (builder, "entry_command");
	_tmp14_ = _g_object_ref0 (GTK_ENTRY (_tmp13_));
	_g_object_unref0 (self->priv->entry_command);
	self->priv->entry_command = _tmp14_;
	_tmp15_ = gtk_builder_get_object (builder, "button_add");
	_tmp16_ = _g_object_ref0 (GTK_BUTTON (_tmp15_));
	_g_object_unref0 (self->priv->button_add);
	self->priv->button_add = _tmp16_;
	_tmp17_ = gtk_builder_get_object (builder, "treeview_jobs");
	_tmp18_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp17_));
	_g_object_unref0 (self->priv->treeview_jobs);
	self->priv->treeview_jobs = _tmp18_;
	_tmp19_ = gtk_builder_get_object (builder, "button_delete");
	_tmp20_ = _g_object_ref0 (GTK_BUTTON (_tmp19_));
	_g_object_unref0 (self->priv->button_delete);
	self->priv->button_delete = _tmp20_;
	_tmp21_ = gtk_builder_get_object (builder, "button_up");
	_tmp22_ = _g_object_ref0 (GTK_BUTTON (_tmp21_));
	_g_object_unref0 (self->priv->button_up);
	self->priv->button_up = _tmp22_;
	_tmp23_ = gtk_builder_get_object (builder, "button_down");
	_tmp24_ = _g_object_ref0 (GTK_BUTTON (_tmp23_));
	_g_object_unref0 (self->priv->button_down);
	self->priv->button_down = _tmp24_;
	_tmp25_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp26_ = _g_object_ref0 (GTK_BOX (_tmp25_));
	content_area = _tmp26_;
	gtk_box_pack_start (content_area, (GtkWidget*) main_vbox, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	build_tool_dialog_init_icon_treeview (self);
	build_tool_dialog_init_jobs_treeview (self);
	build_tool_dialog_init_actions (self);
	_g_object_unref0 (content_area);
	_g_object_unref0 (main_vbox);
	_g_object_unref0 (builder);
	_g_free0 (path);
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		gchar* _tmp27_ = NULL;
		gchar* message;
		GtkLabel* _tmp28_ = NULL;
		GtkLabel* label_error;
		GtkWidget* _tmp29_ = NULL;
		GtkBox* _tmp30_;
		GtkBox* content_area;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = g_strdup_printf ("Error: %s", e->message);
		message = _tmp27_;
		g_warning ("build_tool_dialog.vala:109: %s", message);
		_tmp28_ = (GtkLabel*) gtk_label_new (message);
		label_error = g_object_ref_sink (_tmp28_);
		gtk_label_set_line_wrap (label_error, TRUE);
		_tmp29_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp30_ = _g_object_ref0 (GTK_BOX (_tmp29_));
		content_area = _tmp30_;
		gtk_box_pack_start (content_area, (GtkWidget*) label_error, TRUE, TRUE, (guint) 0);
		gtk_widget_show_all ((GtkWidget*) content_area);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static BuildToolDialog* build_tool_dialog_new (void) {
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG);
}


static void _lambda86_ (void) {
	if (build_tool_dialog_instance != NULL) {
		_g_object_unref0 (build_tool_dialog_instance);
		build_tool_dialog_instance = NULL;
	}
}


static void __lambda86__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda86_ ();
}


gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num) {
	gboolean result = FALSE;
	GtkWindow* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_val_if_fail (parent != NULL, FALSE);
	if (build_tool_dialog_instance == NULL) {
		BuildToolDialog* _tmp0_ = NULL;
		_tmp0_ = build_tool_dialog_new ();
		_g_object_unref0 (build_tool_dialog_instance);
		build_tool_dialog_instance = g_object_ref_sink (_tmp0_);
		g_signal_connect ((GtkObject*) build_tool_dialog_instance, "destroy", (GCallback) __lambda86__gtk_object_destroy, NULL);
	}
	_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) build_tool_dialog_instance);
	if (parent != _tmp1_) {
		gtk_window_set_transient_for ((GtkWindow*) build_tool_dialog_instance, parent);
	}
	gtk_window_present ((GtkWindow*) build_tool_dialog_instance);
	build_tool_dialog_init (build_tool_dialog_instance, num);
	_tmp2_ = build_tool_dialog_run_me (build_tool_dialog_instance, num);
	result = _tmp2_;
	return result;
}


static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* icon_store;
	GtkCellRendererPixbuf* _tmp5_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp6_ = NULL;
	GtkCellRendererText* text_renderer;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	icon_store = _tmp0_;
	{
		BuildToolDialogIconColumn* icon_collection;
		int icon_collection_length1;
		int icon_it;
		icon_collection = BUILD_TOOL_DIALOG_icons;
		icon_collection_length1 = G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons); icon_it = icon_it + 1) {
			BuildToolDialogIconColumn _tmp1_;
			BuildToolDialogIconColumn _tmp2_ = {0};
			BuildToolDialogIconColumn icon;
			build_tool_dialog_icon_column_copy (&icon_collection[icon_it], &_tmp2_);
			_tmp1_ = _tmp2_;
			icon = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp3_ = {0};
				const gchar* _tmp4_ = NULL;
				gtk_list_store_append (icon_store, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = _ (icon.label);
				gtk_list_store_set (icon_store, &iter, 0, icon.stock_id, 1, _tmp4_, -1, -1);
				build_tool_dialog_icon_column_destroy (&icon);
			}
		}
	}
	gtk_combo_box_set_model (self->priv->combobox_icon, (GtkTreeModel*) icon_store);
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp5_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) pixbuf_renderer, "stock-id", 0, NULL, NULL);
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp6_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_icon, (GtkCellRenderer*) text_renderer, "text", 1, NULL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (icon_store);
}


static void _lambda80_ (const gchar* path_string, const gchar* new_text, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &_tmp0_, path_string);
	iter = _tmp0_;
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, new_text, -1, -1);
}


static void __lambda80__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	_lambda80_ (path, new_text, self);
}


static void _lambda81_ (const gchar* path_string, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean val = FALSE;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	g_return_if_fail (path_string != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &_tmp0_, path_string);
	iter = _tmp0_;
	_tmp1_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->jobs_store));
	model = _tmp1_;
	gtk_tree_model_get (model, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &val, -1, -1);
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, !val, -1, -1);
	_g_object_unref0 (model);
}


static void __lambda81__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda81_ (path, self);
}


static void _lambda82_ (const gchar* path_string, const gchar* new_text, BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->jobs_store, &_tmp0_, path_string);
	iter = _tmp0_;
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, new_text, -1, -1);
}


static void __lambda82__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	_lambda82_ (path, new_text, self);
}


static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkListStore* post_processor_store;
	GtkCellRendererText* _tmp6_ = NULL;
	GtkCellRendererText* text_renderer;
	const gchar* _tmp7_ = NULL;
	GtkTreeViewColumn* _tmp8_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererToggle* _tmp9_ = NULL;
	GtkCellRendererToggle* toggle_renderer;
	const gchar* _tmp10_ = NULL;
	GtkCellRendererCombo* _tmp11_ = NULL;
	GtkCellRendererCombo* combo_renderer;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING);
	_g_object_unref0 (self->priv->jobs_store);
	self->priv->jobs_store = _tmp0_;
	gtk_tree_view_set_model (self->priv->treeview_jobs, (GtkTreeModel*) self->priv->jobs_store);
	_tmp1_ = gtk_list_store_new (1, G_TYPE_STRING);
	post_processor_store = _tmp1_;
	{
		gint type;
		type = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				GtkTreeIter iterpp = {0};
				GtkTreeIter _tmp3_ = {0};
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				if (!_tmp2_) {
					type++;
				}
				_tmp2_ = FALSE;
				if (!(type < POST_PROCESSOR_TYPE_N_POST_PROCESSORS)) {
					break;
				}
				gtk_list_store_append (post_processor_store, &_tmp3_);
				iterpp = _tmp3_;
				_tmp4_ = build_tools_get_post_processor_name_from_type ((PostProcessorType) type);
				_tmp5_ = _tmp4_;
				gtk_list_store_set (post_processor_store, &iterpp, 0, _tmp5_, -1, -1);
				_g_free0 (_tmp5_);
			}
		}
	}
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp6_);
	g_object_set (text_renderer, "editable", TRUE, NULL);
	_tmp7_ = _ ("Commands");
	_tmp8_ = gtk_tree_view_column_new_with_attributes (_tmp7_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL, NULL);
	column = g_object_ref_sink (_tmp8_);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_append_column (self->priv->treeview_jobs, column);
	_tmp9_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	toggle_renderer = g_object_ref_sink (_tmp9_);
	gtk_cell_renderer_toggle_set_activatable (toggle_renderer, TRUE);
	_tmp10_ = _ ("Must Succeed");
	gtk_tree_view_insert_column_with_attributes (self->priv->treeview_jobs, -1, _tmp10_, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, NULL, NULL);
	_tmp11_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
	combo_renderer = g_object_ref_sink (_tmp11_);
	g_object_set ((GtkCellRendererText*) combo_renderer, "editable", TRUE, NULL);
	g_object_set (combo_renderer, "model", (GtkTreeModel*) post_processor_store, NULL);
	g_object_set (combo_renderer, "text-column", 0, NULL);
	g_object_set (combo_renderer, "has-entry", FALSE, NULL);
	_tmp12_ = _ ("Post Processor");
	gtk_tree_view_insert_column_with_attributes (self->priv->treeview_jobs, -1, _tmp12_, (GtkCellRenderer*) combo_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL, NULL);
	g_signal_connect_object (text_renderer, "edited", (GCallback) __lambda80__gtk_cell_renderer_text_edited, self, 0);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) __lambda81__gtk_cell_renderer_toggle_toggled, self, 0);
	g_signal_connect_object ((GtkCellRendererText*) combo_renderer, "edited", (GCallback) __lambda82__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (post_processor_store);
}


static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _lambda83_ (BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	_tmp1_ = utils_get_selected_row (self->priv->treeview_jobs, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		gtk_list_store_remove (self->priv->jobs_store, &iter);
	}
}


static void __lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda83_ (self);
}


static void _lambda84_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	gboolean _tmp2_ = FALSE;
	_tmp1_ = utils_get_selected_row (self->priv->treeview_jobs, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		_tmp2_ = i > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_;
		iter2 = iter1;
		_tmp3_ = utils_tree_model_iter_prev ((GtkTreeModel*) self->priv->jobs_store, &iter2);
		if (_tmp3_) {
			gtk_list_store_swap (self->priv->jobs_store, &iter1, &iter2);
		}
	}
}


static void __lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda84_ (self);
}


static void _lambda85_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	_tmp1_ = utils_get_selected_row (self->priv->treeview_jobs, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		gboolean _tmp2_;
		iter2 = iter1;
		_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->jobs_store, &iter2);
		if (_tmp2_) {
			gtk_list_store_swap (self->priv->jobs_store, &iter1, &iter2);
		}
	}
}


static void __lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda85_ (self);
}


static void build_tool_dialog_init_actions (BuildToolDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->priv->button_add, "clicked", (GCallback) _build_tool_dialog_on_command_add_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->entry_command, "activate", (GCallback) _build_tool_dialog_on_command_add_gtk_entry_activate, self, 0);
	g_signal_connect_object (self->priv->button_delete, "clicked", (GCallback) __lambda83__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_up, "clicked", (GCallback) __lambda84__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_down, "clicked", (GCallback) __lambda85__gtk_button_clicked, self, 0);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void build_tool_dialog_on_command_add (BuildToolDialog* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->entry_command);
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	gtk_list_store_append (self->priv->jobs_store, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = gtk_entry_get_text (self->priv->entry_command);
	_tmp6_ = build_tools_get_post_processor_name_from_type (POST_PROCESSOR_TYPE_NO_OUTPUT);
	_tmp7_ = _tmp6_;
	gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp5_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, TRUE, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp7_, -1, -1);
	_g_free0 (_tmp7_);
	gtk_entry_set_text (self->priv->entry_command, "");
}


static void build_tool_dialog_init (BuildToolDialog* self, gint num) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_command, "");
	gtk_list_store_clear (self->priv->jobs_store);
	utils_set_entry_error ((GtkWidget*) self->priv->entry_label, FALSE);
	utils_set_entry_error ((GtkWidget*) self->priv->entry_command, FALSE);
	if (num == (-1)) {
		build_tool_dialog_init_new_build_tool (build_tool_dialog_instance);
	} else {
		BuildTools* _tmp0_ = NULL;
		BuildTools* _tmp1_;
		BuildTool* _tmp2_ = NULL;
		BuildTool* _tmp3_;
		_tmp0_ = build_tools_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = build_tools_get (_tmp1_, num);
		_tmp3_ = _tmp2_;
		build_tool_dialog_init_with_build_tool (build_tool_dialog_instance, _tmp3_);
		_build_tool_free0 (_tmp3_);
		_build_tools_unref0 (_tmp1_);
	}
	gtk_tree_view_columns_autosize (self->priv->treeview_jobs);
}


static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_label, "");
	gtk_entry_set_text (self->priv->entry_desc, "");
	gtk_entry_set_text (self->priv->entry_extensions, ".tex");
	gtk_combo_box_set_active (self->priv->combobox_icon, 0);
}


static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry_label, (*tool).label);
	gtk_entry_set_text (self->priv->entry_desc, (*tool).description);
	gtk_entry_set_text (self->priv->entry_extensions, (*tool).extensions);
	gtk_combo_box_set_active (self->priv->combobox_icon, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons))) {
					break;
				}
				if (g_strcmp0 (BUILD_TOOL_DIALOG_icons[i].stock_id, (*tool).icon) == 0) {
					gtk_combo_box_set_active (self->priv->combobox_icon, i);
					break;
				}
			}
		}
	}
	gtk_list_store_clear (self->priv->jobs_store);
	{
		GList* job_collection;
		GList* job_it;
		job_collection = (*tool).jobs;
		for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
			BuildJob _tmp1_;
			BuildJob _tmp2_ = {0};
			BuildJob job;
			build_job_copy ((BuildJob*) job_it->data, &_tmp2_);
			_tmp1_ = _tmp2_;
			job = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp3_ = {0};
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gtk_list_store_append (self->priv->jobs_store, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = build_tools_get_post_processor_name_from_type (job.post_processor);
				_tmp5_ = _tmp4_;
				gtk_list_store_set (self->priv->jobs_store, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, job.command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp5_, -1, -1);
				_g_free0 (_tmp5_);
				build_job_destroy (&job);
			}
		}
	}
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		gint _tmp0_;
		gboolean ok;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gboolean _tmp4_;
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp5_ = {0};
		gboolean _tmp6_;
		BuildTool tool = {0};
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gboolean _tmp13_;
		gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
		GtkTreeModel* _tmp21_ = NULL;
		GtkTreeModel* _tmp22_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp23_ = NULL;
		GtkTreeModel* _tmp24_;
		GtkTreeIter _tmp25_ = {0};
		gboolean _tmp26_;
		gboolean valid;
		_tmp0_ = gtk_dialog_run ((GtkDialog*) self);
		if (!(_tmp0_ == GTK_RESPONSE_OK)) {
			break;
		}
		ok = TRUE;
		_tmp1_ = gtk_entry_get_text (self->priv->entry_label);
		_tmp2_ = string_strip (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_label, TRUE);
			ok = FALSE;
		} else {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_label, FALSE);
		}
		_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->jobs_store, &_tmp5_);
		iter = _tmp5_;
		if (!_tmp6_) {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_command, TRUE);
			ok = FALSE;
		} else {
			utils_set_entry_error ((GtkWidget*) self->priv->entry_command, FALSE);
		}
		if (!ok) {
			continue;
		}
		memset (&tool, 0, sizeof (BuildTool));
		_tmp7_ = gtk_entry_get_text (self->priv->entry_label);
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (tool.label);
		tool.label = _tmp8_;
		_tmp10_ = gtk_entry_get_text (self->priv->entry_desc);
		_tmp11_ = string_strip (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp12_, "") == 0;
		_g_free0 (_tmp12_);
		if (_tmp13_) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup (tool.label);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp14_;
		} else {
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			_tmp15_ = gtk_entry_get_text (self->priv->entry_desc);
			_tmp16_ = string_strip (_tmp15_);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp16_;
		}
		_tmp17_ = g_strdup (_tmp9_);
		_g_free0 (tool.description);
		tool.description = _tmp17_;
		_tmp18_ = gtk_entry_get_text (self->priv->entry_extensions);
		_tmp19_ = string_strip (_tmp18_);
		_g_free0 (tool.extensions);
		tool.extensions = _tmp19_;
		gtk_combo_box_get_active_iter (self->priv->combobox_icon, &_tmp20_);
		iter = _tmp20_;
		_tmp21_ = gtk_combo_box_get_model (self->priv->combobox_icon);
		_tmp22_ = _g_object_ref0 (_tmp21_);
		model = _tmp22_;
		gtk_tree_model_get (model, &iter, 0, &tool.icon, -1, -1);
		_tmp23_ = gtk_tree_view_get_model (self->priv->treeview_jobs);
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_g_object_unref0 (model);
		model = _tmp24_;
		_tmp26_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->jobs_store, &_tmp25_);
		iter = _tmp25_;
		valid = _tmp26_;
		while (TRUE) {
			BuildJob job = {0};
			gchar* command = NULL;
			gchar* post_processor_name = NULL;
			gchar* _tmp27_ = NULL;
			PostProcessorType* _tmp28_ = NULL;
			PostProcessorType* _tmp29_;
			BuildJob* _tmp30_;
			gboolean _tmp31_;
			if (!valid) {
				break;
			}
			memset (&job, 0, sizeof (BuildJob));
			gtk_tree_model_get (model, &iter, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &post_processor_name, -1, -1);
			_tmp27_ = string_strip (command);
			_g_free0 (job.command);
			job.command = _tmp27_;
			_tmp28_ = build_tools_get_post_processor_type_from_name (post_processor_name);
			_tmp29_ = _tmp28_;
			job.post_processor = *_tmp29_;
			_g_free0 (_tmp29_);
			_tmp30_ = _build_job_dup0 (&job);
			tool.jobs = g_list_append (tool.jobs, _tmp30_);
			_tmp31_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->jobs_store, &iter);
			valid = _tmp31_;
			_g_free0 (post_processor_name);
			_g_free0 (command);
			build_job_destroy (&job);
		}
		if (num == (-1)) {
			BuildTools* _tmp32_ = NULL;
			BuildTools* _tmp33_;
			tool.show = TRUE;
			_tmp32_ = build_tools_get_default ();
			_tmp33_ = _tmp32_;
			build_tools_add (_tmp33_, &tool);
			_build_tools_unref0 (_tmp33_);
		} else {
			BuildTools* _tmp34_ = NULL;
			BuildTools* _tmp35_;
			_tmp34_ = build_tools_get_default ();
			_tmp35_ = _tmp34_;
			build_tools_update (_tmp35_, num, &tool, TRUE);
			_build_tools_unref0 (_tmp35_);
		}
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (model);
		_g_free0 (_tmp9_);
		build_tool_destroy (&tool);
		return result;
	}
	gtk_widget_hide ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest) {
	dest->stock_id = g_strdup (self->stock_id);
	dest->label = g_strdup (self->label);
}


static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self) {
	_g_free0 ((*self).stock_id);
	_g_free0 ((*self).label);
}


static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self) {
	BuildToolDialogIconColumn* dup;
	dup = g_new0 (BuildToolDialogIconColumn, 1);
	build_tool_dialog_icon_column_copy (self, dup);
	return dup;
}


static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self) {
	build_tool_dialog_icon_column_destroy (self);
	g_free (self);
}


static GType build_tool_dialog_icon_column_get_type (void) {
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_boxed_type_register_static ("BuildToolDialogIconColumn", (GBoxedCopyFunc) build_tool_dialog_icon_column_dup, (GBoxedFreeFunc) build_tool_dialog_icon_column_free);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static void build_tool_dialog_class_init (BuildToolDialogClass * klass) {
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}


static void build_tool_dialog_instance_init (BuildToolDialog * self) {
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
}


static void build_tool_dialog_finalize (GObject* obj) {
	BuildToolDialog * self;
	self = BUILD_TOOL_DIALOG (obj);
	_g_object_unref0 (self->priv->entry_label);
	_g_object_unref0 (self->priv->entry_desc);
	_g_object_unref0 (self->priv->entry_extensions);
	_g_object_unref0 (self->priv->combobox_icon);
	_g_object_unref0 (self->priv->entry_command);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->treeview_jobs);
	_g_object_unref0 (self->priv->button_delete);
	_g_object_unref0 (self->priv->button_up);
	_g_object_unref0 (self->priv->button_down);
	_g_object_unref0 (self->priv->jobs_store);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}


GType build_tool_dialog_get_type (void) {
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}



