/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FLOSS_H
#define FLOSS_H

#include <qstring.h>
#include <qcolor.h>

/** Stores the details of a particular floss color derived from the currently selected palette.
    It can be added directly to the floss palette for the pattern, and is used as a base for a
    QListBoxItem that can be added to the color selection dialog.
    @author Stephen Allewell
  */
class Floss {
public:
  /** Constructor
      @param n QString name of the color
      @param d QString description of the color
      @param c QColor color
    */
  Floss(QString n, QString d, QColor c) : name(n),description(d),color(c) {};

  QString name;
  QString description;
  QColor  color;
};

#endif
