/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <kapplication.h>
#include <knuminput.h>
#include <kcolorbutton.h>
#include <kurlrequester.h>
#include <kfontcombo.h>
#include <kdebug.h>
#include "configuration.h"
#include "configurationdialog.h"
#include "schememanager.h"

ConfigurationDialog::ConfigurationDialog(QWidget *parent)
  : ConfigurationDlg(parent, "ConfigDialog", true)
{
  Editor_ShowStitches->setChecked(KXSConfig().Editor_ShowStitches);
  Configuration::setComboBoxItem(Editor_StitchesAs,KXSConfig().Editor_StitchesAs);
  Editor_SymbolFont->setCurrentFont(KXSConfig().Editor_SymbolFont);
  Editor_ShowBackstitches->setChecked(KXSConfig().Editor_ShowBackstitches);
  Configuration::setComboBoxItem(Editor_BackstitchesAs,KXSConfig().Editor_BackstitchesAs);
  Editor_ShowGrid->setChecked(KXSConfig().Editor_ShowGrid);
  Editor_CellSize->setValue(KXSConfig().Editor_CellSize);
  Editor_CellGrouping->setValue(KXSConfig().Editor_CellGrouping);
  Editor_GridMajorColor->setColor(KXSConfig().Editor_GridMajorColor);
  Editor_GridMinorColor->setColor(KXSConfig().Editor_GridMinorColor);
  Editor_ShowScales->setChecked(KXSConfig().Editor_ShowScales);
  Editor_ScaleSize->setValue(KXSConfig().Editor_ScaleSize);
  Configuration::setComboBoxItem(Editor_ScaleFormat,KXSConfig().Editor_ScaleFormat);
  connect(HelpButton,SIGNAL(clicked()),this,SLOT(slotContextHelp()));
}

ConfigurationDialog::~ConfigurationDialog()
{
}

void ConfigurationDialog::accept()
{
  // write settings back to configuration object
  KXSConfig().Editor_ShowStitches = Editor_ShowStitches->isChecked();
  KXSConfig().Editor_StitchesAs = Editor_StitchesAs->currentText();
  KXSConfig().Editor_SymbolFont = Editor_SymbolFont->currentText();
  KXSConfig().Editor_ShowBackstitches = Editor_ShowBackstitches->isChecked();
  KXSConfig().Editor_BackstitchesAs = Editor_BackstitchesAs->currentText();
  KXSConfig().Editor_ShowGrid = Editor_ShowGrid->isChecked();
  KXSConfig().Editor_CellSize = Editor_CellSize->value();
  KXSConfig().Editor_CellGrouping = Editor_CellGrouping->value();
  KXSConfig().Editor_GridMajorColor = Editor_GridMajorColor->color();
  KXSConfig().Editor_GridMinorColor = Editor_GridMinorColor->color();
  KXSConfig().Editor_ShowScales = Editor_ShowScales->isChecked();
  KXSConfig().Editor_ScaleSize = Editor_ScaleSize->value();
  KXSConfig().Editor_ScaleFormat = Editor_ScaleFormat->currentText();

  // and write the configuration objects data to the KConfig object
  KXSConfig().writeSettings();

  // call the base QDialog::accept function to close the dialog correctly
  QDialog::accept();
}

void ConfigurationDialog::slotContextHelp()
{
  kapp->invokeHelp("ConfigurationDialog");
}
