/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilenetworkrouteoptions.h"

#include <qcheckbox.h>
#include <klineedit.h>
#include <klistview.h>
#include <qpushbutton.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <qstring.h>
#include <klocale.h>

#include <iostream>

#include "addnetworkroutedialog.h"

ProfileNetworkRouteOptions::ProfileNetworkRouteOptions(QWidget *parent)
		: ProfileNetworkRouteOptionsBase(parent)
{
	checkList();
}


ProfileNetworkRouteOptions::~ProfileNetworkRouteOptions()
{
}

void ProfileNetworkRouteOptions::additionalNetworkRoutesToggled(bool)
{
	if (UseExtraNetworkRoutesCheckbox->isChecked())
	{
		NetworkListView->setEnabled(TRUE);
		AddRoutePushButton->setEnabled(TRUE);
		checkList();
	}
	else
	{
		NetworkListView->setEnabled(FALSE);
		DeleteNetworkRoutePushButton->setEnabled(FALSE);
		AddRoutePushButton->setEnabled(FALSE);
	}
}

void ProfileNetworkRouteOptions::delNetworkRouteClicked()
{
	if ( NetworkListView->childCount() > 0 && NetworkListView->currentItem()!= 0 )
	{
		QListViewItem *item = NetworkListView->currentItem();
		QString Network = item->text(0);
		QString Netmask = item->text(1);
		int result = KMessageBox::questionYesNo ( this, i18n( "Do you really want to delete the network \"%1/%2\"?" ).arg( Network ).arg(Netmask), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{
			NetworkListView->removeItem(item);
		}
		checkList();
	}
}


void ProfileNetworkRouteOptions::addNetworkRouteClicked()
{
	AddNetworkRouteDialog dlg(this, i18n("Add Network Route..."));

	
	dlg.main->InterfaceComboBox->insertItem("default"); // interface where default route points

	//FIXME
	dlg.main->InterfaceComboBox->insertItem("eth0");
	dlg.main->InterfaceComboBox->insertItem("eth1");
	dlg.main->InterfaceComboBox->insertItem("eth2");
	dlg.main->InterfaceComboBox->insertItem("ipsec0");
	dlg.main->InterfaceComboBox->insertItem("tun0");
	dlg.main->InterfaceComboBox->insertItem("ppp0");

	if (dlg.exec())
	{
		QString gateway = dlg.getGateway();
		QString interface = dlg.getInterface();
		if (!dlg.getUseGateway())
			gateway="-";
		if (!dlg.getUseInterface())
			interface="-";
		NetworkListView->insertItem( new QListViewItem(NetworkListView, dlg.getNetwork(),dlg.getNetmask(), gateway,interface));
	}
	checkList();
}


void ProfileNetworkRouteOptions::editNetworkRouteClicked()
{

	if ( NetworkListView->childCount() > 0 && NetworkListView->currentItem()!= 0 )
	{
		AddNetworkRouteDialog dlg(this, i18n("Edit Network Route..."));
		QString Network=NetworkListView->currentItem()->text(0);
		QString Netmask=NetworkListView->currentItem()->text(1);
		QString Gateway=NetworkListView->currentItem()->text(2);
		QString Interface=NetworkListView->currentItem()->text(3);
		
		
		dlg.main->InterfaceComboBox->insertItem("default"); // interface where default route points
	
		//FIXME
		dlg.main->InterfaceComboBox->insertItem("eth0");
		dlg.main->InterfaceComboBox->insertItem("eth1");
		dlg.main->InterfaceComboBox->insertItem("eth2");
		dlg.main->InterfaceComboBox->insertItem("ipsec0");
		dlg.main->InterfaceComboBox->insertItem("tun0");
		dlg.main->InterfaceComboBox->insertItem("ppp0");

		dlg.main->RemoteNetAddrLineEdit->setText(Network);

		if (!Gateway.isEmpty() && Gateway != "-")
		{
			dlg.main->RemoteGatewayAddrLineEdit->setText(Gateway);
			dlg.main->UseGatewayCheckBox->setChecked(true);
		}
		else
			dlg.main->UseGatewayCheckBox->setChecked(false);

		if (!Interface.isEmpty() && Interface!="-")
		{
			dlg.main->InterfaceComboBox->setCurrentText(Interface);
			dlg.main->UseInterfaceCheckBox->setChecked(true);
		}
		else
			dlg.main->UseInterfaceCheckBox->setChecked(false);	

		if (dlg.exec())
		{
			QString gateway = dlg.getGateway();
			QString interface = dlg.getInterface();
			if (!dlg.getUseGateway())
				gateway="-";
			if (!dlg.getUseInterface())
				interface="-";

			NetworkListView->takeItem(NetworkListView->currentItem());
			NetworkListView->insertItem( new QListViewItem(NetworkListView, dlg.getNetwork(),dlg.getNetmask(), gateway,interface));

// 			NetworkListView->currentItem()->text(0) = dlg.getNetwork();
// 			NetworkListView->currentItem()->text(1) = dlg.getNetmask();
// 			NetworkListView->currentItem()->text(2) = gateway;
// 			NetworkListView->currentItem()->text(3) = interface;
		}
		checkList();
	}
}

void ProfileNetworkRouteOptions::checkList()
{
	if (NetworkListView->childCount() > 0 && NetworkListView->currentItem()!= 0 )
	{
		EditRoutePushButton->setEnabled(true);
		DeleteNetworkRoutePushButton->setEnabled(true);
	}
	else
	{
		EditRoutePushButton->setEnabled(false);
		DeleteNetworkRoutePushButton->setEnabled(false);
	}
}

void ProfileNetworkRouteOptions::contextMenuRequested ( QListViewItem * item, const QPoint &pos, int )
{
	ContextMenu = new QPopupMenu ( 0 );
	if (item != 0)
	{
		ContextMenu->insertItem(i18n("&Edit..."));
		ContextMenu->insertItem(i18n("&Delete..."));
	}
	ContextMenu->insertItem(i18n("&Add..."));
	connect ( ContextMenu, SIGNAL ( activated ( int ) ), this, SLOT ( doContextMenuAction ( int ) ) );
	ContextMenu->show();
	ContextMenu->setGeometry(pos.x(),pos.y(), ContextMenu->width(),ContextMenu->height());
}

void ProfileNetworkRouteOptions::doContextMenuAction ( int action)
{
	QString itemtext = ContextMenu->text ( action );
// 	std::cout << "action: " << itemtext << std::endl;
	if (itemtext == i18n("&Edit..."))
		editNetworkRouteClicked();
	if (itemtext == i18n("&Delete..."))
		delNetworkRouteClicked();
	if (itemtext == i18n("&Add..."))
		addNetworkRouteClicked();
}



