/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "questionnaire.h"
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qbutton.h> // para el exclusivetoggle
#include <qlineedit.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qdatetime.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include "ksociograma.h"
#include <qpixmap.h>
#include <kstandarddirs.h> //para  locate
#include <qtextstream.h> //qWarning
#include <qtimer.h>
#include <qfontmetrics.h>


questionnaire::questionnaire(QWidget* parent, const char* name, WFlags fl, sociometricTest *myTest2, ksociograma *myKsociograma2)
                : frmCuestionario(parent,name,fl), myTest(myTest2), myKsociograma(myKsociograma2)
{

QPixmap myPixmap = QPixmap (locate ("data","ksociograma/pics/logo-ksociograma.png"));
pixmapLabel2->setPixmap(myPixmap);
pixmapLabel2->show();



myButtonGroup = new QButtonGroup ( 3, Qt::Horizontal, i18n("Your group classmates:"), this ); 
myButtonGroup->setGeometry ( 10, 260, 990, 310 );
myButtonGroup->setEnabled(FALSE);

for (int c=0; c<=myTest->getNumeroAlumnosGrupo()-1; ++c)
{
   new QRadioButton(myTest->getNombreAlumno(c+1),myButtonGroup, QString("button%1").arg(c));
}


QObject::connect( myButtonGroup, SIGNAL(clicked(int)), this, SLOT(slotStudentSelected(int) ) );

textLabel6->setText(QDate::currentDate().toString ("dd/MM/yyyy"));


isQuestion0Finished=FALSE;
isQuestion1Finished=FALSE;
isQuestion2Finished=FALSE;
isQuestion3Finished=FALSE;
isQuestion4Finished=FALSE;
lastElectionNumber=0;

// borra todos los label con los nombres elegidos
showStudentsChosen(QString::null);


//bloqueamos el spinBox1 radioButton1 y radioButton2 hasta que se seleccione el
//nombre del sujeto en evaluacion
spinBox1->setEnabled(FALSE);
radioButton1->setEnabled(FALSE);
radioButton2->setEnabled(FALSE);



// timer para el parpadeo inicial del item.
timer_parpadeo =  new QTimer(this);
QObject::connect( timer_parpadeo, SIGNAL(timeout()), this, SLOT(slotTimeOut() ));

}





questionnaire::~questionnaire()
{}
















/*$SPECIALIZATION$*/


/*!
    maneja los click en los radioButtons con el nombre de todos los alumnos del grupo
 */
void questionnaire::slotStudentSelected(int id)
{


//En el caso de un cambio de sexo, hay una llamada desde el
//slotSexChanged a este slot por si se necesita mostrar items.
//Esta llamada slo ser aceptada si el cambio se realiza justo despues
//de solicitar el nombre del alumno. En otro caso, debe no procesarse.
if (id==idStudentInTest-1 and isQuestion0Finished==TRUE) return;





QButton *myButtonSelected;
myButtonSelected = myButtonGroup->find (id); 
QButton *myButton;




// ha hecho click sobre su nombre
if (isQuestion0Finished==FALSE)
{
    for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
    {
        myButton = myButtonGroup->find (c-1); 
        if (myTest->getEsEvaluado(c)==TRUE) myButton->setEnabled(TRUE);
    }
    //    myButtonSelected->setEnabled(FALSE);
    idStudentInTest=id+1; //debe estar definido antes del cambiar el spinBox1 y radioButton1 y radioButton2 o en otro caso el slot detecta cambios y detiene el programa por valor de idStudentInTest arbitrario
    lineEdit1->setText(myTest->getNombreAlumno(idStudentInTest));
    spinBox1->setValue(myTest->getEdadAlumno(idStudentInTest));
    if (myTest->getSexoAlumno(idStudentInTest)=="Hombre") radioButton1->setChecked(TRUE);
    if (myTest->getSexoAlumno(idStudentInTest)=="Mujer") radioButton2->setChecked(TRUE);
    
    //activamos la edad y el sexo ya que conocemos el nombre del sujeto
    spinBox1->setEnabled(TRUE);
    radioButton1->setEnabled(TRUE);
    radioButton2->setEnabled(TRUE);

    if (myTest->getEdadAlumno(idStudentInTest)==0 or myTest->getSexoAlumno(idStudentInTest).length()==0)
    {
    QMessageBox::critical( this, "KSociograma", i18n("Please, complete the data on your age and/or gender boxes before you begin the test. Thanks."));  
    isQuestion0Finished=FALSE;  
    }
    else
    {
    myButtonSelected->setEnabled(FALSE);
    isQuestion0Finished=TRUE;
    textEdit1->setText(myTest->getQuestion1());  
    counter_parpadeo=0;
    timer_parpadeo->start( 150, FALSE ); // 1/4 seconds timer
    }
    

//delete myButton, myButtonSelected;    
return;
}




//ha hecho click sobre un compaero para la pregunta 1
if (isQuestion1Finished==FALSE)
{

if (myTest->getEdadAlumno(idStudentInTest)==0 or myTest->getSexoAlumno(idStudentInTest).length()==0)
{
QMessageBox::critical( this, "KSociograma", i18n("Please, complete the data on your age and/or gender boxes before you begin the test. Thanks."));
}
else 
{    

    myButtonSelected->setEnabled(FALSE);
    if (lastElectionNumber+1<myTest->getNumeroElecciones())
    {
        showStudentsChosen(myTest->getNombreAlumno(id+1));
        myTest->setEleccion(idStudentInTest,lastElectionNumber+1,id+1);
        lastElectionNumber++;
    }

    else
    { //ultima eleccion del ciclo
        showStudentsChosen(QString::null);
        myTest->setEleccion(idStudentInTest,lastElectionNumber+1,id+1);
        textEdit1->setText(myTest->getQuestion2());
	counter_parpadeo=0;
    	timer_parpadeo->start( 150, FALSE ); // 1/4 seconds timer    myButtonSelected->setEnabled(FALSE);
        lastElectionNumber=0;
        isQuestion1Finished=TRUE;
        for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
        {
            myButtonSelected = myButtonGroup->find(c-1);
            if (c!=idStudentInTest) myButtonSelected->setEnabled(TRUE);
        }
	// radiobuttongroup limpio (se vuelve al estudiante en el test)
	myButtonGroup->setButton(idStudentInTest-1);
    }
}
//delete myButton, myButtonSelected;    
return;
}


// ha hecho click sobre un compaero para la pregunta 2
if (isQuestion2Finished==FALSE)
{
    myButtonSelected->setEnabled(FALSE);
    if (lastElectionNumber+1<myTest->getNumeroElecciones())
    {
        showStudentsChosen(myTest->getNombreAlumno(id+1));
        myTest->setRechazo(idStudentInTest,lastElectionNumber+1,id+1);
        lastElectionNumber++;
    }

    else
    { //ultima eleccion del ciclo
        showStudentsChosen(QString::null);
        myTest->setRechazo(idStudentInTest,lastElectionNumber+1,id+1);
        textEdit1->setText(myTest->getQuestion3());
	counter_parpadeo=0;
    	timer_parpadeo->start( 150, FALSE ); // 1/4 seconds timer
        lastElectionNumber=0;
        isQuestion2Finished=TRUE;
        for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
        {
            myButtonSelected = myButtonGroup->find(c-1);
            if (c!=idStudentInTest) myButtonSelected->setEnabled(TRUE);
        }
	// radiobuttongroup limpio (se vuelve al estudiante en el test)
	myButtonGroup->setButton(idStudentInTest-1);
    }
//delete myButton, myButtonSelected;    
return;
}



// ha hecho click sobre un compaero para la pregunta 3
if (isQuestion3Finished==FALSE)
{
    myButtonSelected->setEnabled(FALSE);
    if (lastElectionNumber+1<myTest->getNumeroElecciones())
    {
        showStudentsChosen(myTest->getNombreAlumno(id+1));
        myTest->setPercepcionEleccion(idStudentInTest,lastElectionNumber+1,id+1);
        lastElectionNumber++;
    }

    else
    { //ultima eleccion del ciclo
        showStudentsChosen(QString::null);
        myTest->setPercepcionEleccion(idStudentInTest,lastElectionNumber+1,id+1);
        textEdit1->setText(myTest->getQuestion4());
	counter_parpadeo=0;
    	timer_parpadeo->start( 150, FALSE ); // 1/4 seconds timer
        lastElectionNumber=0;
        isQuestion3Finished=TRUE;
        for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
        {
            myButtonSelected = myButtonGroup->find(c-1);
            if (c!=idStudentInTest) myButtonSelected->setEnabled(TRUE);
        }
	// radiobuttongroup limpio (se vuelve al estudiante en el test)
	myButtonGroup->setButton(idStudentInTest-1);
    }
//delete myButton, myButtonSelected;    
return;
}




// ha hecho click sobre un compaero para la pregunta 4
if (isQuestion4Finished==FALSE)
{
    myButtonSelected->setEnabled(FALSE);
    if (lastElectionNumber+1<myTest->getNumeroElecciones())
    {
        showStudentsChosen(myTest->getNombreAlumno(id+1));
        myTest->setPercepcionRechazo(idStudentInTest,lastElectionNumber+1,id+1);
        lastElectionNumber++;
    }

    else
    { //ultima eleccion del ciclo
        showStudentsChosen(QString::null);
        myTest->setPercepcionRechazo(idStudentInTest,lastElectionNumber+1,id+1);
        myTest->setEsEvaluado(idStudentInTest,TRUE);
        textEdit1->setText(i18n("Thanks to complete the form.\nNow, call your teacher, please.\nSee you later!"));
        lastElectionNumber=0;
        isQuestion4Finished=TRUE;
        for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
        {
            myButtonSelected = myButtonGroup->find(c-1);
            if (c!=idStudentInTest) myButtonSelected->setEnabled(TRUE);
        }
	// radiobuttongroup limpio (se vuelve al estudiante en el test)
	myButtonGroup->setButton(idStudentInTest-1);
	
	// proceso especial para el ultimo click sobre el ultimo alumno en la ultima pregunta del test
        myButtonGroup->setEnabled(FALSE);
        
        //bloqueamos el spinBox1 radioButton1 y radioButton2 para que ya deben
        // de estar respondidos, y el sujeto ha terminado el test
        spinBox1->setEnabled(FALSE);
        radioButton1->setEnabled(FALSE);
        radioButton2->setEnabled(FALSE);
        
        // en el modo de acceso cuestionarios hay que grabar los resultados de
        // este alumno solo en disco, para que no se pierdan
        if (myTest->modeAccess==1) 
        {
            myTest->GrabaRespuestas(idStudentInTest, myTest->getRutaFicheroTest());
        }
        else if (myTest->modeAccess==0)
        {
            myTest->isChangedTest=TRUE;
            myKsociograma->actSave->setEnabled(TRUE);
        }
        else
        {
        qWarning("Internal error at questionnaire::slotSudentSelected");
        }


        

    }
//delete myButton, myButtonSelected;    
return;
}




}



void questionnaire::slotStartTest()
{
pushButton1->setEnabled(FALSE);
textEdit1->setText(i18n("Select your name from the group list pressing on the button.\nDo not forget to complete your age and gender."));

myButtonGroup->setEnabled(TRUE);



QButton *myButton;
for (int c=1; c<=myTest->getNumeroAlumnosGrupo(); c++)
    {
        myButton = myButtonGroup->find (c-1); 
        if (myTest->getEsEvaluado(c)==TRUE) 
        {
            myButton->setEnabled(FALSE);
        }
    }
if (myTest->numberStudentsEvaluated()==myTest->getNumeroAlumnosGrupo() and myTest->getNumeroAlumnosGrupo()>0) 
   QMessageBox::critical( this, "KSociograma", i18n("It is not possible to complete the test with any student more.\nAll the students already have been evaluated."));

if (myTest->getNumeroAlumnosGrupo()==0) 
QMessageBox::critical( this, "KSociograma", i18n("It is not possible to complete the test because there is not introduced any student into the data base."));

}


void questionnaire::closeEvent ( QCloseEvent * event )
{
if (myTest->numberStudentsEvaluated()==myTest->getNumeroAlumnosGrupo() and myTest->getNumeroAlumnosGrupo()>0 and myTest->modeAccess==0) 
   {
    myTest->setTarea4(TRUE);
    myTest->isChangedTest=TRUE;
    myKsociograma->actSave->setEnabled(TRUE);
   }

myKsociograma->questionnaireClosed();
event->accept();

}




/*!
    rellena secuencialmente los nombre de los estudiantes elegido si name no el null
    si name es null entonces borra todos los nombres
 */
void questionnaire::showStudentsChosen(QString name = QString::null)
{
// TODO cambiar este codigo para meterlo mas limpiamente en un GroupBox
if (name==QString::null) 
   {
   textLabel100->setText(QString::null);
   textLabel101->setText(QString::null);
   textLabel102->setText(QString::null);
   textLabel103->setText(QString::null);
   textLabel104->setText(QString::null);
   textLabel105->setText(QString::null);
   textLabel106->setText(QString::null);
   textLabel107->setText(QString::null);
   }
else
   {
   if      (textLabel100->text()==QString::null) textLabel100->setText(name); 
   else if (textLabel101->text()==QString::null) textLabel101->setText(name);
   else if (textLabel102->text()==QString::null) textLabel102->setText(name);
   else if (textLabel103->text()==QString::null) textLabel103->setText(name);
   else if (textLabel104->text()==QString::null) textLabel104->setText(name);
   else if (textLabel105->text()==QString::null) textLabel105->setText(name);
   else if (textLabel106->text()==QString::null) textLabel106->setText(name);
   else if (textLabel107->text()==QString::null) textLabel107->setText(name);
   else qWarning ("Error interno: se ha superado el numero de posibles etiquetas de nombres seleccionados en questionnaire::showStudentsChosen()");
   }
}


void questionnaire::slotYearChanged (int year)
{
myTest->setEdadAlumno(idStudentInTest,year);
myTest->isChangedTest=TRUE;
myKsociograma->actSave->setEnabled(TRUE);

}


void questionnaire::slotSexChanged (int idSex)
{
if (idSex==0) myTest->setSexoAlumno(idStudentInTest,"Hombre");
if (idSex==1) myTest->setSexoAlumno(idStudentInTest,"Mujer");
myTest->isChangedTest=TRUE;
myKsociograma->actSave->setEnabled(TRUE);

// cuando se cambia el sexo en el cuestionario puede ser que
// se espere continuar mostrando items, por tanto hay que llamar al slot
// de pulsacin de alumno en el radiobuttongroup con el id del alumno que est
// realizando el test, es decir, el idStudentInTest-1
slotStudentSelected(idStudentInTest-1);
}



/*!
    timer para el parpadeo
 */
void questionnaire::slotTimeOut()
{

    if (textEdit1->isShown()==FALSE) textEdit1->show();
    else if (textEdit1->isShown()==TRUE) textEdit1->hide();
    
    if (counter_parpadeo==0) myButtonGroup->setEnabled(FALSE);
    counter_parpadeo++; 
    if (counter_parpadeo==10) 
       {
       timer_parpadeo->stop(); 
       counter_parpadeo=0;
       textEdit1->show();
       myButtonGroup->setEnabled(TRUE);
       }

}


#include "questionnaire.moc"







