/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef CAPTUREOPTIONS_H
#define CAPTUREOPTIONS_H

#include <qstring.h>

/**
  This class has all capture options needed to start sniffing

  @author Giovanni Venturi
*/
class CaptureOptions
{
  public:
    CaptureOptions();
    CaptureOptions(const QString& strInterface);
    ~CaptureOptions();

    // set propeties members
    void setSniffingInterface( const QString& str );
    void setSniffingFilename( const QString& filename );
    void setTmpDir( const QString& str);
    void setShowAfter( const bool& display );
    void setTrayBar( const bool& trayBar );
    void setWarning( const bool& warn );
    void setPassiveWarn( const bool& passive );
    void setShowSplash( const bool& splash );
    void setPacketsNumber( const long& number );
    void setPacketsSize( const long& packsize );
    void setPacketsTime( const long& packtime );
    void setPacketsInfoSizeUnits( const int& sizeunit );
    void setPacketsInfoTimeUnits( const int& timeunit );
    void setSniffingType( const QString& sniffType );
    void setRawFramePosition( const QString& position );
    void setShowProtocolName( const bool& display );

    // get properties members
    QString sniffingInterface() const;
    QString sniffingFilename() const;
    QString tmpFilePath() const;
    QString tmpFileConfigPath() const;
    QString tmpDir() const;
    bool showAfter() const;
    bool showTrayBar() const;
    bool showWarning() const;
    bool showPassiveWarn() const;
    bool showSplash() const;
    long packetsNumber() const;
    long packetsSize() const;
    long packetsTime() const;
    int packetsInfoSizeUnits() const;
    int packetsInfoTimeUnits() const;
    int sniffType() const;
    QString sniffingType() const;
    QString rawFramePosition() const;
    bool showProtocolName() const;

  private:
    QString m_strSniffingInterface; // sniffing interface
    QString m_strSniffingFilename;  // name of the file containing sniffed packets
    QString m_strDirTmp;            // sniffing temporary file
    bool m_showAfter;               // true if show packets when you stop sniffing
    bool m_trayBar;                 // true if tray bar's shown
    bool m_warning;                 // true if has to warn if no packet captured when stopped capturing
    bool m_passivePopUp;            // true if has to warn with a passive pop up
    bool m_showSplash;              // true if the splash screen has to be shown

    long m_packetsNumber;
    long m_packetsSize;
    long m_packetsTime;
    int m_packetsInfoSizeUnits;
    int m_packetsInfoTimeUnits;
    int m_sniffType;

    QString m_rawFramePosition;

    bool m_showProtocolName;
};

#endif
