/***************************************************************************
                          batchrenamer.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHRENAMER_H
#define BATCHRENAMER_H

#include <qdatetime.h>
#include <qvaluelist.h>
#include <kurl.h>

class QFile;
class QProgressDialog;
class QString;

/* How many diferrent users and groups
 * KRename supports. Values over 1000
 * make KRename slow, but it may be
 * necessary on bigger systems to
 * increase this value.
 * MAXENTRIES must be < sizeof(int)
 */
#define MAXENTRIES 1000

/* May Value for SpinBoxes
 *
 */
#define SPINMAX 100000

enum {
    COPY, MOVE, RENAME, PREVIEW, LINK
};

typedef struct fileentry {
    QString name;       // filename
    QString directory;  // directory
    QString extension;  // extension

    KURL url;
};

typedef struct data {
    fileentry src;
    fileentry dst;

    bool dir;
};

/*
 * Changes made by hand by the user
 * in the preview list view are
 * stored here.
 */
typedef struct manualchanges {
    KURL url;      // input filename
    QString user;  // name the user wants
};

typedef struct replacestrings {
    QString find;      // Text to replace
    QString replace;   // Replace with
    bool reg;          // is it a reg expression ?
};

typedef struct tCounterValues {
    int value;  // current value of this counter
    int start;  // start value of this counter (for findResetCounter)
    int step;   // stepping value of this counter;
};

/**
  *@author Dominik Seichter
  */

class QObject;
class QListView;
class ProgressDialog;
class PluginLoader;
class BatchRenamer {
    public:
        BatchRenamer();
        ~BatchRenamer();
        void processFiles( ProgressDialog* p, QObject* object );
        void createPreview( QListView* list );

        inline void setText( const QString & t ) { text = t; doEscape( text, false ); }
        inline void setExText( const QString & t ) { extext = t; }
        inline void setDirname( const KURL & url ) { dirname = url; }
        inline void setUndoScript( const QString & t ) { m_undoScript = t; }
        inline void setUndo( bool b ) { undo = b; }
        inline void setOverwrite( bool b ) { overwrite = b; }
        inline void setIndex( int i ) { m_index = i; }
        inline void setStep( int s ) { m_step = s; }
	inline void setResetCounter( bool r ) { m_reset = r; }
        inline void setSkipList( const QValueList<int> & s ) { m_skip = s; }
        inline void setReplaceList( const QValueList<replacestrings> & r ) { m_replace = r; }
        
        inline void setFiles( const QValueList<data> & f ) { m_files = f; } //TODO: use a pointer for more speed
        inline QValueList<data> files() const { return m_files; }
        inline void setChanges( const QValueList<manualchanges> & m ) { m_changes = m; }

        inline void setMode( int m) { m_mode = m; }
        inline int mode() const { return m_mode; }

        // Since 2.1 public, because plugins may want to access them to:
        QString findAndProcess( const QString & token, QString text, const QString & replace );

        QString findNumbers( QString text, int count, int i );
        QString findStar( const QString & oldname, QString text );
        QString findBrackets( QString oldname, QString text, int i );
        QString findToken( QString oldname, QString token, int i );
        QString processToken( QString token, QString oldname, int i );
        QString findPartStrings( QString oldname, QString token );
        static QString findDirName( QString token, QString path );
        QString findLength( const QString & token, const QString & name );
        QString findReplace( QString text );  // text is here already the new filename !
        QString doReplace( QString text, QString find, QString replace, bool reg ); // text is here already the new filename !

        QString processString( QString text, QString oldname, int i );
        
        static QString & doEscape( QString & text, bool filename = true );
        static QString & unEscape( QString & text );
        static void escape( QString & text, const QString & token, const QString & sequence );

        static QString buildFilename( fileentry* entry, bool dir = true );

    private:
        /** 
         * Returns the length of the string when int n is converted to
         * a string.
         * @param n   a number whose length as string is needed
         * @returns stringlength of n converted to a string 
         */
        int getCharacters( int n ) ;

        void work( ProgressDialog* p );
        void writeUndoScript( QTextStream* t );
        void parseSubdirs( data* f );
        void findNumberAppendix( QString & text, int pos, int* start, int* step );
	/** resets all counters to there start value if the directory name at @p i
	 *  in m_files changes.
	 *  The caller has to check m_reset before calling this function.
	 */
        void findCounterReset( int i );
        QString parsePlugins( int i, const QString & text, int type );
        bool applyManualChanges( int i );

        QString text;           // template
        KURL dirname;           // destination dir
        QString extext;         // Extension template
        QString m_undoScript;     // Filename of undoscript
        bool undo;              // create an undo script
        int m_index;              // index for numbers
        int m_step;               // step for numbers
	bool m_reset;             // reset counter on new directories
        bool overwrite;         // overwrite existing files
        int m_mode;             // renaming mode
        QValueList<int> m_skip; // Numbers to skip
        QValueList<replacestrings> m_replace; // Replace strings
        QValueList<data> m_files;
        QValueList<manualchanges> m_changes;  // User made changes
        PluginLoader* plug;

        // a is used in find number and
        // required for skipping.
        int m_counter_index;
	QValueList<tCounterValues> m_counters;
        
    protected:
        QFile* f;
        QTime t;
        QProgressDialog* progress;
};

#endif
