/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * lib/crypto/krb/checksum/cbc.c
 *
 * Copyright (C) 2009 by the Massachusetts Institute of Technology.
 * All rights reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * CBC checksum, which computes the ivec resulting from CBC encryption of the
 * input.
 */

#include "k5-int.h"
#include "cksumtypes.h"

krb5_error_code
krb5int_cbc_checksum(const struct krb5_cksumtypes *ctp,
                     krb5_key key, krb5_keyusage usage,
                     const krb5_crypto_iov *data, size_t num_data,
                     krb5_data *output)
{
    if (ctp->enc->cbc_mac == NULL)
        return KRB5_CRYPTO_INTERNAL;
    return ctp->enc->cbc_mac(key, data, num_data, NULL, output);
}
